/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.screens;

import de.teamlapen.lib.lib.inventory.InventoryHelper;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionData;
import de.teamlapen.vampirism.items.OblivionItem;
import de.teamlapen.vampirism.network.ServerboundUpgradeMinionStatPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MinionStatsScreen<T extends MinionData, Q extends MinionEntity<T>>
extends Screen {
    private static final ResourceLocation BACKGROUND = VResourceLocation.mod("textures/gui/appearance.png");
    private static final WidgetSprites RESET = new WidgetSprites(VResourceLocation.mod("widget/reset"), VResourceLocation.mod("widget/reset_highlighted"));
    protected final Q entity;
    protected final int xSize = 256;
    protected final int ySize = 177;
    protected final int statCount;
    @Nullable
    protected final Screen backScreen;
    private final MutableComponent textLevel = Component.translatable((String)"text.vampirism.level");
    private final List<Button> statButtons = new ArrayList<Button>();
    protected int guiLeft;
    protected int guiTop;
    private Button reset;

    protected MinionStatsScreen(Q entity, int statCount, @Nullable Screen backScreen) {
        super((Component)Component.translatable((String)"gui.vampirism.minion_stats"));
        assert (statCount > 0);
        this.entity = entity;
        this.statCount = statCount;
        this.backScreen = backScreen;
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.drawTitle(graphics);
        ((MinionEntity)this.entity).getMinionData().ifPresent(d -> this.renderStats(graphics, d));
    }

    public void renderBackground(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.renderBackground(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.renderGuiBackground(pGuiGraphics);
    }

    public void tick() {
        for (int i = 0; i < this.statCount; ++i) {
            int finalI = i;
            this.statButtons.get((int)i).active = ((MinionEntity)this.entity).getMinionData().map(d -> this.isActive(d, finalI)).orElse(false);
            this.statButtons.get((int)i).visible = ((MinionEntity)this.entity).getMinionData().map(this::areButtonsVisible).orElse(false);
        }
        this.reset.active = ((MinionEntity)this.entity).getMinionData().map(MinionData::hasUsedSkillPoints).orElse(false) != false && this.getOblivionPotion().isPresent();
    }

    protected abstract boolean areButtonsVisible(T var1);

    protected abstract int getRemainingStatPoints(T var1);

    protected void init() {
        this.statButtons.clear();
        this.guiLeft = (this.width - this.xSize) / 2;
        this.guiTop = (this.height - this.ySize) / 2;
        this.addRenderableWidget((GuiEventListener)new ExtendedButton(this.guiLeft + this.xSize - 80 - 20, this.guiTop + 152, 80, 20, (Component)Component.translatable((String)"gui.done"), context -> this.onClose()));
        if (this.backScreen != null) {
            this.addRenderableWidget((GuiEventListener)new ExtendedButton(this.guiLeft + 20, this.guiTop + 152, 80, 20, (Component)Component.translatable((String)"gui.back"), context -> Minecraft.getInstance().setScreen(this.backScreen)));
        }
        for (int i = 0; i < this.statCount; ++i) {
            int finalI = i;
            Button button = (Button)this.addRenderableWidget((GuiEventListener)new ExtendedButton(this.guiLeft + 225, this.guiTop + 43 + 26 * i, 20, 20, (Component)Component.literal((String)"+"), b -> VampirismMod.proxy.sendToServer(new ServerboundUpgradeMinionStatPacket(this.entity.getId(), finalI))));
            this.statButtons.add(button);
            button.visible = false;
        }
        this.reset = (Button)this.addRenderableWidget((GuiEventListener)new ImageButton(this, this.guiLeft + 225, this.guiTop + 8, 20, 20, RESET, pButton -> {
            VampirismMod.proxy.sendToServer(new ServerboundUpgradeMinionStatPacket(this.entity.getId(), -1));
            this.getOblivionPotion().ifPresent(stack -> stack.shrink(1));
        }, (Component)Component.translatable((String)"text.vampirism.minion_screen.reset_stats", (Object[])new Object[]{((OblivionItem)((Object)ModItems.OBLIVION_POTION.get())).getDescription()})){

            public void renderWidget(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
                if (!this.active) {
                    pGuiGraphics.setColor(0.65f, 0.65f, 0.65f, 1.0f);
                }
                super.renderWidget(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
            }
        });
        this.reset.setTooltip(Tooltip.create((Component)Component.translatable((String)"text.vampirism.minion_screen.reset_stats", (Object[])new Object[]{((OblivionItem)((Object)ModItems.OBLIVION_POTION.get())).getDescription()})));
        this.reset.active = false;
    }

    protected abstract boolean isActive(T var1, int var2);

    protected void renderGuiBackground(@NotNull GuiGraphics graphics) {
        graphics.blit(BACKGROUND, this.guiLeft, this.guiTop, 0, 0.0f, 0.0f, this.xSize, this.ySize, 300, 256);
    }

    protected void renderLevelRow(@NotNull GuiGraphics graphics, int current, int max) {
        graphics.drawString(this.font, (Component)this.textLevel, this.guiLeft + 10, this.guiTop + 30, 0, false);
        graphics.drawString(this.font, current + "/" + max, this.guiLeft + 145, this.guiTop + 30, 0x404040, false);
        int remainingPoints = ((MinionEntity)this.entity).getMinionData().map(this::getRemainingStatPoints).orElse(0);
        if (remainingPoints > 0) {
            graphics.drawString(this.font, "(" + remainingPoints + ")", this.guiLeft + 228, this.guiTop + 30, 0x404040, false);
        }
        graphics.hLine(this.guiLeft + 10, this.guiLeft + 256 - 10, this.guiTop + 40, -265277392);
    }

    protected void renderStatRow(@NotNull GuiGraphics graphics, int i, @NotNull MutableComponent name, @NotNull Component value, int currentLevel, int maxLevel) {
        graphics.drawString(this.font, (Component)name.append(":"), this.guiLeft + 10, this.guiTop + 50 + 26 * i, 0x404040, false);
        graphics.drawString(this.font, value, this.guiLeft + 145, this.guiTop + 50 + 26 * i, 0x404040, false);
        graphics.drawString(this.font, (Component)Component.translatable((String)"text.vampirism.level_short").append(": " + currentLevel + "/" + maxLevel), this.guiLeft + 175, this.guiTop + 50 + 26 * i, 0x404040, false);
    }

    protected void renderStats(GuiGraphics graphics, T data) {
    }

    private void drawTitle(@NotNull GuiGraphics graphics) {
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.drawString(this.font, this.title, this.guiLeft + 10, this.guiTop + 10, -1, true);
    }

    @NotNull
    private Optional<ItemStack> getOblivionPotion() {
        return Optional.ofNullable(((MinionEntity)this.entity).getMinionData().flatMap(data -> Optional.ofNullable(InventoryHelper.getFirst(data.getInventory(), (Item)ModItems.OBLIVION_POTION.get()))).orElse(InventoryHelper.getFirst((Container)this.minecraft.player.getInventory(), (Item)ModItems.OBLIVION_POTION.get())));
    }
}

