/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.screens;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.entity.player.hunter.HunterLeveling;
import de.teamlapen.vampirism.inventory.HunterTrainerMenu;
import de.teamlapen.vampirism.network.ServerboundSimpleInputEvent;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.CyclingSlotBackground;
import net.minecraft.client.gui.screens.inventory.ItemCombinerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import org.jetbrains.annotations.NotNull;

public class HunterTrainerScreen
extends ItemCombinerScreen<HunterTrainerMenu> {
    private static final ResourceLocation BACKGROUND = VResourceLocation.mod("textures/gui/container/hunter_trainer.png");
    private static final ResourceLocation EMPTY_INGOT = VResourceLocation.mc("item/empty_slot_ingot");
    private static final ResourceLocation EMPTY_INTEL = VResourceLocation.mod("item/empty_hunter_intel");
    private Button buttonLevelup;
    private final CyclingSlotBackground ironIcon = new CyclingSlotBackground(0);
    private final CyclingSlotBackground goldIcon = new CyclingSlotBackground(1);
    private final CyclingSlotBackground hunterIntel = new CyclingSlotBackground(2);
    private final ItemStack iron = Items.IRON_INGOT.getDefaultInstance();
    private final ItemStack gold = Items.GOLD_INGOT.getDefaultInstance();

    public HunterTrainerScreen(@NotNull HunterTrainerMenu inventorySlotsIn, @NotNull Inventory playerInventory, @NotNull Component name) {
        super((ItemCombinerMenu)inventorySlotsIn, playerInventory, name, BACKGROUND);
    }

    protected void containerTick() {
        super.containerTick();
        Optional<HunterLeveling.HunterTrainerRequirement> requirement = ((HunterTrainerMenu)this.menu).getRequirement();
        this.ironIcon.tick(requirement.filter(s -> s.ironQuantity() > 0).map(s -> List.of(EMPTY_INGOT)).orElse(List.of()));
        this.goldIcon.tick(requirement.filter(s -> s.goldQuantity() > 0).map(s -> List.of(EMPTY_INGOT)).orElse(List.of()));
        this.hunterIntel.tick(requirement.map(s -> List.of(EMPTY_INTEL)).orElse(List.of()));
    }

    public void slotChanged(@NotNull AbstractContainerMenu pContainerToSend, int pSlotInd, @NotNull ItemStack pStack) {
        this.buttonLevelup.active = ((HunterTrainerMenu)this.menu).canLevelup();
    }

    public void render(@NotNull GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(graphics, pMouseX, pMouseY, pPartialTick);
        this.renderOnBoardingTooltips(graphics, pMouseX, pMouseY);
    }

    private void renderOnBoardingTooltips(GuiGraphics graphics, int pMouseX, int pMouseY) {
        if (this.hoveredSlot != null && this.hoveredSlot.index < 3) {
            ItemStack stack;
            Optional<Object> optional = Optional.empty();
            Optional<HunterLeveling.HunterTrainerRequirement> req = ((HunterTrainerMenu)this.menu).getRequirement();
            Integer missing = req.map(arg_0 -> this.lambda$renderOnBoardingTooltips$5(stack = this.hoveredSlot.getItem(), arg_0)).orElse(0);
            if (missing > 0) {
                Object[] objectArray = new Object[2];
                objectArray[0] = missing;
                objectArray[1] = (switch (this.hoveredSlot.index) {
                    case 0 -> this.iron.getHoverName();
                    case 1 -> this.gold.getHoverName();
                    case 2 -> req.map(s -> s.tableRequirement().resultIntelItem().get().getCustomName()).orElseGet(Component::empty);
                    default -> throw new IllegalStateException("Unexpected value: " + this.hoveredSlot.index);
                }).getString();
                optional = Optional.of(Component.translatable((String)"text.vampirism.hunter_trainer.ritual_missing_items", (Object[])objectArray));
            }
            optional.ifPresent(p_274684_ -> graphics.renderTooltip(this.font, this.font.split((FormattedText)p_274684_, 115), pMouseX, pMouseY));
        }
    }

    protected void subInit() {
        MutableComponent name = Component.translatable((String)"text.vampirism.level_up");
        int buttonWidth = this.font.width((FormattedText)name) + 10;
        this.buttonLevelup = new ExtendedButton(this.leftPos + this.imageWidth - buttonWidth - 6, this.topPos + 45, buttonWidth, 20, (Component)name, context -> {
            VampirismMod.proxy.sendToServer(new ServerboundSimpleInputEvent(ServerboundSimpleInputEvent.Event.TRAINER_LEVELUP));
            LocalPlayer player = Minecraft.getInstance().player;
            UtilLib.spawnParticles(player.getCommandSenderWorld(), (ParticleOptions)ParticleTypes.ENCHANT, player.getX(), player.getY(), player.getZ(), 1.0, 1.0, 1.0, 100, 1.0f);
            player.playSound((SoundEvent)SoundEvents.NOTE_BLOCK_HARP.value(), 4.0f, (1.0f + (player.getRandom().nextFloat() - player.getRandom().nextFloat()) * 0.2f) * 0.7f);
            this.onClose();
        });
        this.addRenderableWidget((GuiEventListener)this.buttonLevelup);
        this.buttonLevelup.active = false;
    }

    protected void renderBg(@NotNull GuiGraphics graphics, float var1, int var2, int var3) {
        super.renderBg(graphics, var1, var2, var3);
        this.ironIcon.render(this.menu, graphics, var1, this.leftPos, this.topPos);
        this.goldIcon.render(this.menu, graphics, var1, this.leftPos, this.topPos);
        this.hunterIntel.render(this.menu, graphics, var1, this.leftPos, this.topPos);
    }

    protected void renderErrorIcon(@NotNull GuiGraphics graphics, int mouseX, int mouseY) {
    }

    private /* synthetic */ Integer lambda$renderOnBoardingTooltips$5(ItemStack stack, HunterLeveling.HunterTrainerRequirement s) {
        return switch (this.hoveredSlot.index) {
            case 0 -> s.ironQuantity() - stack.getCount();
            case 1 -> s.goldQuantity() - stack.getCount();
            case 2 -> 1 - stack.getCount();
            default -> 0;
        };
    }
}

