/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.screens;

import de.teamlapen.lib.lib.client.gui.ProgressBar;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.blockentity.GarlicDiffuserBlockEntity;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class GarlicDiffuserScreen
extends Screen {
    private static final ResourceLocation BACKGROUND = VResourceLocation.mod("textures/gui/garlic_diffuser.png");
    protected final int xSize = 220;
    protected final int ySize = 114;
    private final GarlicDiffuserBlockEntity tile;
    protected int guiLeft;
    protected int guiTop;
    protected ProgressBar startupBar;
    protected ProgressBar fueledTimer;

    public GarlicDiffuserScreen(GarlicDiffuserBlockEntity tile, @NotNull Component title) {
        super(title);
        this.tile = tile;
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.drawTitle(graphics);
    }

    private void updateProgress() {
        this.startupBar.setProgress(this.tile.getBootProgress());
        float f = this.tile.getFueledState();
        if (f == 0.0f) {
            this.fueledTimer.active = false;
        } else {
            this.fueledTimer.active = true;
            this.fueledTimer.setProgress(f);
        }
    }

    public void tick() {
        this.updateProgress();
    }

    protected void init() {
        this.guiLeft = (this.width - this.xSize) / 2;
        this.guiTop = (this.height - this.ySize) / 2;
        this.startupBar = (ProgressBar)this.addRenderableWidget((GuiEventListener)new ProgressBar(this.guiLeft + 25, this.guiTop + 30, 170, (Component)Component.translatable((String)"gui.vampirism.garlic_diffuser.startup")));
        this.startupBar.setColor(0xD0D0FF);
        this.startupBar.setFGColor(0xFFFFFF);
        this.fueledTimer = (ProgressBar)this.addRenderableWidget((GuiEventListener)new ProgressBar(this.guiLeft + 25, this.guiTop + 60, 170, (Component)Component.translatable((String)"gui.vampirism.garlic_diffuser.fueled")));
        this.fueledTimer.setColor(0xD0FFD0);
        this.fueledTimer.setFGColor(0xFFFFFF);
        this.updateProgress();
    }

    public void renderBackground(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.renderBackground(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        pGuiGraphics.blit(BACKGROUND, this.guiLeft, this.guiTop, 0, 0.0f, 0.0f, this.xSize, this.ySize, 256, 256);
    }

    private void drawTitle(@NotNull GuiGraphics graphics) {
        graphics.drawString(this.font, this.title, this.guiLeft + 15, this.guiTop + 5, -1, false);
    }
}

