/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public abstract class TextureOverlay
implements LayeredDraw.Layer {
    protected final Minecraft mc = Minecraft.getInstance();

    protected void renderTextureOverlay(GuiGraphics pGuiGraphics, ResourceLocation pShaderLocation, float pAlpha) {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        pGuiGraphics.setColor(1.0f, 1.0f, 1.0f, pAlpha);
        pGuiGraphics.blit(pShaderLocation, 0, 0, -90, 0.0f, 0.0f, pGuiGraphics.guiWidth(), pGuiGraphics.guiHeight(), pGuiGraphics.guiWidth(), pGuiGraphics.guiHeight());
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        pGuiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected void scaleBy(float progress, float type, float start, float end, GuiGraphics graphics) {
        int i = graphics.guiWidth();
        int j = graphics.guiHeight();
        float f = TextureOverlay.lerp(progress, type, start, end);
        graphics.pose().translate((float)i / 2.0f, (float)j / 2.0f, 0.0f);
        graphics.pose().scale(f, f, f);
        graphics.pose().translate((float)(-i) / 2.0f, (float)(-j) / 2.0f, 0.0f);
    }

    protected static float lerp(float progress, double type, float start, float end) {
        return Mth.lerp((float)((float)Math.pow(progress, type) / (float)Math.pow(1.0, type)), (float)start, (float)end);
    }
}

