/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.core;

import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinementSet;
import de.teamlapen.vampirism.api.items.IArrowContainer;
import de.teamlapen.vampirism.api.items.IRefinementItem;
import de.teamlapen.vampirism.api.items.IVampirismCrossbow;
import de.teamlapen.vampirism.api.items.oil.IOil;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.client.extensions.ItemExtensions;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModDataComponents;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.items.CrossbowArrowItem;
import de.teamlapen.vampirism.items.component.BottleBlood;
import de.teamlapen.vampirism.items.component.OilContent;
import de.teamlapen.vampirism.items.crossbow.VampirismCrossbowItem;
import java.util.stream.Stream;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.client.event.RegisterItemDecorationsEvent;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import org.jetbrains.annotations.NotNull;

public class ModItemsRender {
    public static final ResourceLocation CHARGED = VResourceLocation.mod("charged");
    public static final ResourceLocation FILLED = VResourceLocation.mod("filled");
    public static final ResourceLocation BLOOD = VResourceLocation.mod("blood");

    public static void registerItemModelPropertyUnsafe() {
        Stream.of((VampirismCrossbowItem)ModItems.BASIC_CROSSBOW.get(), (VampirismCrossbowItem)ModItems.BASIC_DOUBLE_CROSSBOW.get(), (VampirismCrossbowItem)ModItems.ENHANCED_CROSSBOW.get(), (VampirismCrossbowItem)ModItems.ENHANCED_DOUBLE_CROSSBOW.get(), (VampirismCrossbowItem)ModItems.BASIC_TECH_CROSSBOW.get(), (VampirismCrossbowItem)ModItems.ENHANCED_TECH_CROSSBOW.get()).forEach(item -> ItemProperties.register((Item)item, (ResourceLocation)CHARGED, (stack, world, entity, tint) -> CrossbowItem.isCharged((ItemStack)stack) ? 0.0f : 1.0f));
        ItemProperties.register((Item)((Item)ModItems.ARROW_CLIP.get()), (ResourceLocation)FILLED, (stack, world, entity, tint) -> (float)((IArrowContainer)stack.getItem()).getArrows(stack).size() / (float)((IArrowContainer)stack.getItem()).getMaxArrows(stack));
        ItemProperties.register((Item)((Item)ModItems.BLOOD_BOTTLE.get()), (ResourceLocation)BLOOD, (stack, world, entity, tint) -> (float)((BottleBlood)stack.getOrDefault(ModDataComponents.BOTTLE_BLOOD, (Object)BottleBlood.EMPTY)).blood() / 9.0f);
    }

    static void registerColors(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> tintIndex > 0 ? -1 : DyedItemColor.getOrDefault((ItemStack)stack, (int)-1), new ItemLike[]{(ItemLike)ModItems.ARMOR_OF_SWIFTNESS_FEET_NORMAL.get(), (ItemLike)ModItems.ARMOR_OF_SWIFTNESS_CHEST_NORMAL.get(), (ItemLike)ModItems.ARMOR_OF_SWIFTNESS_HEAD_NORMAL.get(), (ItemLike)ModItems.ARMOR_OF_SWIFTNESS_LEGS_NORMAL.get(), (ItemLike)ModItems.ARMOR_OF_SWIFTNESS_FEET_ENHANCED.get(), (ItemLike)ModItems.ARMOR_OF_SWIFTNESS_CHEST_ENHANCED.get(), (ItemLike)ModItems.ARMOR_OF_SWIFTNESS_HEAD_ENHANCED.get(), (ItemLike)ModItems.ARMOR_OF_SWIFTNESS_LEGS_ENHANCED.get(), (ItemLike)ModItems.ARMOR_OF_SWIFTNESS_FEET_ULTIMATE.get(), (ItemLike)ModItems.ARMOR_OF_SWIFTNESS_CHEST_ULTIMATE.get(), (ItemLike)ModItems.ARMOR_OF_SWIFTNESS_HEAD_ULTIMATE.get(), (ItemLike)ModItems.ARMOR_OF_SWIFTNESS_LEGS_ULTIMATE.get()});
        event.register((stack, tintIndex) -> {
            if (tintIndex == 1) {
                return ((CrossbowArrowItem)stack.getItem()).getType().color;
            }
            return -1;
        }, new ItemLike[]{(ItemLike)ModItems.CROSSBOW_ARROW_NORMAL.get(), (ItemLike)ModItems.CROSSBOW_ARROW_VAMPIRE_KILLER.get(), (ItemLike)ModItems.CROSSBOW_ARROW_SPITFIRE.get(), (ItemLike)ModItems.CROSSBOW_ARROW_TELEPORT.get()});
        event.register((state, tintIndex) -> 0x1E1F1F, new ItemLike[]{(ItemLike)ModBlocks.DARK_SPRUCE_LEAVES.get()});
        event.register((stack, tintIndex) -> {
            IRefinementSet set;
            if (tintIndex == 1 && stack.getItem() instanceof IRefinementItem && (set = ((IRefinementItem)stack.getItem()).getRefinementSet(stack)) != null) {
                return set.getColor() | 0xFF000000;
            }
            return -1;
        }, new ItemLike[]{(ItemLike)ModItems.AMULET.get(), (ItemLike)ModItems.RING.get(), (ItemLike)ModItems.OBI_BELT.get()});
        event.register((stack, tintIndex) -> {
            if (tintIndex == 1) {
                return ((IOil)OilContent.getOil(stack).value()).getColor() | 0xFF000000;
            }
            return -1;
        }, new ItemLike[]{(ItemLike)ModItems.OIL_BOTTLE.get()});
    }

    public static void registerItemDecorator(RegisterItemDecorationsEvent event) {
        Stream.of(ModItems.BASIC_CROSSBOW, ModItems.ENHANCED_CROSSBOW, ModItems.BASIC_DOUBLE_CROSSBOW, ModItems.ENHANCED_DOUBLE_CROSSBOW).forEach(item -> event.register((ItemLike)item.get(), (graphics, font, stack, xOffset, yOffset) -> {
            ((IVampirismCrossbow)stack.getItem()).getAmmunition(stack).ifPresent(ammo -> {
                PoseStack posestack = graphics.pose();
                posestack.pushPose();
                posestack.translate((float)xOffset, (float)(yOffset + 8), 0.0f);
                posestack.scale(0.5f, 0.5f, 0.5f);
                graphics.renderItem(ammo.getDefaultInstance(), 0, 0);
                posestack.popPose();
            });
            return false;
        }));
    }

    public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(ItemExtensions.HUNTER_HAT, new Item[]{(Item)ModItems.HUNTER_HAT_HEAD_0.get(), (Item)ModItems.HUNTER_HAT_HEAD_1.get()});
        event.registerItem(ItemExtensions.MOTHER_TROPHY, new Item[]{ModBlocks.MOTHER_TROPHY.asItem()});
        event.registerItem(ItemExtensions.VAMPIRE_CLOAK, new Item[]{(Item)ModItems.VAMPIRE_CLOAK_BLACK_BLUE.get(), (Item)ModItems.VAMPIRE_CLOAK_BLACK_RED.get(), (Item)ModItems.VAMPIRE_CLOAK_RED_BLACK.get(), (Item)ModItems.VAMPIRE_CLOAK_BLACK_WHITE.get(), (Item)ModItems.VAMPIRE_CLOAK_WHITE_BLACK.get()});
        event.registerItem(ItemExtensions.VAMPIRE_CLOTHING, new Item[]{(Item)ModItems.VAMPIRE_CLOTHING_CROWN.get(), (Item)ModItems.VAMPIRE_CLOTHING_HAT.get(), (Item)ModItems.VAMPIRE_CLOTHING_LEGS.get(), (Item)ModItems.VAMPIRE_CLOTHING_BOOTS.get()});
    }
}

