/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.vampirism.blocks.TotemTopBlock;
import de.teamlapen.vampirism.blocks.VampirismBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class TotemBaseBlock
extends VampirismBlock {
    private static final VoxelShape shape = TotemBaseBlock.makeShape();

    @NotNull
    private static VoxelShape makeShape() {
        VoxelShape a = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0);
        VoxelShape b = Block.box((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0);
        VoxelShape c = Block.box((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)3.0, (double)13.0);
        VoxelShape d1 = Block.box((double)4.0, (double)3.0, (double)4.0, (double)7.0, (double)16.0, (double)7.0);
        VoxelShape d2 = Block.box((double)9.0, (double)3.0, (double)4.0, (double)12.0, (double)16.0, (double)7.0);
        VoxelShape d3 = Block.box((double)4.0, (double)3.0, (double)9.0, (double)7.0, (double)16.0, (double)12.0);
        VoxelShape d4 = Block.box((double)9.0, (double)3.0, (double)9.0, (double)12.0, (double)16.0, (double)12.0);
        VoxelShape e = Block.box((double)5.0, (double)3.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
        return Shapes.or((VoxelShape)a, (VoxelShape[])new VoxelShape[]{b, c, d1, d2, d3, d4, e});
    }

    public TotemBaseBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(40.0f, 2000.0f).sound(SoundType.STONE).noOcclusion().pushReaction(PushReaction.BLOCK));
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return shape;
    }

    public boolean onDestroyedByPlayer(BlockState state, @NotNull Level world, @NotNull BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockPos up = pos.above();
        BlockState upState = world.getBlockState(pos.above());
        if (upState.getBlock() instanceof TotemTopBlock) {
            BlockEntity upTE = world.getBlockEntity(pos.above());
            if (!upState.getBlock().onDestroyedByPlayer(upState, world, pos.above(), player, willHarvest, fluid)) {
                return false;
            }
            if (willHarvest) {
                Block.dropResources((BlockState)upState, (LevelAccessor)world, (BlockPos)up, (BlockEntity)upTE);
            }
        }
        return super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
    }
}

