/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.mojang.datafixers.util.Pair;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.blocks.VampirismBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.items.TentItem;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class TentBlock
extends VampirismBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final IntegerProperty POSITION = IntegerProperty.create((String)"position", (int)0, (int)3);
    @NotNull
    private static final Table<Direction, Integer, VoxelShape> shapes;
    @NotNull
    private static final Map<Player.BedSleepingProblem, Component> sleepResults;
    @NotNull
    private static final Table<Integer, Direction, Pair<Double, Double>> offsets;

    public static void setTentSleepPosition(@NotNull Player player, @NotNull BlockPos blockPos, int position, Direction facing) {
        player.setPos((double)blockPos.getX() + (Double)((Pair)offsets.get((Object)position, (Object)facing)).getFirst(), (double)blockPos.getY() + 0.0625, (double)blockPos.getZ() + (Double)((Pair)offsets.get((Object)position, (Object)facing)).getSecond());
    }

    @NotNull
    private static VoxelShape makeShape() {
        return Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.5, (double)1.0, (double)0.0, (double)1.4, (double)1.45, (double)16.0), Block.box((double)0.9, (double)1.4, (double)0.0, (double)1.8, (double)1.85, (double)16.0), Block.box((double)1.3, (double)1.8, (double)0.0, (double)2.2, (double)2.25, (double)16.0), Block.box((double)1.7, (double)2.2, (double)0.0, (double)2.6, (double)2.65, (double)16.0), Block.box((double)2.1, (double)2.6, (double)0.0, (double)3.0, (double)3.05, (double)16.0), Block.box((double)2.5, (double)3.0, (double)0.0, (double)3.4, (double)3.45, (double)16.0), Block.box((double)2.9, (double)3.4, (double)0.0, (double)3.8, (double)3.85, (double)16.0), Block.box((double)3.3, (double)3.8, (double)0.0, (double)4.2, (double)4.25, (double)16.0), Block.box((double)3.7, (double)4.2, (double)0.0, (double)4.6, (double)4.65, (double)16.0), Block.box((double)4.1, (double)4.6, (double)0.0, (double)5.0, (double)5.05, (double)16.0), Block.box((double)4.5, (double)5.0, (double)0.0, (double)5.4, (double)5.45, (double)16.0), Block.box((double)4.9, (double)5.4, (double)0.0, (double)5.8, (double)5.85, (double)16.0), Block.box((double)5.3, (double)5.8, (double)0.0, (double)6.2, (double)6.25, (double)16.0), Block.box((double)5.7, (double)6.2, (double)0.0, (double)6.6, (double)6.65, (double)16.0), Block.box((double)6.1, (double)6.6, (double)0.0, (double)7.0, (double)7.05, (double)16.0), Block.box((double)6.5, (double)7.0, (double)0.0, (double)7.4, (double)7.45, (double)16.0), Block.box((double)6.9, (double)7.4, (double)0.0, (double)7.8, (double)7.85, (double)16.0), Block.box((double)7.3, (double)7.8, (double)0.0, (double)8.2, (double)8.25, (double)16.0), Block.box((double)7.7, (double)8.2, (double)0.0, (double)8.6, (double)8.65, (double)16.0), Block.box((double)8.1, (double)8.6, (double)0.0, (double)9.0, (double)9.05, (double)16.0), Block.box((double)8.5, (double)9.0, (double)0.0, (double)9.4, (double)9.45, (double)16.0), Block.box((double)8.9, (double)9.4, (double)0.0, (double)9.8, (double)9.85, (double)16.0), Block.box((double)9.3, (double)9.8, (double)0.0, (double)10.2, (double)10.25, (double)16.0), Block.box((double)9.7, (double)10.2, (double)0.0, (double)10.6, (double)10.65, (double)16.0), Block.box((double)10.1, (double)10.6, (double)0.0, (double)11.0, (double)11.05, (double)16.0), Block.box((double)10.5, (double)11.0, (double)0.0, (double)11.4, (double)11.45, (double)16.0), Block.box((double)10.9, (double)11.4, (double)0.0, (double)11.8, (double)11.85, (double)16.0), Block.box((double)11.3, (double)11.8, (double)0.0, (double)12.2, (double)12.25, (double)16.0), Block.box((double)11.7, (double)12.2, (double)0.0, (double)12.6, (double)12.65, (double)16.0), Block.box((double)12.1, (double)12.6, (double)0.0, (double)13.0, (double)13.05, (double)16.0), Block.box((double)12.5, (double)13.0, (double)0.0, (double)13.4, (double)13.45, (double)16.0), Block.box((double)12.9, (double)13.4, (double)0.0, (double)13.8, (double)13.85, (double)16.0), Block.box((double)13.3, (double)13.8, (double)0.0, (double)14.2, (double)14.25, (double)16.0), Block.box((double)13.7, (double)14.2, (double)0.0, (double)14.6, (double)14.65, (double)16.0), Block.box((double)14.1, (double)14.6, (double)0.0, (double)15.0, (double)15.05, (double)16.0), Block.box((double)14.5, (double)15.0, (double)0.0, (double)15.4, (double)15.45, (double)16.0), Block.box((double)14.9, (double)15.4, (double)0.0, (double)15.8, (double)15.85, (double)16.0), Block.box((double)15.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    }

    @NotNull
    private static VoxelShape makeShapeBack2() {
        return Shapes.or((VoxelShape)Block.box((double)15.0, (double)1.0, (double)0.0, (double)16.0, (double)15.85, (double)1.0), (VoxelShape[])new VoxelShape[]{Block.box((double)14.0, (double)1.0, (double)0.0, (double)15.0, (double)14.65, (double)1.0), Block.box((double)13.0, (double)1.0, (double)0.0, (double)14.0, (double)13.85, (double)1.0), Block.box((double)12.0, (double)1.0, (double)0.0, (double)13.0, (double)12.65, (double)1.0), Block.box((double)11.0, (double)1.0, (double)0.0, (double)12.0, (double)11.85, (double)1.0), Block.box((double)10.0, (double)1.0, (double)0.0, (double)11.0, (double)10.65, (double)1.0), Block.box((double)9.0, (double)1.0, (double)0.0, (double)10.0, (double)9.85, (double)1.0), Block.box((double)8.0, (double)1.0, (double)0.0, (double)9.0, (double)8.65, (double)1.0), Block.box((double)7.0, (double)1.0, (double)0.0, (double)8.0, (double)7.85, (double)1.0), Block.box((double)6.0, (double)1.0, (double)0.0, (double)7.0, (double)6.65, (double)1.0), Block.box((double)5.0, (double)1.0, (double)0.0, (double)6.0, (double)5.85, (double)1.0), Block.box((double)4.0, (double)1.0, (double)0.0, (double)5.0, (double)4.65, (double)1.0), Block.box((double)3.0, (double)1.0, (double)0.0, (double)4.0, (double)3.85, (double)1.0), Block.box((double)2.0, (double)1.0, (double)0.0, (double)3.0, (double)2.65, (double)1.0), Block.box((double)1.0, (double)1.0, (double)0.0, (double)2.0, (double)1.85, (double)1.0)});
    }

    @NotNull
    private static VoxelShape makeShapeBack1() {
        return Shapes.or((VoxelShape)Block.box((double)14.0, (double)1.0, (double)0.0, (double)15.0, (double)1.85, (double)1.0), (VoxelShape[])new VoxelShape[]{Block.box((double)13.0, (double)1.0, (double)0.0, (double)14.0, (double)2.65, (double)1.0), Block.box((double)12.0, (double)1.0, (double)0.0, (double)13.0, (double)3.85, (double)1.0), Block.box((double)11.0, (double)1.0, (double)0.0, (double)12.0, (double)4.65, (double)1.0), Block.box((double)10.0, (double)1.0, (double)0.0, (double)11.0, (double)5.85, (double)1.0), Block.box((double)9.0, (double)1.0, (double)0.0, (double)10.0, (double)6.65, (double)1.0), Block.box((double)8.0, (double)1.0, (double)0.0, (double)9.0, (double)7.85, (double)1.0), Block.box((double)7.0, (double)1.0, (double)0.0, (double)8.0, (double)8.65, (double)1.0), Block.box((double)6.0, (double)1.0, (double)0.0, (double)7.0, (double)9.85, (double)1.0), Block.box((double)5.0, (double)1.0, (double)0.0, (double)6.0, (double)10.65, (double)1.0), Block.box((double)4.0, (double)1.0, (double)0.0, (double)5.0, (double)11.85, (double)1.0), Block.box((double)3.0, (double)1.0, (double)0.0, (double)4.0, (double)12.65, (double)1.0), Block.box((double)2.0, (double)1.0, (double)0.0, (double)3.0, (double)13.85, (double)1.0), Block.box((double)1.0, (double)1.0, (double)0.0, (double)2.0, (double)14.65, (double)1.0), Block.box((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)15.85, (double)1.0)});
    }

    public TentBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.WOOL).ignitedByLava().strength(0.6f).sound(SoundType.WOOL).noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)POSITION, (Comparable)Integer.valueOf(0))).setValue((Property)BedBlock.OCCUPIED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean canSurvive(@NotNull BlockState blockState, @NotNull LevelReader worldReader, @NotNull BlockPos blockPos) {
        return worldReader.getBlockState(blockPos).isAir();
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return ((TentItem)((Object)ModItems.ITEM_TENT.get())).getDefaultInstance();
    }

    public void fallOn(@NotNull Level worldIn, @NotNull BlockState state, @NotNull BlockPos pos, @NotNull Entity entityIn, float fallDistance) {
        super.fallOn(worldIn, state, pos, entityIn, fallDistance * 0.7f);
    }

    public boolean isBed(BlockState state, BlockGetter level, BlockPos pos, LivingEntity sleeper) {
        return true;
    }

    @NotNull
    public Direction getBedDirection(@NotNull BlockState state, LevelReader world, BlockPos pos) {
        Direction thisFacing = (Direction)state.getValue((Property)FACING);
        int thisPos = (Integer)state.getValue((Property)POSITION);
        if (thisPos != 0) {
            BlockPos main;
            switch (thisPos) {
                case 1: {
                    BlockPos blockPos = pos.relative(thisFacing.getClockWise());
                    break;
                }
                case 2: {
                    BlockPos blockPos = pos.relative(thisFacing.getOpposite()).relative(thisFacing.getClockWise());
                    break;
                }
                case 3: {
                    BlockPos blockPos = pos.relative(thisFacing);
                    break;
                }
                default: {
                    BlockPos blockPos = main = null;
                }
            }
            if (main != null) {
                state = world.getBlockState(main);
            }
        }
        return switch ((Integer)state.getValue((Property)POSITION)) {
            case 0, 3 -> ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getOpposite();
            default -> (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        };
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState blockState, @NotNull BlockGetter blockReader, @NotNull BlockPos blockPos, @NotNull CollisionContext context) {
        return (VoxelShape)shapes.get((Object)blockState.getValue((Property)FACING), (Object)blockState.getValue((Property)POSITION));
    }

    @NotNull
    public BlockState updateShape(@NotNull BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        Direction thisFacing = (Direction)stateIn.getValue((Property)FACING);
        int thisPos = (Integer)stateIn.getValue((Property)POSITION);
        if (facing == thisFacing.getClockWise() || (thisPos == 0 || thisPos == 2) && facing == thisFacing.getOpposite() || (thisPos == 1 || thisPos == 3) && facing == thisFacing) {
            return facingState.getBlock() instanceof TentBlock ? (BlockState)stateIn.setValue((Property)BedBlock.OCCUPIED, (Comparable)((Boolean)facingState.getValue((Property)BedBlock.OCCUPIED))) : Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public BlockState playerWillDestroy(@NotNull Level worldIn, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        if (!worldIn.isClientSide && player.isCreative()) {
            Direction thisFacing = (Direction)state.getValue((Property)FACING);
            int thisPos = (Integer)state.getValue((Property)POSITION);
            if (thisPos != 0) {
                BlockState blockstate;
                BlockPos main;
                switch (thisPos) {
                    case 1: {
                        BlockPos blockPos = pos.relative(thisFacing.getClockWise());
                        break;
                    }
                    case 2: {
                        BlockPos blockPos = pos.relative(thisFacing.getOpposite()).relative(thisFacing.getClockWise());
                        break;
                    }
                    case 3: {
                        BlockPos blockPos = pos.relative(thisFacing);
                        break;
                    }
                    default: {
                        BlockPos blockPos = main = null;
                    }
                }
                if (main != null && (blockstate = worldIn.getBlockState(main)).getBlock() == ModBlocks.TENT_MAIN.get()) {
                    worldIn.setBlock(main, Blocks.AIR.defaultBlockState(), 35);
                    worldIn.levelEvent(player, 2001, main, Block.getId((BlockState)blockstate));
                }
            }
        }
        return super.playerWillDestroy(worldIn, pos, state, player);
    }

    public void updateEntityAfterFallOn(@NotNull BlockGetter worldIn, @NotNull Entity entityIn) {
        if (entityIn.isShiftKeyDown()) {
            super.updateEntityAfterFallOn(worldIn, entityIn);
        } else {
            Vec3 vec3d = entityIn.getDeltaMovement();
            if (vec3d.y < 0.0) {
                double d0 = entityIn instanceof LivingEntity ? 1.0 : 0.8;
                entityIn.setDeltaMovement(vec3d.x, -vec3d.y * (double)0.33f * d0, vec3d.z);
            }
        }
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState blockState, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult rayTraceResult) {
        if (world.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        if (VampirismPlayerAttributes.get((Player)player).hunterLevel == 0) {
            player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.tent.cant_use"), true);
            return InteractionResult.SUCCESS;
        }
        if (!BedBlock.canSetSpawn((Level)world)) {
            world.removeBlock(pos, false);
            BlockPos blockpos = pos.relative(((Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getOpposite());
            if (world.getBlockState(blockpos).is((Block)this)) {
                world.removeBlock(blockpos, false);
            }
            Vec3 vec3 = pos.getCenter();
            world.explode(null, world.damageSources().badRespawnPointExplosion(vec3), null, vec3, 5.0f, true, Level.ExplosionInteraction.BLOCK);
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)blockState.getValue((Property)BedBlock.OCCUPIED)).booleanValue()) {
            player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.tent.occupied"), true);
            return InteractionResult.SUCCESS;
        }
        BlockState targetState = blockState;
        BlockPos targetPos = pos;
        Direction thisFacing = (Direction)blockState.getValue((Property)FACING);
        int thisPos = (Integer)blockState.getValue((Property)POSITION);
        if (thisPos != 0) {
            BlockPos main;
            switch (thisPos) {
                case 1: {
                    BlockPos blockPos = pos.relative(thisFacing.getClockWise());
                    break;
                }
                case 2: {
                    BlockPos blockPos = pos.relative(thisFacing.getOpposite()).relative(thisFacing.getClockWise());
                    break;
                }
                case 3: {
                    BlockPos blockPos = pos.relative(thisFacing);
                    break;
                }
                default: {
                    BlockPos blockPos = main = null;
                }
            }
            if (main != null) {
                targetState = world.getBlockState(main);
                targetPos = main;
            }
        }
        BlockState finalTargetState = targetState;
        BlockPos finalTargetPos = targetPos;
        player.startSleepInBed(finalTargetPos).ifLeft(sleepResult1 -> {
            if (sleepResult1 != null) {
                player.displayClientMessage(sleepResults.getOrDefault(sleepResult1, sleepResult1.getMessage()), true);
            }
        }).ifRight(u -> {
            this.setBedOccupied(finalTargetState, world, finalTargetPos, null, true);
            TentBlock.setTentSleepPosition(player, finalTargetPos, (Integer)finalTargetState.getValue((Property)POSITION), (Direction)finalTargetState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING));
        });
        return InteractionResult.SUCCESS;
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, POSITION, BlockStateProperties.OCCUPIED});
    }

    static {
        VoxelShape NORTH = TentBlock.makeShape();
        VoxelShape EAST = UtilLib.rotateShape(NORTH, UtilLib.RotationAmount.NINETY);
        VoxelShape SOUTH = UtilLib.rotateShape(NORTH, UtilLib.RotationAmount.HUNDRED_EIGHTY);
        VoxelShape WEST = UtilLib.rotateShape(NORTH, UtilLib.RotationAmount.TWO_HUNDRED_SEVENTY);
        VoxelShape BACK = TentBlock.makeShapeBack1();
        VoxelShape BACKMIRROR = TentBlock.makeShapeBack2();
        VoxelShape SOUTHR = Shapes.or((VoxelShape)SOUTH, (VoxelShape)BACK);
        VoxelShape NORTHL = Shapes.or((VoxelShape)NORTH, (VoxelShape)BACKMIRROR);
        ImmutableTable.Builder shapeBuilder = ImmutableTable.builder();
        shapeBuilder.put((Object)Direction.NORTH, (Object)0, (Object)NORTH);
        shapeBuilder.put((Object)Direction.NORTH, (Object)1, (Object)NORTH);
        shapeBuilder.put((Object)Direction.NORTH, (Object)2, (Object)NORTHL);
        shapeBuilder.put((Object)Direction.NORTH, (Object)3, (Object)UtilLib.rotateShape(SOUTHR, UtilLib.RotationAmount.HUNDRED_EIGHTY));
        shapeBuilder.put((Object)Direction.EAST, (Object)0, (Object)EAST);
        shapeBuilder.put((Object)Direction.EAST, (Object)1, (Object)EAST);
        shapeBuilder.put((Object)Direction.EAST, (Object)2, (Object)UtilLib.rotateShape(NORTHL, UtilLib.RotationAmount.NINETY));
        shapeBuilder.put((Object)Direction.EAST, (Object)3, (Object)UtilLib.rotateShape(SOUTHR, UtilLib.RotationAmount.TWO_HUNDRED_SEVENTY));
        shapeBuilder.put((Object)Direction.SOUTH, (Object)0, (Object)SOUTH);
        shapeBuilder.put((Object)Direction.SOUTH, (Object)1, (Object)SOUTH);
        shapeBuilder.put((Object)Direction.SOUTH, (Object)2, (Object)UtilLib.rotateShape(NORTHL, UtilLib.RotationAmount.HUNDRED_EIGHTY));
        shapeBuilder.put((Object)Direction.SOUTH, (Object)3, (Object)SOUTHR);
        shapeBuilder.put((Object)Direction.WEST, (Object)0, (Object)WEST);
        shapeBuilder.put((Object)Direction.WEST, (Object)1, (Object)WEST);
        shapeBuilder.put((Object)Direction.WEST, (Object)2, (Object)UtilLib.rotateShape(NORTHL, UtilLib.RotationAmount.TWO_HUNDRED_SEVENTY));
        shapeBuilder.put((Object)Direction.WEST, (Object)3, (Object)UtilLib.rotateShape(SOUTHR, UtilLib.RotationAmount.NINETY));
        shapes = shapeBuilder.build();
        ImmutableTable.Builder offsetsBuilder = ImmutableTable.builder();
        offsetsBuilder.put((Object)0, (Object)Direction.NORTH, (Object)Pair.of((Object)1.0, (Object)1.6));
        offsetsBuilder.put((Object)0, (Object)Direction.EAST, (Object)Pair.of((Object)-0.6, (Object)1.0));
        offsetsBuilder.put((Object)0, (Object)Direction.SOUTH, (Object)Pair.of((Object)0.0, (Object)-0.6));
        offsetsBuilder.put((Object)0, (Object)Direction.WEST, (Object)Pair.of((Object)1.6, (Object)0.0));
        offsetsBuilder.put((Object)1, (Object)Direction.NORTH, (Object)Pair.of((Object)1.0, (Object)-0.6));
        offsetsBuilder.put((Object)1, (Object)Direction.EAST, (Object)Pair.of((Object)1.6, (Object)1.0));
        offsetsBuilder.put((Object)1, (Object)Direction.SOUTH, (Object)Pair.of((Object)0.0, (Object)1.6));
        offsetsBuilder.put((Object)1, (Object)Direction.WEST, (Object)Pair.of((Object)-0.6, (Object)0.0));
        offsetsBuilder.put((Object)2, (Object)Direction.NORTH, (Object)Pair.of((Object)1.0, (Object)0.4));
        offsetsBuilder.put((Object)2, (Object)Direction.EAST, (Object)Pair.of((Object)0.6, (Object)1.0));
        offsetsBuilder.put((Object)2, (Object)Direction.SOUTH, (Object)Pair.of((Object)0.0, (Object)0.6));
        offsetsBuilder.put((Object)2, (Object)Direction.WEST, (Object)Pair.of((Object)0.4, (Object)0.0));
        offsetsBuilder.put((Object)3, (Object)Direction.NORTH, (Object)Pair.of((Object)1.0, (Object)0.6));
        offsetsBuilder.put((Object)3, (Object)Direction.EAST, (Object)Pair.of((Object)0.4, (Object)1.0));
        offsetsBuilder.put((Object)3, (Object)Direction.SOUTH, (Object)Pair.of((Object)0.0, (Object)0.4));
        offsetsBuilder.put((Object)3, (Object)Direction.WEST, (Object)Pair.of((Object)0.6, (Object)0.0));
        offsets = offsetsBuilder.build();
        ImmutableMap.Builder sleepBuilder = ImmutableMap.builder();
        sleepBuilder.put((Object)Player.BedSleepingProblem.NOT_POSSIBLE_NOW, (Object)Component.translatable((String)"text.vampirism.tent.no_sleep"));
        sleepBuilder.put((Object)Player.BedSleepingProblem.TOO_FAR_AWAY, (Object)Component.translatable((String)"text.vampirism.tent.too_far_away"));
        sleepBuilder.put((Object)Player.BedSleepingProblem.OBSTRUCTED, (Object)Component.translatable((String)"text.vampirism.tent.obstructed"));
        sleepResults = sleepBuilder.build();
    }
}

