/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IFactionPlayerHandler;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.blocks.VampirismHorizontalBlock;
import de.teamlapen.vampirism.client.VampirismModClient;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModStats;
import de.teamlapen.vampirism.effects.SanguinareEffect;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.inventory.RevertBackMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MedChairBlock
extends VampirismHorizontalBlock {
    public static final EnumProperty<EnumPart> PART = EnumProperty.create((String)"part", EnumPart.class);
    @NotNull
    private static final VoxelShape SHAPE_TOP = MedChairBlock.box((double)2.0, (double)6.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0);
    @NotNull
    private static final VoxelShape SHAPE_BOTTOM = MedChairBlock.box((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)10.0, (double)16.0);
    private final VoxelShape NORTH1;
    @NotNull
    private final VoxelShape EAST1;
    @NotNull
    private final VoxelShape SOUTH1;
    @NotNull
    private final VoxelShape WEST1;
    private final VoxelShape NORTH2;
    @NotNull
    private final VoxelShape EAST2;
    @NotNull
    private final VoxelShape SOUTH2;
    @NotNull
    private final VoxelShape WEST2;

    public MedChairBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).pushReaction(PushReaction.DESTROY).strength(1.0f).noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(PART, (Comparable)((Object)EnumPart.BOTTOM)));
        this.NORTH1 = SHAPE_BOTTOM;
        this.EAST1 = UtilLib.rotateShape(this.NORTH1, UtilLib.RotationAmount.NINETY);
        this.SOUTH1 = UtilLib.rotateShape(this.NORTH1, UtilLib.RotationAmount.HUNDRED_EIGHTY);
        this.WEST1 = UtilLib.rotateShape(this.NORTH1, UtilLib.RotationAmount.TWO_HUNDRED_SEVENTY);
        this.NORTH2 = SHAPE_TOP;
        this.EAST2 = UtilLib.rotateShape(this.NORTH2, UtilLib.RotationAmount.NINETY);
        this.SOUTH2 = UtilLib.rotateShape(this.NORTH2, UtilLib.RotationAmount.HUNDRED_EIGHTY);
        this.WEST2 = UtilLib.rotateShape(this.NORTH2, UtilLib.RotationAmount.TWO_HUNDRED_SEVENTY);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, @NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (player.isAlive()) {
            if (this.handleInjections(player, world, stack, pos)) {
                player.awardStat((ResourceLocation)ModStats.INTERACT_WITH_INJECTION_CHAIR.get());
                stack.shrink(1);
                if (stack.isEmpty()) {
                    player.getInventory().removeItem(stack);
                }
            }
        } else if (world.isClientSide) {
            player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.need_item_to_use", (Object[])new Object[]{Component.translatable((String)new ItemStack((ItemLike)ModItems.INJECTION_GARLIC.get()).getDescriptionId())}), true);
        }
        return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
    }

    private boolean handleGarlicInjection(@NotNull Player player, @NotNull Level world, @NotNull IFactionPlayerHandler handler, @Nullable IPlayableFaction<?> currentFaction) {
        if (handler.canJoin(VReference.HUNTER_FACTION)) {
            if (world.isClientSide) {
                VampirismModClient.getINSTANCE().getOverlay().makeRenderFullColor(4, 30, -1145324545);
            } else {
                handler.joinFaction(VReference.HUNTER_FACTION);
                player.addEffect(new MobEffectInstance(ModEffects.POISON, 200, 1));
            }
            return true;
        }
        if (currentFaction != null && !world.isClientSide) {
            player.sendSystemMessage((Component)Component.translatable((String)"text.vampirism.med_chair_other_faction", (Object[])new Object[]{currentFaction.getName()}));
        }
        return false;
    }

    private boolean handleInjections(@NotNull Player player, @NotNull Level world, @NotNull ItemStack stack, @NotNull BlockPos pos) {
        FactionPlayerHandler handler = FactionPlayerHandler.get(player);
        IPlayableFaction<?> faction = handler.getCurrentFaction();
        if (stack.getItem().equals(ModItems.INJECTION_GARLIC.get())) {
            return this.handleGarlicInjection(player, world, handler, faction);
        }
        if (stack.getItem().equals(ModItems.INJECTION_SANGUINARE.get())) {
            return this.handleSanguinareInjection(world, pos, player, handler, faction);
        }
        return false;
    }

    private boolean handleSanguinareInjection(final @NotNull Level level, final @NotNull BlockPos pos, @NotNull Player player, @NotNull IFactionPlayerHandler handler, @Nullable IPlayableFaction<?> currentFaction) {
        if (VReference.VAMPIRE_FACTION.equals(currentFaction)) {
            player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.already_vampire"), false);
            return false;
        }
        if (VReference.HUNTER_FACTION.equals(currentFaction)) {
            if (!level.isClientSide) {
                player.openMenu((MenuProvider)new SimpleMenuProvider(new MenuConstructor(){

                    @NotNull
                    public AbstractContainerMenu createMenu(int i, @NotNull Inventory inventory, @NotNull Player player) {
                        return new RevertBackMenu(i, inventory, ContainerLevelAccess.create((Level)level, (BlockPos)pos));
                    }
                }, (Component)Component.empty()));
            }
            return false;
        }
        if (currentFaction == null && handler.canJoin(VReference.VAMPIRE_FACTION)) {
            if (((Boolean)VampirismConfig.SERVER.disableFangInfection.get()).booleanValue()) {
                player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.deactivated_by_serveradmin"), true);
            } else {
                SanguinareEffect.addRandom((LivingEntity)player, true, true);
                player.addEffect(new MobEffectInstance(ModEffects.POISON, 60));
                return true;
            }
        }
        return false;
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState p_149645_1_) {
        return RenderShape.MODEL;
    }

    @Override
    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        boolean main = state.getValue(PART) == EnumPart.BOTTOM;
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.NORTH -> {
                if (main) {
                    yield this.NORTH1;
                }
                yield this.NORTH2;
            }
            case Direction.EAST -> {
                if (main) {
                    yield this.EAST1;
                }
                yield this.EAST2;
            }
            case Direction.SOUTH -> {
                if (main) {
                    yield this.SOUTH1;
                }
                yield this.SOUTH2;
            }
            case Direction.WEST -> {
                if (main) {
                    yield this.WEST1;
                }
                yield this.WEST2;
            }
            default -> this.NORTH1;
        };
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        Direction enumfacing = context.getHorizontalDirection();
        BlockPos blockpos = context.getClickedPos();
        BlockPos blockpos1 = blockpos.relative(enumfacing);
        return context.getLevel().getBlockState(blockpos1).canBeReplaced(context) ? (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)enumfacing.getOpposite()) : null;
    }

    protected boolean isPathfindable(BlockState p_60475_, PathComputationType p_60478_) {
        return false;
    }

    public BlockState playerWillDestroy(@NotNull Level world, @NotNull BlockPos blockPos, @NotNull BlockState blockState, @NotNull Player player) {
        BlockPos blockpos;
        BlockState otherState;
        EnumPart part;
        if (!world.isClientSide && player.isCreative() && (part = (EnumPart)((Object)blockState.getValue(PART))) == EnumPart.TOP && (otherState = world.getBlockState(blockpos = blockPos.relative(this.getOtherBlockDirection(blockState)))).getBlock() == this && otherState.getValue(PART) == EnumPart.BOTTOM) {
            world.setBlock(blockpos, Blocks.AIR.defaultBlockState(), 35);
            world.levelEvent(player, 2001, blockpos, Block.getId((BlockState)otherState));
        }
        return super.playerWillDestroy(world, blockPos, blockState, player);
    }

    public void setPlacedBy(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack itemStack) {
        super.setPlacedBy(world, pos, state, placer, itemStack);
        if (!world.isClientSide) {
            BlockPos blockpos = pos.relative(this.getOtherBlockDirection(state));
            BlockState otherState = (BlockState)state.setValue(PART, (Comparable)((Object)EnumPart.TOP));
            otherState = (BlockState)otherState.setValue((Property)FACING, (Comparable)((Direction)otherState.getValue((Property)FACING)));
            world.setBlock(blockpos, otherState, 3);
            world.blockUpdated(pos, Blocks.AIR);
            state.updateNeighbourShapes((LevelAccessor)world, pos, 3);
        }
    }

    @NotNull
    public BlockState updateShape(@NotNull BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        if (facing == this.getOtherBlockDirection(stateIn)) {
            return facingState.getBlock() == this && facingState.getValue(PART) != stateIn.getValue(PART) ? this.updateFromOther(stateIn, facingState) : Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Override
    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{PART});
    }

    @NotNull
    protected Direction getOtherBlockDirection(@NotNull BlockState blockState) {
        return blockState.getValue(PART) == EnumPart.BOTTOM ? ((Direction)blockState.getValue((Property)FACING)).getOpposite() : (Direction)blockState.getValue((Property)FACING);
    }

    protected BlockState updateFromOther(BlockState thisState, BlockState otherState) {
        return thisState;
    }

    public static enum EnumPart implements StringRepresentable
    {
        TOP("top", 0),
        BOTTOM("bottom", 1);

        public final String name;
        public final int meta;

        @NotNull
        public static EnumPart fromMeta(int meta) {
            if (meta == 1) {
                return BOTTOM;
            }
            return TOP;
        }

        private EnumPart(String name, int meta) {
            this.name = name;
            this.meta = meta;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        @NotNull
        public String toString() {
            return this.getSerializedName();
        }
    }
}

