/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class DarkSpruceSaplingBlock
extends SaplingBlock {
    private final TreeGrower darkTreeGrower;
    private final TreeGrower cursedTreeGrower;

    public DarkSpruceSaplingBlock(TreeGrower darkTreeGrower, TreeGrower cursedTreeGrower, BlockBehaviour.Properties pProperties) {
        super(darkTreeGrower, pProperties);
        this.darkTreeGrower = darkTreeGrower;
        this.cursedTreeGrower = cursedTreeGrower;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, @NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Player pPlayer, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHit) {
        if (stack.is(ModTags.Items.PURE_BLOOD)) {
            stack.shrink(1);
            pLevel.setBlockAndUpdate(pPos, ((SaplingBlock)ModBlocks.CURSED_SPRUCE_SAPLING.get()).defaultBlockState());
            return ItemInteractionResult.sidedSuccess((boolean)pLevel.isClientSide);
        }
        return super.useItemOn(stack, pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    public void advanceTree(@NotNull ServerLevel pLevel, @NotNull BlockPos pPos, BlockState pState, @NotNull RandomSource pRandom) {
        if ((Integer)pState.getValue((Property)STAGE) == 0) {
            pLevel.setBlock(pPos, (BlockState)pState.cycle((Property)STAGE), 4);
        } else {
            TreeGrower grower = this.darkTreeGrower;
            if (pLevel.getBlockState(pPos.below()).is(ModTags.Blocks.CURSED_EARTH) && (double)pRandom.nextFloat() < 0.3) {
                grower = this.cursedTreeGrower;
            }
            grower.growTree(pLevel, pLevel.getChunkSource().getGenerator(), pPos, pState, pRandom);
        }
    }
}

