/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.blocks.HolyWaterEffectConsumer;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public abstract class CursedBarkBlock
extends Block
implements HolyWaterEffectConsumer {
    private static final VoxelShape shape = Shapes.empty();

    public CursedBarkBlock(BlockBehaviour.Properties properties) {
        super(properties.noCollission().replaceable().strength(0.0f).pushReaction(PushReaction.DESTROY).ignitedByLava().isViewBlocking(UtilLib::never));
        ((FireBlock)Blocks.FIRE).setFlammable((Block)this, 5, 5);
    }

    protected void moveEntityTo(@NotNull Level level, @NotNull Entity entity, @NotNull BlockPos targetPos) {
        if (targetPos.equals((Object)entity.blockPosition())) {
            return;
        }
        Vec3 thrust = new Vec3((double)targetPos.getX(), (double)targetPos.getY(), (double)targetPos.getZ()).subtract(entity.getX(), entity.getY(), entity.getZ()).normalize().scale(0.04);
        if (!entity.onGround()) {
            thrust = thrust.scale(0.3);
        }
        entity.setDeltaMovement(entity.getDeltaMovement().add(thrust));
        if (!level.isClientSide) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                VampirePlayer vampire = VampirePlayer.get(player);
                if (vampire.getRemainingBarkTicks() == 0) {
                    vampire.removeBlood(0.02f);
                    vampire.increaseRemainingBarkTicks(40);
                }
            } else {
                ExtendedCreature.getSafe(entity).ifPresent(creature -> {
                    if (creature.getRemainingBarkTicks() == 0) {
                        creature.setBlood(creature.getBlood() - 1);
                        creature.sync();
                        creature.increaseRemainingBarkTicks(40);
                    }
                });
            }
        }
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState p_60555_, @NotNull BlockGetter p_60556_, @NotNull BlockPos p_60557_, @NotNull CollisionContext p_60558_) {
        return shape;
    }

    protected void spawnDestroyParticles(@NotNull Level level, @NotNull Player player, @NotNull BlockPos pos, @NotNull BlockState state) {
    }

    public boolean addRunningEffects(BlockState state, Level level, BlockPos pos, Entity entity) {
        return true;
    }

    public boolean addLandingEffects(BlockState state1, ServerLevel level, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        return true;
    }

    @Override
    public void onHolyWaterEffect(Level level, BlockState state, BlockPos pos, ItemStack holyWaterStack, IItemWithTier.TIER tier) {
        level.destroyBlock(pos, false);
    }
}

