/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.blockentity.CoffinBlockEntity;
import de.teamlapen.vampirism.blocks.VampirismBlockContainer;
import de.teamlapen.vampirism.core.ModStats;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.entity.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.mixin.accessor.EntityAccessor;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoffinBlock
extends VampirismBlockContainer {
    public static final MapCodec<CoffinBlock> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)DyeColor.CODEC.fieldOf("color").forGetter(b -> b.color), (App)CoffinBlock.propertiesCodec()).apply((Applicative)inst, CoffinBlock::new));
    public static final Map<DyeColor, CoffinBlock> COFFIN_BLOCKS = new HashMap<DyeColor, CoffinBlock>();
    public static final String name = "coffin";
    public static final EnumProperty<CoffinPart> PART = EnumProperty.create((String)"part", CoffinPart.class);
    public static final BooleanProperty CLOSED = BooleanProperty.create((String)"closed");
    public static final BooleanProperty VERTICAL = BooleanProperty.create((String)"vertical");
    private static final ShapeTable shapes = new ShapeTable();
    private static final Map<Player.BedSleepingProblem, Component> sleepResults = ImmutableMap.of((Object)Player.BedSleepingProblem.NOT_POSSIBLE_NOW, (Object)Component.translatable((String)"text.vampirism.coffin.no_sleep"), (Object)Player.BedSleepingProblem.TOO_FAR_AWAY, (Object)Component.translatable((String)"text.vampirism.coffin.too_far_away"), (Object)Player.BedSleepingProblem.OBSTRUCTED, (Object)Component.translatable((String)"text.vampirism.coffin.obstructed"));
    private final DyeColor color;

    public static boolean isOccupied(@NotNull BlockGetter world, @NotNull BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        return state.getBlock() instanceof CoffinBlock && (Boolean)state.getValue((Property)BedBlock.OCCUPIED) != false;
    }

    public static boolean isClosed(@NotNull BlockGetter world, @NotNull BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        return state.getBlock() instanceof CoffinBlock && (Boolean)state.getValue((Property)CLOSED) != false;
    }

    public static boolean isHead(@NotNull BlockGetter world, @NotNull BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        return state.getBlock() instanceof CoffinBlock && state.getValue(PART) == CoffinPart.HEAD;
    }

    private static Direction getDirectionToOther(CoffinPart type, @NotNull Direction facing) {
        return type == CoffinPart.FOOT ? facing : facing.getOpposite();
    }

    public CoffinBlock(DyeColor color) {
        this(color, BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).strength(0.2f).noOcclusion().pushReaction(PushReaction.DESTROY).ignitedByLava());
    }

    public CoffinBlock(DyeColor color, BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BedBlock.OCCUPIED, (Comparable)Boolean.FALSE)).setValue(PART, (Comparable)((Object)CoffinPart.FOOT))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)CLOSED, (Comparable)Boolean.valueOf(false))).setValue((Property)VERTICAL, (Comparable)Boolean.valueOf(false)));
        this.color = color;
        COFFIN_BLOCKS.put(color, this);
    }

    @NotNull
    public Direction getBedDirection(@NotNull BlockState state, LevelReader world, BlockPos pos) {
        return (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        Direction enumfacing = context.getHorizontalDirection();
        boolean vertical = context.getClickedFace().getAxis() != Direction.Axis.Y;
        BlockPos blockpos = context.getClickedPos();
        BlockPos blockpos1 = blockpos.relative(vertical ? Direction.UP : enumfacing);
        return context.getLevel().getBlockState(blockpos1).canBeReplaced(context) ? (BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)enumfacing)).setValue((Property)VERTICAL, (Comparable)Boolean.valueOf(vertical)) : null;
    }

    protected boolean isPathfindable(BlockState p_60475_, PathComputationType p_60478_) {
        return false;
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return shapes.getShape((CoffinPart)((Object)state.getValue(PART)), (Boolean)state.getValue((Property)CLOSED), (Boolean)state.getValue((Property)VERTICAL), (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING));
    }

    public boolean isBed(@NotNull BlockState state, BlockGetter world, BlockPos pos, LivingEntity sleeper) {
        return (Boolean)state.getValue((Property)CLOSED) == false || (Boolean)state.getValue((Property)BedBlock.OCCUPIED) != false;
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new CoffinBlockEntity(pos, state, this.color);
    }

    @NotNull
    public BlockState playerWillDestroy(@NotNull Level worldIn, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        BlockPos blockpos;
        BlockState blockstate;
        CoffinPart part;
        if (!worldIn.isClientSide && player.isCreative() && (part = (CoffinPart)((Object)state.getValue(PART))) == CoffinPart.FOOT && (blockstate = worldIn.getBlockState(blockpos = this.getOtherPos(pos, state))).getBlock() == this && blockstate.getValue(PART) == CoffinPart.HEAD) {
            worldIn.setBlock(blockpos, Blocks.AIR.defaultBlockState(), 35);
            worldIn.levelEvent(player, 2001, blockpos, Block.getId((BlockState)blockstate));
        }
        return super.playerWillDestroy(worldIn, pos, state, player);
    }

    public void setPlacedBy(@NotNull Level worldIn, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity entity, @NotNull ItemStack itemStack) {
        super.setPlacedBy(worldIn, pos, state, entity, itemStack);
        if (!worldIn.isClientSide) {
            BlockPos blockpos = this.getOtherPos(pos, state);
            worldIn.setBlock(blockpos, (BlockState)state.setValue(PART, (Comparable)((Object)CoffinPart.HEAD)), 3);
            worldIn.blockUpdated(pos, Blocks.AIR);
            state.updateNeighbourShapes((LevelAccessor)worldIn, pos, 3);
        }
    }

    @NotNull
    public BlockState updateShape(@NotNull BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        if (facing == CoffinBlock.getDirectionToOther((CoffinPart)((Object)stateIn.getValue(PART)), (Boolean)stateIn.getValue((Property)VERTICAL) != false ? Direction.UP : (Direction)stateIn.getValue((Property)BlockStateProperties.HORIZONTAL_FACING))) {
            return facingState.getBlock() == this && facingState.getValue(PART) != stateIn.getValue(PART) ? (BlockState)stateIn.setValue((Property)BedBlock.OCCUPIED, (Comparable)((Boolean)facingState.getValue((Property)BedBlock.OCCUPIED))) : Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hit) {
        if (worldIn.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (state.getValue(PART) != CoffinPart.HEAD && !(state = worldIn.getBlockState(pos = this.getOtherPos(pos, state))).is((Block)this)) {
            return InteractionResult.CONSUME;
        }
        player.awardStat((ResourceLocation)ModStats.INTERACT_WITH_COFFIN.get());
        if (player.isShiftKeyDown() && !((Boolean)state.getValue((Property)BedBlock.OCCUPIED)).booleanValue()) {
            worldIn.setBlock(pos, (BlockState)state.setValue((Property)CLOSED, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)CLOSED) == false)), 3);
            BlockPos otherPos = this.getOtherPos(pos, state);
            worldIn.setBlock(otherPos, (BlockState)worldIn.getBlockState(otherPos).setValue((Property)CLOSED, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)CLOSED) == false)), 3);
            return InteractionResult.CONSUME;
        }
        if (VampirismPlayerAttributes.get((Player)player).vampireLevel == 0) {
            player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.coffin.cant_use"), true);
            return InteractionResult.CONSUME;
        }
        if (((Boolean)state.getValue((Property)BedBlock.OCCUPIED)).booleanValue()) {
            player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.coffin.occupied"), true);
            return InteractionResult.CONSUME;
        }
        if (((Boolean)state.getValue((Property)CLOSED)).booleanValue()) {
            player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.coffin.closed"), true);
            return InteractionResult.CONSUME;
        }
        if (!BedBlock.canSetSpawn((Level)worldIn)) {
            worldIn.removeBlock(pos, false);
            BlockPos blockpos = pos.relative((Boolean)state.getValue((Property)VERTICAL) != false ? Direction.DOWN : ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getOpposite());
            if (worldIn.getBlockState(blockpos).is((Block)this)) {
                worldIn.removeBlock(blockpos, false);
            }
            Vec3 vec3 = pos.getCenter();
            worldIn.explode(null, worldIn.damageSources().badRespawnPointExplosion(vec3), null, vec3, 5.0f, true, Level.ExplosionInteraction.BLOCK);
            return InteractionResult.CONSUME;
        }
        if (((Boolean)state.getValue((Property)BedBlock.OCCUPIED)).booleanValue()) {
            player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.coffin.occupied"), true);
            return InteractionResult.CONSUME;
        }
        BlockPos finalPos = pos;
        BlockState finalState = state;
        player.startSleepInBed((Boolean)state.getValue((Property)VERTICAL) != false ? pos.below() : pos).ifLeft(sleepResult1 -> {
            if (sleepResult1 != null) {
                player.displayClientMessage(sleepResults.getOrDefault(sleepResult1, sleepResult1.getMessage()), true);
            }
        }).ifRight(u -> CoffinBlock.setCoffinSleepPosition(player, finalPos, finalState));
        return InteractionResult.CONSUME;
    }

    public static void setCoffinSleepPosition(@NotNull Player player, @NotNull BlockPos blockPos, @NotNull BlockState state) {
        if (((Boolean)state.getValue((Property)VERTICAL)).booleanValue()) {
            double z;
            double x;
            player.setPose(Pose.STANDING);
            switch ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                case NORTH: {
                    x = 0.5;
                    z = 0.3;
                    player.yHeadRot = 0.0f;
                    player.yBodyRot = 0.0f;
                    break;
                }
                case EAST: {
                    x = 0.7;
                    z = 0.5;
                    player.yHeadRot = 90.0f;
                    player.yBodyRot = 90.0f;
                    break;
                }
                case SOUTH: {
                    x = 0.5;
                    z = 0.7;
                    player.yHeadRot = 180.0f;
                    player.yBodyRot = 180.0f;
                    break;
                }
                case WEST: {
                    x = 0.3;
                    z = 0.5;
                    player.yHeadRot = 270.0f;
                    player.yBodyRot = 270.0f;
                    break;
                }
                default: {
                    return;
                }
            }
            player.setPos((double)blockPos.getX() + x, (double)blockPos.getY() - 0.05, (double)blockPos.getZ() + z);
            player.setBoundingBox(new AABB((double)blockPos.getX() + x - 0.2, (double)blockPos.getY() + 0.15, (double)blockPos.getZ() + z - 0.2, (double)blockPos.getX() + x + 0.2, (double)blockPos.getY() + 1.3, (double)blockPos.getZ() + z + 0.2));
        } else {
            player.setPos((double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.2, (double)blockPos.getZ() + 0.5);
            player.setBoundingBox(((EntityAccessor)player).getDimensions().makeBoundingBox((double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.2, (double)blockPos.getZ() + 0.5).deflate(0.3));
        }
    }

    @NotNull
    public Optional<ServerPlayer.RespawnPosAngle> getRespawnPosition(BlockState state, @NotNull EntityType<?> type, @NotNull LevelReader levelReader, @NotNull BlockPos pos, float orientation) {
        if (((Boolean)state.getValue((Property)VERTICAL)).booleanValue()) {
            if (state.getValue(PART) == CoffinPart.HEAD) {
                pos = pos.below();
            }
            pos = pos.relative(((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getOpposite());
            return Optional.of(ServerPlayer.RespawnPosAngle.of((Vec3)pos.getCenter(), (BlockPos)pos.relative(((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getOpposite())));
        }
        return Optional.of(ServerPlayer.RespawnPosAngle.of((Vec3)pos.getCenter(), (BlockPos)pos.relative(((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getOpposite())));
    }

    @NotNull
    public BlockPos getOtherPos(@NotNull BlockPos pos, @NotNull BlockState state) {
        if (((Boolean)state.getValue((Property)VERTICAL)).booleanValue()) {
            if (state.getValue(PART) == CoffinPart.FOOT) {
                return pos.above();
            }
            return pos.below();
        }
        if (state.getValue(PART) == CoffinPart.FOOT) {
            return pos.relative((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING));
        }
        return pos.relative(((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getOpposite());
    }

    public void setBedOccupied(BlockState state, @NotNull Level world, @NotNull BlockPos pos, LivingEntity sleeper, boolean occupied) {
        super.setBedOccupied(state, world, pos, sleeper, occupied);
        world.setBlock(pos, (BlockState)world.getBlockState(pos).setValue((Property)CLOSED, (Comparable)Boolean.valueOf(occupied)), 3);
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING, BedBlock.OCCUPIED, PART, CLOSED, VERTICAL});
    }

    public DyeColor getColor() {
        return this.color;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> blockEntity) {
        return state.getValue(PART) == CoffinPart.HEAD ? CoffinBlock.createTickerHelper(blockEntity, (BlockEntityType)((BlockEntityType)ModTiles.COFFIN.get()), CoffinBlockEntity::clientTickHead) : null;
    }

    public static enum CoffinPart implements StringRepresentable
    {
        HEAD("head"),
        FOOT("foot");

        private final String name;

        private CoffinPart(String name) {
            this.name = name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class ShapeTable {
        private final VoxelShape[][][] @NotNull [] shapes = this.buildShapes();

        public VoxelShape getShape(@NotNull CoffinPart part, boolean closed, boolean vertical, @NotNull Direction facing) {
            return this.shapes[part.ordinal()][closed ? 1 : 0][vertical ? 1 : 0][facing.get2DDataValue()];
        }

        private VoxelShape[][][] @NotNull [] buildShapes() {
            VoxelShape shape = Shapes.empty();
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.0625, (double)2.0), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.90625, (double)0.0625, (double)0.046875, (double)0.96875, (double)0.1875, (double)1.96875), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.875, (double)0.1875, (double)1.375, (double)0.9375, (double)0.375, (double)1.875), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.875, (double)0.1875, (double)0.75, (double)0.9375, (double)0.375, (double)1.25), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.875, (double)0.1875, (double)0.125, (double)0.9375, (double)0.375, (double)0.625), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.1875, (double)1.875, (double)0.75, (double)0.375, (double)1.9375), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.1875, (double)0.125, (double)0.125, (double)0.375, (double)0.625), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.1875, (double)0.75, (double)0.125, (double)0.375, (double)1.25), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.1875, (double)1.375, (double)0.125, (double)0.375, (double)1.875), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.1875, (double)0.0625, (double)0.75, (double)0.375, (double)0.125), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.03125, (double)0.0625, (double)0.046875, (double)0.09375, (double)0.1875, (double)1.96875), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.09375, (double)0.0625, (double)1.921875, (double)0.90625, (double)0.1875, (double)1.96875), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.09375, (double)0.0625, (double)0.046875, (double)0.90625, (double)0.1875, (double)0.09375), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.90625, (double)0.1875, (double)1.875, (double)0.96875, (double)0.375, (double)1.96875), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.90625, (double)0.1875, (double)1.25, (double)0.96875, (double)0.375, (double)1.375), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.90625, (double)0.1875, (double)0.625, (double)0.96875, (double)0.375, (double)0.75), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.90625, (double)0.1875, (double)0.046875, (double)0.96875, (double)0.375, (double)0.125), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.03125, (double)0.1875, (double)0.046875, (double)0.09375, (double)0.375, (double)0.125), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.03125, (double)0.1875, (double)0.625, (double)0.09375, (double)0.375, (double)0.75), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.03125, (double)0.1875, (double)1.25, (double)0.09375, (double)0.375, (double)1.375), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.03125, (double)0.1875, (double)1.875, (double)0.09375, (double)0.375, (double)1.96875), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.09375, (double)0.1875, (double)1.921875, (double)0.25, (double)0.375, (double)1.96875), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.75, (double)0.1875, (double)1.921875, (double)0.90625, (double)0.375, (double)1.96875), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.75, (double)0.1875, (double)0.046875, (double)0.90625, (double)0.375, (double)0.09375), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.09375, (double)0.1875, (double)0.046875, (double)0.25, (double)0.375, (double)0.09375), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.09375, (double)0.375, (double)0.046875, (double)0.90625, (double)0.5, (double)0.09375), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.03125, (double)0.375, (double)0.046875, (double)0.09375, (double)0.5, (double)1.96875), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.09375, (double)0.375, (double)1.921875, (double)0.90625, (double)0.5, (double)1.96875), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.90625, (double)0.375, (double)0.046875, (double)0.96875, (double)0.5, (double)1.96875), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.90625, (double)0.5, (double)0.0, (double)1.0, (double)0.5625, (double)2.0), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.5, (double)0.0, (double)0.09375, (double)0.5625, (double)2.0), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.09375, (double)0.5, (double)1.921875, (double)0.90625, (double)0.5625, (double)2.0), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.09375, (double)0.5, (double)0.0, (double)0.90625, (double)0.5625, (double)0.09375), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.09375, (double)0.0625, (double)0.09375, (double)0.140625, (double)0.546875, (double)1.921875), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.859375, (double)0.0625, (double)0.09375, (double)0.90625, (double)0.546875, (double)1.921875), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.140625, (double)0.0625, (double)1.859375, (double)0.859375, (double)0.546875, (double)1.921875), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.140625, (double)0.0625, (double)0.09375, (double)0.859375, (double)0.546875, (double)0.15625), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.125, (double)0.1875, (double)0.8125, (double)0.3125, (double)0.5), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.203125, (double)0.203125, (double)0.4375, (double)0.796875, (double)0.34375, (double)0.5625), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.203125, (double)0.203125, (double)0.171875, (double)0.796875, (double)0.328125, (double)0.296875), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.9375, (double)0.09375, (double)0.25, (double)1.0, (double)0.15625, (double)0.5), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.9375, (double)0.09375, (double)0.875, (double)1.0, (double)0.15625, (double)1.125), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.9375, (double)0.09375, (double)1.5, (double)1.0, (double)0.15625, (double)1.75), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.09375, (double)1.5, (double)0.0625, (double)0.15625, (double)1.75), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.09375, (double)0.875, (double)0.0625, (double)0.15625, (double)1.125), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.09375, (double)0.25, (double)0.0625, (double)0.15625, (double)0.5), (BooleanOp)BooleanOp.OR);
            VoxelShape lidShape = Shapes.empty();
            lidShape = Shapes.join((VoxelShape)lidShape, (VoxelShape)Shapes.box((double)0.0, (double)0.5625, (double)0.0, (double)0.09375, (double)0.625, (double)2.0), (BooleanOp)BooleanOp.OR);
            lidShape = Shapes.join((VoxelShape)lidShape, (VoxelShape)Shapes.box((double)0.09375, (double)0.5625, (double)0.0, (double)0.90625, (double)0.625, (double)0.078125), (BooleanOp)BooleanOp.OR);
            lidShape = Shapes.join((VoxelShape)lidShape, (VoxelShape)Shapes.box((double)0.90625, (double)0.5625, (double)0.0, (double)1.0, (double)0.625, (double)2.0), (BooleanOp)BooleanOp.OR);
            lidShape = Shapes.join((VoxelShape)lidShape, (VoxelShape)Shapes.box((double)0.09375, (double)0.5625, (double)1.90625, (double)0.90625, (double)0.625, (double)2.0), (BooleanOp)BooleanOp.OR);
            lidShape = Shapes.join((VoxelShape)lidShape, (VoxelShape)Shapes.box((double)0.09375, (double)0.625, (double)0.0625, (double)0.90625, (double)0.6875, (double)1.921875), (BooleanOp)BooleanOp.OR);
            VoxelShape head = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.AND);
            VoxelShape foot = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0, (double)2.0), (BooleanOp)BooleanOp.AND).move(0.0, 0.0, -1.0);
            VoxelShape lidHead = Shapes.join((VoxelShape)lidShape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.AND);
            VoxelShape lidFoot = Shapes.join((VoxelShape)lidShape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0, (double)2.0), (BooleanOp)BooleanOp.AND).move(0.0, 0.0, -1.0);
            VoxelShape[][][][] shapes = new VoxelShape[2][][][];
            shapes[CoffinPart.HEAD.ordinal()] = this.buildShapePart(head, lidHead);
            shapes[CoffinPart.FOOT.ordinal()] = this.buildShapePart(foot, lidFoot);
            return shapes;
        }

        private VoxelShape[][] @NotNull [] buildShapePart(VoxelShape shape, @NotNull VoxelShape shapeLid) {
            VoxelShape[][][] shapes = new VoxelShape[][][]{this.buildShapeClosed(shape, shapeLid, false), this.buildShapeClosed(shape, shapeLid, true)};
            return shapes;
        }

        private VoxelShape[] @NotNull [] buildShapeClosed(VoxelShape shape, @NotNull VoxelShape shapeLid, boolean closed) {
            if (closed) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)shapeLid);
            }
            VoxelShape[][] shapes = new VoxelShape[][]{this.buildShapeVertical(shape, false), this.buildShapeVertical(shape, true)};
            return shapes;
        }

        private VoxelShape @NotNull [] buildShapeVertical(VoxelShape shape, boolean vertical) {
            if (vertical) {
                shape = UtilLib.rollShape(shape, Direction.NORTH);
            }
            VoxelShape[] shapes = new VoxelShape[4];
            VoxelShape finalShape = shape;
            Direction.Plane.HORIZONTAL.stream().forEach(dir -> {
                shapes[dir.get2DDataValue()] = this.buildShapeDirectional(finalShape, (Direction)dir);
            });
            return shapes;
        }

        private VoxelShape buildShapeDirectional(@NotNull VoxelShape shape, @NotNull Direction direction) {
            return switch (direction) {
                case Direction.NORTH -> shape;
                case Direction.EAST -> UtilLib.rotateShape(shape, UtilLib.RotationAmount.NINETY);
                case Direction.SOUTH -> UtilLib.rotateShape(shape, UtilLib.RotationAmount.HUNDRED_EIGHTY);
                case Direction.WEST -> UtilLib.rotateShape(shape, UtilLib.RotationAmount.TWO_HUNDRED_SEVENTY);
                default -> throw new IllegalArgumentException("Wrong direction argument");
            };
        }
    }
}

