/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.vampirism.blocks.VampirismBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class AltarPillarBlock
extends VampirismBlock {
    public static final EnumProperty<EnumPillarType> TYPE_PROPERTY = EnumProperty.create((String)"type", EnumPillarType.class);
    protected static final VoxelShape pillarShape = AltarPillarBlock.makeShape();
    protected static final VoxelShape pillarShapeFilled = AltarPillarBlock.makeShapeFull();

    @NotNull
    private static VoxelShape makeShape() {
        VoxelShape a = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
        VoxelShape b1 = Block.box((double)3.0, (double)0.0, (double)3.0, (double)4.0, (double)16.0, (double)4.0);
        VoxelShape b2 = Block.box((double)12.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)4.0);
        VoxelShape b3 = Block.box((double)3.0, (double)0.0, (double)12.0, (double)4.0, (double)16.0, (double)13.0);
        VoxelShape b4 = Block.box((double)12.0, (double)0.0, (double)12.0, (double)13.0, (double)16.0, (double)13.0);
        VoxelShape c = Block.box((double)3.0, (double)15.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
        return Shapes.or((VoxelShape)a, (VoxelShape[])new VoxelShape[]{b1, b2, b3, b4, c});
    }

    @NotNull
    private static VoxelShape makeShapeFull() {
        VoxelShape b = Block.box((double)4.0, (double)1.0, (double)2.0, (double)12.0, (double)15.0, (double)14.0);
        VoxelShape c = Block.box((double)2.0, (double)1.0, (double)4.0, (double)14.0, (double)15.0, (double)12.0);
        return Shapes.or((VoxelShape)pillarShape, (VoxelShape[])new VoxelShape[]{b, c});
    }

    public AltarPillarBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(0.9f).noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(TYPE_PROPERTY, (Comparable)((Object)EnumPillarType.NONE)));
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return state.getValue(TYPE_PROPERTY) != EnumPillarType.NONE ? pillarShapeFilled : pillarShape;
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull Player playerIn, @NotNull BlockHitResult hit) {
        EnumPillarType type = (EnumPillarType)((Object)state.getValue(TYPE_PROPERTY));
        ItemStack heldItem = playerIn.getItemInHand(InteractionHand.MAIN_HAND);
        if (type != EnumPillarType.NONE && heldItem.isEmpty()) {
            if (!playerIn.getAbilities().instabuild) {
                playerIn.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)type.fillerBlock));
            }
            worldIn.setBlockAndUpdate(pos, (BlockState)state.setValue(TYPE_PROPERTY, (Comparable)((Object)EnumPillarType.NONE)));
            return InteractionResult.SUCCESS;
        }
        if (type == EnumPillarType.NONE && !heldItem.isEmpty()) {
            for (EnumPillarType t : EnumPillarType.values()) {
                if (!heldItem.getItem().equals(t.fillerBlock.asItem())) continue;
                if (!playerIn.getAbilities().instabuild) {
                    heldItem.shrink(1);
                }
                worldIn.setBlockAndUpdate(pos, (BlockState)state.setValue(TYPE_PROPERTY, (Comparable)((Object)t)));
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TYPE_PROPERTY});
    }

    public static enum EnumPillarType implements StringRepresentable
    {
        NONE(0, "none", 0.0f, Blocks.AIR),
        STONE(1, "stone", 1.0f, Blocks.STONE_BRICKS),
        IRON(2, "iron", 2.0f, Blocks.IRON_BLOCK),
        GOLD(3, "gold", 3.0f, Blocks.GOLD_BLOCK),
        BONE(4, "bone", 1.5f, Blocks.BONE_BLOCK);

        public final String name;
        public final Block fillerBlock;
        public final int meta;
        private final float value;

        private EnumPillarType(int meta, String name, float value, Block fillerBlock) {
            this.meta = meta;
            this.name = name;
            this.fillerBlock = fillerBlock;
            this.value = value;
        }

        @NotNull
        public String getName() {
            return this.getSerializedName();
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        public float getValue() {
            return this.value;
        }

        @NotNull
        public String toString() {
            return this.getName();
        }
    }
}

