/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blockentity;

import de.teamlapen.lib.lib.blockentity.InventoryBlockEntity;
import de.teamlapen.lib.lib.inventory.InventoryHelper;
import de.teamlapen.lib.lib.util.ValuedObject;
import de.teamlapen.vampirism.advancements.critereon.VampireActionCriterionTrigger;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.blocks.AltarPillarBlock;
import de.teamlapen.vampirism.client.VampirismModClient;
import de.teamlapen.vampirism.core.ModAdvancements;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.entity.player.vampire.VampireLeveling;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.entity.vampire.DrinkBloodContext;
import de.teamlapen.vampirism.inventory.AltarInfusionMenu;
import de.teamlapen.vampirism.items.PureBloodItem;
import de.teamlapen.vampirism.particle.FlyingBloodParticleOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AltarInfusionBlockEntity
extends InventoryBlockEntity {
    private static final Logger LOGGER = LogManager.getLogger(AltarInfusionBlockEntity.class);
    private static final int DURATION_TICK = 450;
    @Nullable
    private UUID playerToLoadUUID;
    @Nullable
    private Player player;
    private BlockPos @Nullable [] tips;
    private int runningTick;
    private int targetLevel;

    public AltarInfusionBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        super((BlockEntityType)ModTiles.ALTAR_INFUSION.get(), pos, state, AltarInfusionMenu.createInputSlotDefinition());
    }

    @NotNull
    public Result canActivate(@NotNull Player player) {
        if (this.runningTick > 0) {
            return Result.ISRUNNING;
        }
        this.player = null;
        this.targetLevel = VampirismPlayerAttributes.get((Player)player).vampireLevel + 1;
        int requiredLevel = this.checkRequiredLevel();
        if (requiredLevel == -1) {
            return Result.WRONGLEVEL;
        }
        if (player.getCommandSenderWorld().isDay()) {
            return Result.NIGHTONLY;
        }
        if (!this.checkStructureLevel(requiredLevel)) {
            this.tips = null;
            return Result.STRUCTUREWRONG;
        }
        if (!this.checkItemRequirements()) {
            this.tips = null;
            return Result.INVMISSING;
        }
        return Result.OK;
    }

    @NotNull
    public PHASE getCurrentPhase() {
        if (this.runningTick < 1) {
            return PHASE.NOT_RUNNING;
        }
        if (this.runningTick == 1) {
            return PHASE.CLEAN_UP;
        }
        if (this.runningTick > 350) {
            return PHASE.PARTICLE_SPREAD;
        }
        if (this.runningTick < 290 && this.runningTick >= 250) {
            return PHASE.BEAM1;
        }
        if (this.runningTick < 250 && this.runningTick > 50) {
            return PHASE.BEAM2;
        }
        if (this.runningTick == 50) {
            return PHASE.LEVELUP;
        }
        if (this.runningTick < 50) {
            return PHASE.ENDING;
        }
        return PHASE.WAITING;
    }

    @Nullable
    public Player getPlayer() {
        if (this.runningTick <= 1) {
            return null;
        }
        return this.player;
    }

    public int getRunningTick() {
        return this.runningTick;
    }

    public BlockPos @Nullable [] getTips() {
        if (this.runningTick <= 1) {
            return null;
        }
        return this.tips;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider lookupProvider) {
        return this.saveWithoutMetadata(lookupProvider);
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag tagCompound, HolderLookup.Provider lookupProvider) {
        super.loadAdditional(tagCompound, lookupProvider);
        int tick = tagCompound.getInt("tick");
        if (tick > 0 && this.player == null && tagCompound.hasUUID("playerUUID")) {
            UUID playerID = tagCompound.getUUID("playerUUID");
            if (!this.loadRitual(playerID)) {
                this.playerToLoadUUID = playerID;
            }
            this.runningTick = tick;
        }
    }

    public void onDataPacket(Connection net, @NotNull ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        CompoundTag tag = pkt.getTag();
        if (this.hasLevel()) {
            this.loadCustomOnly(tag, lookupProvider);
        }
    }

    @Override
    public void saveAdditional(@NotNull CompoundTag compound, HolderLookup.Provider lookupProvider) {
        super.saveAdditional(compound, lookupProvider);
        compound.putInt("tick", this.runningTick);
        if (this.player != null) {
            compound.putUUID("playerUUID", this.player.getUUID());
        }
    }

    public void startRitual(@NotNull Player player) {
        if (this.level == null) {
            return;
        }
        LOGGER.debug("Starting ritual for {}", (Object)player);
        this.player = player;
        this.runningTick = 450;
        this.setChanged();
        if (!this.level.isClientSide) {
            for (BlockPos pTip : this.tips) {
                ModParticles.spawnParticlesServer(this.level, new FlyingBloodParticleOptions(60, false, (double)pTip.getX() + 0.5, (double)pTip.getY() + 0.3, (double)pTip.getZ() + 0.5), (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5, 3, 0.1, 0.1, 0.1, 0.0);
            }
            BlockState state = this.level.getBlockState(this.getBlockPos());
            this.level.sendBlockUpdated(this.getBlockPos(), state, state, 3);
        }
        player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 450, 10));
        this.setChanged();
    }

    private void tickRitual() {
        if (this.player == null || !this.player.isAlive()) {
            this.runningTick = 1;
        } else if (this.player.getDeltaMovement().y >= 0.0) {
            this.player.setDeltaMovement(0.0, 0.0, 0.0);
        } else {
            this.player.setDeltaMovement(0.0, this.player.getDeltaMovement().y, 0.0);
            this.player.setDeltaMovement(this.player.getDeltaMovement().multiply(1.0, 0.5, 1.0));
        }
        PHASE phase = this.getCurrentPhase();
        if (this.level.isClientSide) {
            if (phase.equals((Object)PHASE.PARTICLE_SPREAD) && this.runningTick % 15 == 0) {
                BlockPos pos = this.getBlockPos();
                for (BlockPos pTip : this.tips) {
                    ModParticles.spawnParticlesClient(this.level, new FlyingBloodParticleOptions(60, false, (double)pTip.getX() + 0.5, (double)pTip.getY() + 0.3, (double)pTip.getZ() + 0.5), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 0.0, 0.0, 0.0, 5, 0.1, RandomSource.create());
                }
            }
            if (this.runningTick == 250 && this.getPlayer().isLocalPlayer()) {
                VampirismModClient.getINSTANCE().getOverlay().makeRenderFullColor(200, 50, 0xFF0000);
            }
        }
        if (phase.equals((Object)PHASE.CLEAN_UP)) {
            this.player = null;
            this.tips = null;
            this.setChanged();
            this.runningTick = 0;
        }
        if (phase.equals((Object)PHASE.LEVELUP)) {
            if (!this.level.isClientSide) {
                assert (this.player.isAlive());
                FactionPlayerHandler handler = FactionPlayerHandler.get(this.player);
                if (handler.getCurrentLevel(VReference.VAMPIRE_FACTION) != this.targetLevel - 1) {
                    LOGGER.warn("Player {} changed level while the ritual was running. Cannot levelup.", (Object)this.player);
                    return;
                }
                handler.setFactionLevel(VReference.VAMPIRE_FACTION, handler.getCurrentLevel(VReference.VAMPIRE_FACTION) + 1);
                VampirePlayer.get(this.player).drinkBlood(Integer.MAX_VALUE, 0.0f, false, DrinkBloodContext.none());
                Player player = this.player;
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ((VampireActionCriterionTrigger)((Object)ModAdvancements.TRIGGER_VAMPIRE_ACTION.get())).trigger(serverPlayer, VampireActionCriterionTrigger.Action.PERFORM_RITUAL_INFUSION);
                }
            } else {
                this.level.playLocalSound(this.player.getX(), this.player.getY(), this.player.getZ(), (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.BLOCKS, 4.0f, (1.0f + (this.level.random.nextFloat() - this.level.random.nextFloat()) * 0.2f) * 0.7f, true);
                this.level.addParticle((ParticleOptions)ParticleTypes.EXPLOSION, this.player.getX(), this.player.getY(), this.player.getZ(), 1.0, 0.0, 0.0);
            }
            this.player.addEffect(new MobEffectInstance(ModEffects.SATURATION, 400, 2));
            this.player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 400, 2));
            this.player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 400, 2));
        }
    }

    public static void tick(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull AltarInfusionBlockEntity blockEntity) {
        if (blockEntity.playerToLoadUUID != null) {
            if (!blockEntity.loadRitual(blockEntity.playerToLoadUUID)) {
                return;
            }
            blockEntity.playerToLoadUUID = null;
            blockEntity.setChanged();
            level.sendBlockUpdated(pos, state, state, 3);
        }
        if (blockEntity.runningTick == 450 && !level.isClientSide) {
            LOGGER.debug("Ritual started");
            blockEntity.consumeItems();
            blockEntity.setChanged();
        }
        if (blockEntity.runningTick > 0) {
            --blockEntity.runningTick;
            blockEntity.tickRitual();
        }
    }

    @NotNull
    protected AbstractContainerMenu createMenu(int id, @NotNull Inventory player) {
        return new AltarInfusionMenu(id, player, (Container)this, this.level == null ? ContainerLevelAccess.NULL : ContainerLevelAccess.create((Level)this.level, (BlockPos)this.worldPosition));
    }

    @NotNull
    protected Component getDefaultName() {
        return Component.translatable((String)"tile.vampirism.altar_infusion");
    }

    @Override
    @NotNull
    protected NonNullList<ItemStack> getItems() {
        return this.inventorySlots;
    }

    @Override
    protected void setItems(@NotNull NonNullList<ItemStack> items) {
        this.inventorySlots = items;
    }

    private boolean checkItemRequirements() {
        int newLevel = this.targetLevel;
        ItemStack missing = VampireLeveling.getInfusionRequirement(newLevel).map(req -> InventoryHelper.checkItems((Container)this, new Item[]{PureBloodItem.getBloodItemForLevel(req.pureBloodLevel()), (Item)ModItems.HUMAN_HEART.get(), (Item)ModItems.VAMPIRE_BOOK.get()}, new int[]{req.pureBloodQuantity(), req.humanHeartQuantity(), req.vampireBookQuantity()}, (supplied, required) -> {
            if (supplied.equals(required)) return true;
            if (!(supplied instanceof PureBloodItem)) return false;
            PureBloodItem suppliedBlood = (PureBloodItem)((Object)((Object)supplied));
            if (!(required instanceof PureBloodItem)) return false;
            PureBloodItem requiredBlood = (PureBloodItem)((Object)((Object)required));
            if (suppliedBlood.getLevel() < requiredBlood.getLevel()) return false;
            return true;
        })).orElse(ItemStack.EMPTY);
        return missing.isEmpty();
    }

    private int checkRequiredLevel() {
        int newLevel = this.targetLevel;
        return VampireLeveling.getInfusionRequirement(newLevel).map(VampireLeveling.AltarInfusionRequirements::getRequiredStructurePoints).orElse(-1);
    }

    private boolean checkStructureLevel(int required) {
        int i;
        int v;
        if (this.level == null) {
            return false;
        }
        BlockPos[] tips = this.findTips();
        ValuedObject[] valuedTips = new ValuedObject[tips.length];
        for (int i2 = 0; i2 < tips.length; ++i2) {
            BlockState temp;
            BlockPos pPos = tips[i2];
            int j = 0;
            AltarPillarBlock.EnumPillarType type = null;
            while ((temp = this.level.getBlockState(pPos.offset(0, -j - 1, 0))).getBlock().equals(ModBlocks.ALTAR_PILLAR.get())) {
                AltarPillarBlock.EnumPillarType t = (AltarPillarBlock.EnumPillarType)((Object)temp.getValue(AltarPillarBlock.TYPE_PROPERTY));
                if (type == null) {
                    type = t;
                    ++j;
                    continue;
                }
                if (!type.equals((Object)t)) break;
                ++j;
            }
            int value = (int)((float)(10 * Math.min(j, 3)) * (type == null ? 0.0f : type.getValue()));
            valuedTips[i2] = new ValuedObject<BlockPos>(tips[i2], value);
        }
        Arrays.sort(valuedTips, ValuedObject.getInvertedComparator());
        int found = 0;
        for (i = 0; found < required * 10 && i < valuedTips.length && i < 9 && (v = valuedTips[i].value) != 0; found += v, ++i) {
        }
        valuedTips = Arrays.copyOfRange(valuedTips, 0, i);
        this.tips = ValuedObject.extract(BlockPos.class, valuedTips);
        return found >= required * 10;
    }

    private void consumeItems() {
        VampireLeveling.getInfusionRequirement(this.targetLevel).ifPresent(req -> InventoryHelper.removeItems((Container)this, req.pureBloodQuantity(), req.humanHeartQuantity(), req.vampireBookQuantity()));
    }

    private BlockPos @NotNull [] findTips() {
        if (this.level == null) {
            return new BlockPos[0];
        }
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = this.getBlockPos().getX() - 4; x < this.getBlockPos().getX() + 5; ++x) {
            for (int y = this.getBlockPos().getY() + 1; y < this.getBlockPos().getY() + 4; ++y) {
                for (int z = this.getBlockPos().getZ() - 4; z < this.getBlockPos().getZ() + 5; ++z) {
                    if (!this.level.getBlockState((BlockPos)pos.set(x, y, z)).getBlock().equals(ModBlocks.ALTAR_TIP.get())) continue;
                    list.add(new BlockPos(x, y, z));
                }
            }
        }
        return list.toArray(new BlockPos[0]);
    }

    private boolean loadRitual(@NotNull UUID playerID) {
        if (this.level == null) {
            return false;
        }
        if (this.level.players().isEmpty()) {
            return false;
        }
        this.player = this.level.getPlayerByUUID(playerID);
        if (this.player != null && this.player.isAlive()) {
            this.targetLevel = VampirismPlayerAttributes.get((Player)this.player).vampireLevel + 1;
            this.checkStructureLevel(this.checkRequiredLevel());
        } else {
            this.runningTick = 0;
            this.tips = null;
            LOGGER.warn("Failed to find player {}", (Object)playerID);
        }
        return true;
    }

    public static enum Result {
        OK,
        ISRUNNING,
        WRONGLEVEL,
        NIGHTONLY,
        STRUCTUREWRONG,
        INVMISSING;

    }

    public static enum PHASE {
        NOT_RUNNING,
        PARTICLE_SPREAD,
        BEAM1,
        BEAM2,
        WAITING,
        LEVELUP,
        ENDING,
        CLEAN_UP;

    }
}

