/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.util;

import com.mojang.datafixers.util.Either;
import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.factions.ISkillTree;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.skills.DefaultSkill;
import de.teamlapen.vampirism.api.entity.player.skills.IActionSkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.neoforged.neoforge.registries.callback.AddCallback;
import net.neoforged.neoforge.registries.callback.ClearCallback;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkillCallbacks
implements AddCallback<ISkill<?>>,
ClearCallback<ISkill<?>> {
    private static final Map<IAction<?>, ISkill<?>> ACTION_TO_SKILL_MAP = new HashMap();
    private static final Map<IAction<?>, ISkill<?>> ACTION_TO_SKILL_MAP_READ_ONLY = Collections.unmodifiableMap(ACTION_TO_SKILL_MAP);

    public void onAdd(@NotNull Registry<ISkill<?>> registry, int id, @NotNull ResourceKey<ISkill<?>> key, @NotNull ISkill<?> value) {
        if (value instanceof IActionSkill) {
            IActionSkill actionSkill = (IActionSkill)value;
            ACTION_TO_SKILL_MAP.put(actionSkill.action(), actionSkill);
        } else if (value instanceof DefaultSkill) {
            DefaultSkill defaultSkill = (DefaultSkill)value;
            defaultSkill.getActions().forEach(action -> ACTION_TO_SKILL_MAP.put((IAction<?>)action, new EmptyActionSkill(action)));
        }
    }

    public void onClear(@NotNull Registry<ISkill<?>> registry, boolean full) {
        if (full) {
            ACTION_TO_SKILL_MAP.clear();
        }
    }

    public static <T extends IFactionPlayer<T>> Map<IAction<T>, ISkill<T>> getActionSkillMap() {
        return ACTION_TO_SKILL_MAP_READ_ONLY;
    }

    public record EmptyActionSkill<T extends IFactionPlayer<T>>(IAction<T> action) implements IActionSkill<T>
    {
        private static final TagKey<ISkillTree> key = TagKey.create(VampirismRegistries.Keys.SKILL_TREE, (ResourceLocation)VResourceLocation.mod("empty"));

        @Override
        @Nullable
        public Component getDescription() {
            return null;
        }

        @Override
        @NotNull
        public Optional<IPlayableFaction<?>> getFaction() {
            return this.action.getFaction();
        }

        @Override
        public String getTranslationKey() {
            return this.action.getTranslationKey();
        }

        @Override
        public void onDisable(T player) {
        }

        @Override
        public void onEnable(T player) {
        }

        @Override
        public Either<ResourceKey<ISkillTree>, TagKey<ISkillTree>> allowedSkillTrees() {
            return Either.right(key);
        }
    }
}

