/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api;

import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public enum EnumStrength implements StringRepresentable
{
    NONE("none", 0),
    WEAK("weak", 1),
    MEDIUM("medium", 2),
    STRONG("strong", 3);

    private final String name;
    final int strength;

    @NotNull
    public static EnumStrength getFromStrength(int strength) {
        for (EnumStrength s : EnumStrength.values()) {
            if (s.strength != strength) continue;
            return s;
        }
        return NONE;
    }

    private EnumStrength(String name, int strength) {
        this.name = name;
        this.strength = strength;
    }

    public int getStrength() {
        return this.strength;
    }

    public boolean isStrongerThan(@NotNull EnumStrength compare) {
        return this.strength > compare.strength;
    }

    @NotNull
    public String getSerializedName() {
        return this.name;
    }
}

