/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.proxy;

import de.teamlapen.lib.proxy.CommonProxy;
import de.teamlapen.lib.util.ISoundReference;
import de.teamlapen.lib.util.SoundReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ClientProxy
extends CommonProxy {
    @Override
    @NotNull
    public ISoundReference createMasterSoundReference(@NotNull SoundEvent event, float volume, float pinch) {
        return new SoundReference((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)event, (float)volume, (float)pinch));
    }

    @Override
    @NotNull
    public ISoundReference createSoundReference(@NotNull SoundEvent event, @NotNull SoundSource category, @NotNull BlockPos pos, float volume, float pinch) {
        return new SoundReference((SoundInstance)new SimpleSoundInstance(event, category, volume, pinch, RandomSource.create(), pos));
    }

    @Override
    @NotNull
    public ISoundReference createSoundReference(@NotNull SoundEvent event, @NotNull SoundSource category, double x, double y, double z, float volume, float pinch) {
        return new SoundReference((SoundInstance)new SimpleSoundInstance(event, category, volume, pinch, RandomSource.create(), (double)((float)x), (double)((float)y), (double)((float)z)));
    }

    @Override
    @NotNull
    public String getActiveLanguage() {
        return Minecraft.getInstance().getLanguageManager().getSelected();
    }

    @Override
    public Level getWorldFromKey(ResourceKey<Level> world) {
        Level serverWorld = super.getWorldFromKey(world);
        if (serverWorld != null) {
            return serverWorld;
        }
        ClientLevel clientWorld = Minecraft.getInstance().level;
        if (clientWorld != null && clientWorld.dimension().equals(world)) {
            return clientWorld;
        }
        return null;
    }
}

