/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib;

import com.google.common.collect.ImmutableMap;
import de.teamlapen.lib.lib.entity.IPlayerEventListener;
import de.teamlapen.lib.lib.storage.IAttachedSyncable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class HelperRegistry {
    @NotNull
    private static Map<ResourceLocation, AttachmentType<IAttachedSyncable>> syncablePlayerCaps = new ConcurrentHashMap<ResourceLocation, AttachmentType<IAttachedSyncable>>();
    @NotNull
    private static Map<ResourceLocation, AttachmentType<IAttachedSyncable>> syncableEntityCaps = new ConcurrentHashMap<ResourceLocation, AttachmentType<IAttachedSyncable>>();
    @NotNull
    private static Set<AttachmentType<IPlayerEventListener>> playerEventListenerCaps = ConcurrentHashMap.newKeySet();
    private static AttachmentType<IPlayerEventListener>[] playerEventListenerCapsFinal;
    private static ImmutableMap<ResourceLocation, AttachmentType<IAttachedSyncable>> syncablePlayerCapsFinal;
    private static ImmutableMap<ResourceLocation, AttachmentType<IAttachedSyncable>> syncableEntityCapsFinal;

    @NotNull
    static AttachmentType<IPlayerEventListener>[] getEventListenerCaps() {
        return playerEventListenerCapsFinal;
    }

    @ApiStatus.Internal
    @NotNull
    public static ImmutableMap<ResourceLocation, AttachmentType<IAttachedSyncable>> getSyncablePlayerCaps() {
        return syncablePlayerCapsFinal;
    }

    @ApiStatus.Internal
    @NotNull
    public static ImmutableMap<ResourceLocation, AttachmentType<IAttachedSyncable>> getSyncableEntityCaps() {
        return syncableEntityCapsFinal;
    }

    public static void registerSyncableEntityCapability(AttachmentType<IAttachedSyncable> capability, Class<? extends IAttachedSyncable> clz) {
        if (syncableEntityCaps == Collections.EMPTY_MAP) {
            throw new IllegalStateException("Cannot register syncable entity capability " + String.valueOf(clz) + "(" + String.valueOf(capability) + ") after the InterModEnqueueEvent");
        }
        syncableEntityCaps.put(NeoForgeRegistries.ATTACHMENT_TYPES.getKey(capability), capability);
    }

    public static void registerSyncablePlayerCapability(AttachmentType<IAttachedSyncable> capability, Class<? extends IAttachedSyncable> clz) {
        if (syncablePlayerCaps == Collections.EMPTY_MAP) {
            throw new IllegalStateException("Cannot register syncable property " + String.valueOf(clz) + "(" + String.valueOf(capability) + ") after the InterModEnqueueEvent");
        }
        syncablePlayerCaps.put(NeoForgeRegistries.ATTACHMENT_TYPES.getKey(capability), capability);
    }

    public static void registerPlayerEventReceivingCapability(AttachmentType<IPlayerEventListener> capability, Class<? extends IPlayerEventListener> clz) {
        if (playerEventListenerCaps == Collections.EMPTY_SET) {
            throw new IllegalStateException("Cannot register PlayerEventReceiver (" + String.valueOf(capability) + ") after the InterModEnqueueEvent");
        }
        playerEventListenerCaps.add(capability);
    }

    static void finish() {
        syncableEntityCapsFinal = ImmutableMap.copyOf(syncableEntityCaps);
        syncableEntityCaps = Collections.emptyMap();
        syncablePlayerCapsFinal = ImmutableMap.copyOf(syncablePlayerCaps);
        syncablePlayerCaps = Collections.emptyMap();
        playerEventListenerCapsFinal = (AttachmentType[])playerEventListenerCaps.toArray(AttachmentType[]::new);
        playerEventListenerCaps = Collections.emptySet();
    }
}

