/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.vampiricageing.command;

import com.google.common.collect.Lists;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.thedrofdoctoring.vampiricageing.capabilities.AgeingManager;
import de.teamlapen.lib.lib.util.BasicCommand;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class ChangeRankProgressCommand
extends BasicCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"increase_rank_progress").requires(context -> context.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument((String)"rank_progress", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> ChangeRankProgressCommand.increaseRankProgress((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"rank_progress"), Lists.newArrayList((Object[])new ServerPlayer[]{((CommandSourceStack)context.getSource()).getPlayerOrException()})))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.entities()).executes(context -> ChangeRankProgressCommand.increaseRankProgress((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"rank_Progress"), EntityArgument.getPlayers((CommandContext)context, (String)"player")))));
    }

    private static int increaseRankProgress(@NotNull CommandContext<CommandSourceStack> context, int rankProgress, @NotNull Collection<ServerPlayer> players) {
        for (ServerPlayer player : players) {
            int level = FactionPlayerHandler.get((Player)player).getCurrentLevel();
            AgeingManager manager = AgeingManager.getAge((Player)player);
            int age = manager.getAge();
            if (age < 6 && age >= 0 && level > 0) {
                manager.increaseRankPoints(rankProgress);
                manager.sync(false);
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.vampiricageing.base.rank_progress_sucess", (Object[])new Object[]{player.getName(), rankProgress}), true);
                continue;
            }
            if (age > 5 || age < 0) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)(players.size() > 1 ? Component.translatable((String)"command.vampiricageing.failed_to_execute.players.invalid_age", (Object[])new Object[]{player.getDisplayName()}) : Component.translatable((String)"command.vampiricageing.failed_to_execute.invalid_age")));
                continue;
            }
            if (manager.getType() == null) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)(players.size() > 1 ? Component.translatable((String)"command.vampiricageing.failed_to_execute.players.wrong_faction", (Object[])new Object[]{player.getDisplayName()}) : Component.translatable((String)"command.vampiricageing.failed_to_execute.player_wrong_faction")));
                continue;
            }
            ((CommandSourceStack)context.getSource()).sendFailure((Component)(players.size() > 1 ? Component.translatable((String)"command.vampiricageing.failed_to_execute.players", (Object[])new Object[]{player.getDisplayName()}) : Component.translatable((String)"command.vampiricageing.failed_to_execute")));
        }
        return 0;
    }
}

