/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.vampiricageing.capabilities.ageing.methods;

import com.thedrofdoctoring.vampiricageing.AgeingReference;
import com.thedrofdoctoring.vampiricageing.capabilities.ageing.IAgeMethod;
import com.thedrofdoctoring.vampiricageing.capabilities.ageing.IAgeType;
import com.thedrofdoctoring.vampiricageing.config.WerewolvesAgeingConfig;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.neoforged.fml.ModList;

public class DevourMethod
implements IAgeMethod {
    private static int[] devoured;
    private static final String ID = "DEVOUR";

    @Override
    public int[] getRankProgressions() {
        if (devoured == null) {
            devoured = Arrays.stream(((List)WerewolvesAgeingConfig.devouredForNextAge.get()).toArray()).mapToInt(o -> (Integer)o).toArray();
        }
        return devoured;
    }

    @Override
    public boolean isEnabled() {
        return ModList.get().isLoaded("werewolves") && ((String)WerewolvesAgeingConfig.ageingMethod.get()).equals(ID);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public IAgeType getValidType() {
        return AgeingReference.WEREWOLF;
    }

    @Override
    public void displayLevelRequirements(Player player, int points, int age) {
        int pointsForNextAge = this.getRankProgressions()[age] - points;
        player.displayClientMessage((Component)Component.translatable((String)"text.vampiricageing.progress_devour", (Object[])new Object[]{pointsForNextAge}).withStyle(ChatFormatting.DARK_RED), true);
    }
}

