/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.vampiricageing.capabilities.ageing.methods;

import com.thedrofdoctoring.vampiricageing.AgeingReference;
import com.thedrofdoctoring.vampiricageing.capabilities.ageing.IAgeMethod;
import com.thedrofdoctoring.vampiricageing.capabilities.ageing.IAgeType;
import com.thedrofdoctoring.vampiricageing.config.CommonConfig;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class BitingMethod
implements IAgeMethod {
    private static int[] infected;
    private static final String ID = "BITING";

    @Override
    public int[] getRankProgressions() {
        if (infected == null) {
            infected = Arrays.stream(((List)CommonConfig.infectedForNextAge.get()).toArray()).mapToInt(o -> (Integer)o).toArray();
        }
        return infected;
    }

    @Override
    public boolean isEnabled() {
        return ((String)CommonConfig.ageingMethod.get()).equals(ID);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public IAgeType getValidType() {
        return AgeingReference.VAMP;
    }

    @Override
    public void displayLevelRequirements(Player player, int points, int age) {
        int pointsForNextAge = this.getRankProgressions()[age] - points;
        player.displayClientMessage((Component)Component.translatable((String)"text.vampiricageing.progress_infected", (Object[])new Object[]{pointsForNextAge}).withStyle(ChatFormatting.DARK_RED), true);
    }
}

