/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.vampiricageing.actions;

import com.thedrofdoctoring.vampiricageing.capabilities.other.IVampSpecialAttributes;
import com.thedrofdoctoring.vampiricageing.config.CommonConfig;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.vampire.DefaultVampireAction;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class WaterWalkingAction
extends DefaultVampireAction
implements ILastingAction<IVampirePlayer> {
    public boolean activate(@NotNull IVampirePlayer vampire, IAction.ActivationContext context) {
        this.activate(vampire);
        return true;
    }

    protected void activate(IVampirePlayer player) {
        IVampSpecialAttributes specialAttributes = (IVampSpecialAttributes)((VampirePlayer)player).getSpecialAttributes();
        specialAttributes.ageing$setWaterWalking(true);
    }

    public int getCooldown(IVampirePlayer player) {
        return (Integer)CommonConfig.waterWalkingCooldown.get() * 20;
    }

    public int getDuration(@NotNull IVampirePlayer player) {
        return Mth.clamp((int)((Integer)CommonConfig.waterWalkingDuration.get()), (int)10, (int)0x6666665) * 20;
    }

    public boolean isEnabled() {
        return (Boolean)CommonConfig.ageWaterWalking.get();
    }

    public void onActivatedClient(IVampirePlayer vampire) {
        this.activate(vampire);
    }

    public void onDeactivated(@NotNull IVampirePlayer vampire) {
        IVampSpecialAttributes specialAttributes = (IVampSpecialAttributes)((VampirePlayer)vampire).getSpecialAttributes();
        specialAttributes.ageing$setWaterWalking(false);
    }

    public void onReActivated(IVampirePlayer vampire) {
        this.activate(vampire);
    }

    public boolean onUpdate(IVampirePlayer vampire) {
        return false;
    }

    public boolean showHudCooldown(Player player) {
        return true;
    }

    public boolean showHudDuration(Player player) {
        return true;
    }
}

