/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.structure;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import folk.sisby.surveyor.structure.StructurePieceSummary;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2338;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3773;
import net.minecraft.class_3776;
import net.minecraft.class_3780;
import net.minecraft.class_3781;
import net.minecraft.class_3782;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_3816;
import net.minecraft.class_5321;
import net.minecraft.class_6625;

public class JigsawPieceSummary
extends StructurePieceSummary {
    public static final String KEY_POS = "pos";
    public static final String KEY_DELTA_Y = "deltaY";
    public static final String KEY_ROTATION = "rotation";
    public static final String KEY_JUNCTIONS = "junctions";
    public static final BiMap<String, class_3816<?>> TYPE_KEYS = HashBiMap.create(Map.of("single", class_3816.field_16973, "feature", class_3816.field_16971));
    protected final class_2338 pos;
    protected final int deltaY;
    protected final class_2470 rotation;
    protected final List<class_3780> junctions;
    protected final class_3816<?> elementType;
    protected final class_2960 id;

    public JigsawPieceSummary(class_2338 pos, int deltaY, class_2470 rotation, class_3816<?> elementType, class_2960 id, int chainLength, class_3341 boundingBox, List<class_3780> junctions) {
        super(class_3773.field_25840, chainLength, boundingBox, new class_2487());
        this.pos = pos;
        this.deltaY = deltaY;
        this.rotation = rotation;
        this.elementType = elementType;
        this.id = id;
        this.junctions = junctions;
    }

    public JigsawPieceSummary(class_2487 nbt) {
        super(nbt);
        this.pos = class_2338.method_10092((long)nbt.method_10537(KEY_POS));
        this.deltaY = nbt.method_10550(KEY_DELTA_Y);
        this.rotation = class_2470.values()[nbt.method_10550(KEY_ROTATION)];
        this.junctions = new ArrayList<class_3780>();
        if (nbt.method_10545(KEY_JUNCTIONS)) {
            int[] junctionArray = nbt.method_10561(KEY_JUNCTIONS);
            for (int i = 4; i <= junctionArray.length; i += 5) {
                this.junctions.add(new class_3780(junctionArray[i - 4], junctionArray[i - 3], junctionArray[i - 2], junctionArray[i - 1], class_3785.class_3786.values()[junctionArray[i]]));
            }
        }
        String idKey = TYPE_KEYS.keySet().stream().filter(arg_0 -> ((class_2487)nbt).method_10545(arg_0)).findFirst().orElseThrow();
        this.elementType = (class_3816)TYPE_KEYS.get((Object)idKey);
        this.id = class_2960.method_60654((String)nbt.method_10558(idKey));
    }

    public static List<StructurePieceSummary> tryFromElement(class_3784 poolElement, class_3790 piece) {
        if (poolElement instanceof class_3782) {
            class_3782 listElement = (class_3782)poolElement;
            ArrayList<StructurePieceSummary> allSummaries = new ArrayList<StructurePieceSummary>();
            listElement.field_16676.forEach(e -> allSummaries.addAll(JigsawPieceSummary.tryFromElement(e, piece)));
            return allSummaries;
        }
        if (poolElement instanceof class_3781) {
            class_3781 singleElement = (class_3781)poolElement;
            if (singleElement.field_24015.left().isPresent()) {
                return List.of(new JigsawPieceSummary(piece.method_16648(), piece.method_16646(), piece.method_16888(), class_3816.field_16973, (class_2960)singleElement.field_24015.left().orElseThrow(), piece.method_14923(), poolElement.method_16628(piece.field_17660, piece.method_16648(), piece.method_16888()), piece.method_16645()));
            }
        }
        if (poolElement instanceof class_3776) {
            class_3776 featureElement = (class_3776)poolElement;
            if (featureElement.field_16661.method_40230().isPresent()) {
                return List.of(new JigsawPieceSummary(piece.method_16648(), piece.method_16646(), piece.method_16888(), class_3816.field_16971, ((class_5321)featureElement.field_16661.method_40230().orElseThrow()).method_29177(), piece.method_14923(), poolElement.method_16628(piece.field_17660, piece.method_16648(), piece.method_16888()), piece.method_16645()));
            }
        }
        return List.of();
    }

    public static List<StructurePieceSummary> tryFromPiece(class_3443 piece) {
        if (piece instanceof class_3790) {
            class_3790 poolPiece = (class_3790)piece;
            return JigsawPieceSummary.tryFromElement(poolPiece.method_16644(), poolPiece);
        }
        return List.of();
    }

    @Override
    public void method_14943(class_6625 context, class_2487 nbt) {
        super.method_14943(context, nbt);
        nbt.method_10544(KEY_POS, this.pos.method_10063());
        nbt.method_10569(KEY_DELTA_Y, this.deltaY);
        nbt.method_10569(KEY_ROTATION, this.rotation.ordinal());
        String idKey = (String)TYPE_KEYS.inverse().get(this.elementType);
        nbt.method_10582(idKey, this.id.toString());
        if (!this.junctions.isEmpty()) {
            int[] junctionArray = new int[this.junctions.size() * 5];
            for (int i = 0; i < this.junctions.size(); ++i) {
                class_3780 j = this.junctions.get(i);
                junctionArray[i * 5] = j.method_16610();
                junctionArray[i * 5 + 1] = j.method_16611();
                junctionArray[i * 5 + 2] = j.method_16609();
                junctionArray[i * 5 + 3] = j.method_35367();
                junctionArray[i * 5 + 4] = j.method_35368().ordinal();
            }
            nbt.method_10539(KEY_JUNCTIONS, junctionArray);
        }
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public int getDeltaY() {
        return this.deltaY;
    }

    public class_2470 method_16888() {
        return this.rotation;
    }

    public class_3816<?> getElementType() {
        return this.elementType;
    }

    public class_2960 getId() {
        return this.id;
    }

    public List<class_3780> getJunctions() {
        return this.junctions;
    }
}

