/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.landmark;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.SurveyorEvents;
import folk.sisby.surveyor.SurveyorExploration;
import folk.sisby.surveyor.config.NetworkMode;
import folk.sisby.surveyor.config.SystemMode;
import folk.sisby.surveyor.landmark.Landmark;
import folk.sisby.surveyor.landmark.LandmarkType;
import folk.sisby.surveyor.landmark.Landmarks;
import folk.sisby.surveyor.packet.SyncLandmarksAddedPacket;
import folk.sisby.surveyor.packet.SyncLandmarksRemovedPacket;
import folk.sisby.surveyor.util.MapUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public class WorldLandmarks {
    protected final class_5321<class_1937> worldKey;
    protected final Map<LandmarkType<?>, Map<class_2338, Landmark<?>>> landmarks = new ConcurrentHashMap();
    protected boolean dirty = false;

    public WorldLandmarks(class_5321<class_1937> worldKey, Map<LandmarkType<?>, Map<class_2338, Landmark<?>>> landmarks) {
        this.worldKey = worldKey;
        this.landmarks.putAll(landmarks);
    }

    public static WorldLandmarks load(class_1937 world, File folder) {
        class_2487 landmarkNbt = new class_2487();
        File landmarksFile = new File(folder, "landmarks.dat");
        if (landmarksFile.exists()) {
            try {
                landmarkNbt = class_2507.method_30613((Path)landmarksFile.toPath(), (class_2505)class_2505.method_53898());
            }
            catch (IOException e) {
                Surveyor.LOGGER.error("[Surveyor] Error loading landmarks file for {}.", (Object)world.method_27983().method_29177(), (Object)e);
            }
        }
        Map<LandmarkType<?>, Map<class_2338, Landmark<?>>> landmarks = Landmarks.fromNbt(landmarkNbt);
        return new WorldLandmarks((class_5321<class_1937>)world.method_27983(), landmarks);
    }

    public boolean contains(LandmarkType<?> type, class_2338 pos) {
        return this.landmarks.containsKey(type) && this.landmarks.get(type).containsKey(pos);
    }

    public <T extends Landmark<T>> Landmark<T> get(LandmarkType<T> type, class_2338 pos) {
        return this.landmarks.get(type).get(pos);
    }

    public <T extends Landmark<T>> Map<class_2338, T> asMap(LandmarkType<T> type, SurveyorExploration exploration) {
        HashMap outMap = new HashMap();
        if (this.landmarks.containsKey(type)) {
            this.landmarks.get(type).forEach((pos, landmark) -> {
                if (exploration == null || exploration.exploredLandmark(this.worldKey, (Landmark<?>)landmark)) {
                    outMap.put(pos, landmark);
                }
            });
        }
        return outMap;
    }

    public Map<LandmarkType<?>, Map<class_2338, Landmark<?>>> asMap(SurveyorExploration exploration) {
        HashMap outmap = new HashMap();
        this.landmarks.forEach((type, map) -> map.forEach((pos, landmark) -> {
            if (exploration == null || exploration.exploredLandmark(this.worldKey, (Landmark<?>)landmark)) {
                outmap.computeIfAbsent((LandmarkType<?>)type, t -> new HashMap()).put(pos, landmark);
            }
        }));
        return outmap;
    }

    public Multimap<LandmarkType<?>, class_2338> keySet(SurveyorExploration exploration) {
        HashMultimap outMap = HashMultimap.create();
        this.landmarks.forEach((arg_0, arg_1) -> this.lambda$keySet$5(exploration, (Multimap)outMap, arg_0, arg_1));
        return outMap;
    }

    public void handleChanged(class_1937 world, Map<LandmarkType<?>, Map<class_2338, Landmark<?>>> changed, boolean local, @Nullable class_3222 sender) {
        HashMap landmarksAddedChanged = new HashMap();
        HashMap<LandmarkType, Map> landmarksRemoved = new HashMap<LandmarkType, Map>();
        changed.forEach((type, map) -> map.forEach((pos, mark) -> {
            if (this.contains((LandmarkType<?>)type, (class_2338)pos)) {
                landmarksAddedChanged.computeIfAbsent((LandmarkType<?>)type, t -> new HashMap()).put(pos, mark);
            } else {
                landmarksRemoved.computeIfAbsent((LandmarkType)type, t -> new HashMap()).put(pos, mark);
            }
        }));
        if (!landmarksRemoved.isEmpty()) {
            SurveyorEvents.Invoke.landmarksRemoved(world, MapUtil.keyMultiMap(landmarksRemoved));
        }
        if (!landmarksAddedChanged.isEmpty()) {
            SurveyorEvents.Invoke.landmarksAdded(world, MapUtil.keyMultiMap(landmarksAddedChanged));
        }
        if (!local) {
            HashMap<LandmarkType, Map> waypointsRemoved = new HashMap<LandmarkType, Map>();
            HashMap waypointsAddedChanged = new HashMap();
            landmarksRemoved.forEach((type, map) -> map.forEach((pos, mark) -> {
                if (mark.owner() != null) {
                    waypointsRemoved.computeIfAbsent((LandmarkType)type, t -> new HashMap()).put(pos, mark);
                }
            }));
            waypointsRemoved.forEach((type, map) -> map.forEach((pos, mark) -> {
                ((Map)landmarksRemoved.get(type)).remove(pos);
                if (((Map)landmarksRemoved.get(type)).isEmpty()) {
                    landmarksRemoved.remove(type);
                }
            }));
            landmarksAddedChanged.forEach((type, map) -> map.forEach((pos, mark) -> {
                if (mark.owner() != null) {
                    waypointsAddedChanged.computeIfAbsent((LandmarkType<?>)type, t -> new HashMap()).put(pos, mark);
                }
            }));
            waypointsAddedChanged.forEach((type, map) -> map.forEach((pos, mark) -> {
                ((Map)landmarksAddedChanged.get(type)).remove(pos);
                if (((Map)landmarksAddedChanged.get(type)).isEmpty()) {
                    landmarksAddedChanged.remove(type);
                }
            }));
            if (!landmarksRemoved.isEmpty()) {
                new SyncLandmarksRemovedPacket(MapUtil.keyMultiMap(landmarksRemoved)).send(sender, world, Surveyor.CONFIG.networking.landmarks);
            }
            if (!landmarksAddedChanged.isEmpty()) {
                new SyncLandmarksAddedPacket(landmarksAddedChanged).send(sender, world, Surveyor.CONFIG.networking.landmarks);
            }
            if (!waypointsRemoved.isEmpty()) {
                new SyncLandmarksRemovedPacket(MapUtil.keyMultiMap(waypointsRemoved)).send(sender, world, Surveyor.CONFIG.networking.waypoints);
            }
            if (!waypointsAddedChanged.isEmpty()) {
                new SyncLandmarksAddedPacket(waypointsAddedChanged).send(sender, world, Surveyor.CONFIG.networking.waypoints);
            }
        }
    }

    public Map<LandmarkType<?>, Map<class_2338, Landmark<?>>> putForBatch(Map<LandmarkType<?>, Map<class_2338, Landmark<?>>> changed, Landmark<?> landmark) {
        if (Surveyor.CONFIG.landmarks == SystemMode.FROZEN) {
            return changed;
        }
        this.landmarks.computeIfAbsent(landmark.type(), t -> new ConcurrentHashMap()).put(landmark.pos(), landmark);
        this.dirty();
        changed.computeIfAbsent(landmark.type(), t -> new HashMap()).put(landmark.pos(), landmark);
        return changed;
    }

    public void putLocal(class_1937 world, Landmark<?> landmark) {
        if (Surveyor.CONFIG.landmarks == SystemMode.FROZEN) {
            return;
        }
        Map<LandmarkType<?>, Map<class_2338, Landmark<?>>> changed = landmark.put(new HashMap(), world, this);
        this.handleChanged(world, changed, true, null);
    }

    public void put(class_1937 world, Landmark<?> landmark) {
        if (Surveyor.CONFIG.landmarks == SystemMode.FROZEN) {
            return;
        }
        Map<LandmarkType<?>, Map<class_2338, Landmark<?>>> changed = landmark.put(new HashMap(), world, this);
        this.handleChanged(world, changed, false, null);
    }

    public void put(class_3222 sender, class_3218 world, Landmark<?> landmark) {
        if (Surveyor.CONFIG.landmarks == SystemMode.FROZEN) {
            return;
        }
        Map<LandmarkType<?>, Map<class_2338, Landmark<?>>> changed = landmark.put(new HashMap(), (class_1937)world, this);
        this.handleChanged((class_1937)world, changed, false, sender);
    }

    public Map<LandmarkType<?>, Map<class_2338, Landmark<?>>> removeForBatch(Map<LandmarkType<?>, Map<class_2338, Landmark<?>>> changed, LandmarkType<?> type, class_2338 pos) {
        if (Surveyor.CONFIG.landmarks == SystemMode.FROZEN) {
            return changed;
        }
        if (!this.landmarks.containsKey(type) || !this.landmarks.get(type).containsKey(pos)) {
            return changed;
        }
        Landmark<?> landmark = this.landmarks.get(type).remove(pos);
        if (this.landmarks.get(type).isEmpty()) {
            this.landmarks.remove(type);
        }
        this.dirty();
        changed.computeIfAbsent(type, t -> new HashMap()).put(pos, landmark);
        return changed;
    }

    public void removeLocal(class_1937 world, LandmarkType<?> type, class_2338 pos) {
        if (Surveyor.CONFIG.landmarks == SystemMode.FROZEN) {
            return;
        }
        if (!this.landmarks.containsKey(type) || !this.landmarks.get(type).containsKey(pos)) {
            return;
        }
        Map<LandmarkType<?>, Map<class_2338, Landmark<?>>> changed = this.landmarks.get(type).get(pos).remove(new HashMap(), world, this);
        this.handleChanged(world, changed, true, null);
    }

    public void remove(class_1937 world, LandmarkType<?> type, class_2338 pos) {
        if (Surveyor.CONFIG.landmarks == SystemMode.FROZEN) {
            return;
        }
        if (!this.landmarks.containsKey(type) || !this.landmarks.get(type).containsKey(pos)) {
            return;
        }
        Map<LandmarkType<?>, Map<class_2338, Landmark<?>>> changed = this.landmarks.get(type).get(pos).remove(new HashMap(), world, this);
        this.handleChanged(world, changed, false, null);
    }

    public void remove(class_3222 sender, class_3218 world, LandmarkType<?> type, class_2338 pos) {
        if (Surveyor.CONFIG.landmarks == SystemMode.FROZEN) {
            return;
        }
        if (!this.landmarks.containsKey(type) || !this.landmarks.get(type).containsKey(pos)) {
            return;
        }
        Map<LandmarkType<?>, Map<class_2338, Landmark<?>>> changed = this.landmarks.get(type).get(pos).remove(new HashMap(), (class_1937)world, this);
        this.handleChanged((class_1937)world, changed, false, sender);
    }

    public void removeAll(class_1937 world, Class<?> clazz, class_2338 pos) {
        if (Surveyor.CONFIG.landmarks == SystemMode.FROZEN) {
            return;
        }
        HashMap changed = new HashMap();
        this.landmarks.forEach((type, map) -> {
            Landmark landmark;
            if (map.containsKey(pos) && clazz.isAssignableFrom((landmark = (Landmark)map.get(pos)).getClass())) {
                landmark.remove(changed, world, this);
            }
        });
        this.handleChanged(world, changed, false, null);
    }

    public int save(class_1937 world, File folder) {
        if (this.isDirty()) {
            File landmarksFile = new File(folder, "landmarks.dat");
            try {
                class_2507.method_30614((class_2487)Landmarks.writeNbt(this.landmarks, new class_2487()), (Path)landmarksFile.toPath());
                this.dirty = false;
            }
            catch (IOException e) {
                Surveyor.LOGGER.error("[Surveyor] Error writing landmarks file for {}.", (Object)world.method_27983().method_29177(), (Object)e);
            }
            return this.landmarks.values().stream().mapToInt(Map::size).sum();
        }
        return 0;
    }

    public void readUpdatePacket(class_1937 world, SyncLandmarksAddedPacket packet, @Nullable class_3222 sender) {
        HashMap changed = new HashMap();
        packet.landmarks().forEach((type, map) -> map.forEach((pos, landmark) -> {
            boolean owned;
            boolean waypoint = landmark.owner() != null;
            boolean bl = owned = sender == null || Surveyor.getUuid(sender).equals(landmark.owner());
            if (owned && (waypoint && Surveyor.CONFIG.networking.waypoints.atLeast(NetworkMode.SOLO) || !waypoint && Surveyor.CONFIG.networking.landmarks.atLeast(NetworkMode.SOLO))) {
                this.putForBatch(changed, (Landmark<?>)landmark);
            }
        }));
        if (!changed.isEmpty()) {
            this.handleChanged(world, changed, sender == null, sender);
        }
    }

    public void readUpdatePacket(class_1937 world, SyncLandmarksRemovedPacket packet, @Nullable class_3222 sender) {
        HashMap changed = new HashMap();
        packet.landmarks().forEach((type, pos) -> {
            boolean owned;
            if (!this.contains((LandmarkType<?>)type, (class_2338)pos)) {
                return;
            }
            Landmark landmark = this.get((LandmarkType)type, (class_2338)pos);
            boolean waypoint = landmark.owner() != null;
            boolean bl = owned = sender == null || Surveyor.getUuid(sender).equals(landmark.owner());
            if (owned && (waypoint && Surveyor.CONFIG.networking.waypoints.atLeast(NetworkMode.SOLO) || !waypoint && Surveyor.CONFIG.networking.landmarks.atLeast(NetworkMode.SOLO))) {
                this.removeForBatch(changed, (LandmarkType<?>)type, (class_2338)pos);
            }
        });
        if (!changed.isEmpty()) {
            this.handleChanged(world, changed, sender == null, sender);
        }
    }

    public SyncLandmarksAddedPacket createUpdatePacket(Multimap<LandmarkType<?>, class_2338> keySet) {
        HashMap landmarks = new HashMap();
        keySet.forEach((type, pos) -> landmarks.computeIfAbsent((LandmarkType<?>)type, k -> new HashMap()).put(pos, this.get((LandmarkType)type, (class_2338)pos)));
        return new SyncLandmarksAddedPacket(landmarks);
    }

    public boolean isDirty() {
        return this.dirty && Surveyor.CONFIG.landmarks != SystemMode.FROZEN;
    }

    private void dirty() {
        this.dirty = true;
    }

    private /* synthetic */ void lambda$keySet$5(SurveyorExploration exploration, Multimap outMap, LandmarkType type, Map map) {
        map.forEach((pos, landmark) -> {
            if (exploration == null || exploration.exploredLandmark(this.worldKey, (Landmark<?>)landmark)) {
                outMap.put((Object)type, pos);
            }
        });
    }
}

