/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.dsiafi.mixin;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import com.iafenvoy.dsiafi.DragonArmorHelper;
import com.iafenvoy.dsiafi.config.ArmorPointConfig;
import com.iafenvoy.iceandfire.data.DragonArmorPart;
import com.iafenvoy.iceandfire.item.ItemDragonArmor;
import java.util.Arrays;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;

@Pseudo
@Mixin(value={ItemDragonArmor.class})
public class ItemDragonArmorMixin
extends Item
implements Equipable {
    @Shadow
    @Final
    public DragonArmorPart dragonSlot;

    public ItemDragonArmorMixin(Item.Properties properties) {
        super(properties);
    }

    public boolean canEquip(@NotNull ItemStack stack, @NotNull EquipmentSlot armorType, @NotNull LivingEntity entity) {
        return DragonStateProvider.isDragon((Entity)entity) && entity.getEquipmentSlotForItem(stack) == armorType;
    }

    @NotNull
    public ItemAttributeModifiers getDefaultAttributeModifiers(@NotNull ItemStack stack) {
        ItemDragonArmor self = (ItemDragonArmor)this;
        Item transformed = DragonArmorHelper.transform((Item)self);
        int armor = ArmorPointConfig.get((Item)self);
        ItemAttributeModifiers modifiers = transformed.getDefaultAttributeModifiers(stack.transmuteCopy((ItemLike)transformed));
        if (armor >= 0) {
            EquipmentSlot slot = this.getEquipmentSlot();
            ResourceLocation resourcelocation = ResourceLocation.withDefaultNamespace((String)("armor." + Arrays.stream(ArmorItem.Type.values()).filter(x -> x.getSlot() == slot).findAny().orElse(ArmorItem.Type.BODY).getSerializedName()));
            return modifiers.withModifierAdded(Attributes.ARMOR, new AttributeModifier(resourcelocation, (double)armor, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)slot));
        }
        return modifiers;
    }

    public boolean isEnchantable(@NotNull ItemStack stack) {
        if (!stack.has(DataComponents.ENCHANTMENTS)) {
            stack.set(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        }
        return true;
    }

    public int getEnchantmentValue(ItemStack stack) {
        Item transformed = DragonArmorHelper.transform((Item)((ItemDragonArmor)this));
        return transformed.getEnchantmentValue(stack.transmuteCopy((ItemLike)transformed));
    }

    @NotNull
    public EquipmentSlot getEquipmentSlot() {
        return switch (this.dragonSlot) {
            default -> throw new MatchException(null, null);
            case DragonArmorPart.HEAD -> EquipmentSlot.HEAD;
            case DragonArmorPart.NECK -> EquipmentSlot.CHEST;
            case DragonArmorPart.BODY -> EquipmentSlot.LEGS;
            case DragonArmorPart.TAIL -> EquipmentSlot.FEET;
        };
    }
}

