/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.dsiafi.mixin;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.entity.ai.DragonAITarget;
import com.iafenvoy.iceandfire.entity.ai.DragonAITargetNonTamed;
import com.iafenvoy.iceandfire.entity.util.dragon.DragonUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Pseudo
@Mixin(value={EntityDragonBase.class})
public abstract class EntityDragonBaseMixin
extends TamableAnimal {
    @Shadow
    protected abstract boolean shouldTarget(Entity var1);

    @Shadow
    public abstract int getHunger();

    protected EntityDragonBaseMixin(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"registerGoals"}, at={@At(value="RETURN")})
    private void handleTarget(CallbackInfo ci) {
        EntityDragonBase self = (EntityDragonBase)this;
        this.targetSelector.removeAllGoals(g -> g instanceof DragonAITargetNonTamed);
        this.targetSelector.addGoal(5, (Goal)new DragonAITargetNonTamed(self, LivingEntity.class, false, entity -> {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                return !player.isCreative() && (Boolean)IafCommonConfig.INSTANCE.dragon.neutralToPlayer.getValue() == false && !DragonStateProvider.isDragon((Entity)player);
            }
            if (this.getRandom().nextInt(100) <= this.getHunger()) {
                return false;
            }
            return entity.getType() != this.getType() && DragonUtils.canHostilesTarget((Entity)entity) && DragonUtils.isAlive((LivingEntity)entity) && this.shouldTarget((Entity)entity);
        }));
        this.targetSelector.removeAllGoals(g -> g instanceof DragonAITarget);
        this.targetSelector.addGoal(6, (Goal)new DragonAITarget(self, LivingEntity.class, true, entity -> {
            Player player;
            return !(entity instanceof Player) || !(player = (Player)entity).isCreative() && (entity instanceof Player ? (Boolean)IafCommonConfig.INSTANCE.dragon.neutralToPlayer.getValue() == false : !DragonStateProvider.isDragon((Entity)player)) && DragonUtils.canHostilesTarget((Entity)entity) && entity.getType() != this.getType() && this.shouldTarget((Entity)entity) && DragonUtils.isAlive((LivingEntity)entity);
        }));
    }
}

