/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.neoforge.support.render;

import com.mojang.math.Transformation;
import com.refinedmods.refinedstorage.common.support.direction.BiDirection;
import java.util.ArrayList;
import java.util.List;
import org.joml.Vector3f;

public class TransformationBuilder {
    private final List<Transformation> transforms = new ArrayList<Transformation>();

    private TransformationBuilder() {
    }

    public static TransformationBuilder create() {
        return new TransformationBuilder();
    }

    public TransformationBuilder translate(Vector3f translation) {
        this.transforms.add(new Transformation(translation, null, null, null));
        return this;
    }

    public TransformationBuilder rotate(BiDirection direction) {
        this.transforms.add(new Transformation(null, direction.getQuaternion(), null, null));
        return this;
    }

    public Transformation build() {
        Transformation result = Transformation.identity();
        for (Transformation child : this.transforms) {
            result = result.compose(child);
        }
        return result;
    }
}

