/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.neoforge.storage;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.ExtractableStorage;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.neoforge.storage.CapabilityCache;
import com.refinedmods.refinedstorage.neoforge.storage.ForgeHandlerUtil;
import com.refinedmods.refinedstorage.neoforge.support.resource.VariantUtil;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidHandlerExtractableStorage
implements ExtractableStorage {
    private final CapabilityCache capabilityCache;

    public FluidHandlerExtractableStorage(CapabilityCache capabilityCache) {
        this.capabilityCache = capabilityCache;
    }

    public long getAmount(ResourceKey resource) {
        if (!(resource instanceof FluidResource)) {
            return 0L;
        }
        FluidResource fluidResource = (FluidResource)resource;
        return this.capabilityCache.getFluidHandler().map(fluidHandler -> ForgeHandlerUtil.getCurrentAmount(fluidHandler, fluidResource)).orElse(0L);
    }

    @Override
    public long extract(ResourceKey resource, long amount, Action action, Actor actor) {
        if (!(resource instanceof FluidResource)) {
            return 0L;
        }
        FluidResource fluidResource = (FluidResource)resource;
        return this.capabilityCache.getFluidHandler().map(fluidHandler -> {
            FluidStack stack = VariantUtil.toFluidStack(fluidResource, amount);
            return fluidHandler.drain(stack, VariantUtil.toFluidAction(action)).getAmount();
        }).orElse(0L);
    }
}

