/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.neoforge.networking;

import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.refinedmods.refinedstorage.neoforge.networking.CableBakedModel;
import com.refinedmods.refinedstorage.neoforge.support.render.RotationTranslationModelBaker;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;

public class CableUnbakedGeometry
implements IUnbakedGeometry<CableUnbakedGeometry> {
    private final ResourceLocation coreModel;
    private final ResourceLocation extensionModel;

    CableUnbakedGeometry(DyeColor color) {
        this.coreModel = IdentifierUtil.createIdentifier("block/cable/core/" + color.getName());
        this.extensionModel = IdentifierUtil.createIdentifier("block/cable/extension/" + color.getName());
    }

    public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext context) {
        modelGetter.apply(this.coreModel).resolveParents(modelGetter);
        modelGetter.apply(this.extensionModel).resolveParents(modelGetter);
    }

    public BakedModel bake(IGeometryBakingContext ctx, ModelBaker modelBaker, Function<Material, TextureAtlasSprite> function, ModelState modelState, ItemOverrides itemOverrides) {
        return new CableBakedModel(Objects.requireNonNull(modelBaker.bake(this.coreModel, modelState, function)), new RotationTranslationModelBaker(modelState, modelBaker, function, this.extensionModel));
    }
}

