/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.util;

import com.refinedmods.refinedstorage.api.autocrafting.preview.Preview;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.autocrafting.TaskCompletedToast;
import com.refinedmods.refinedstorage.common.autocrafting.preview.AutocraftingPreviewContainerMenu;
import com.refinedmods.refinedstorage.common.autocrafting.preview.AutocraftingPreviewScreen;
import com.refinedmods.refinedstorage.common.autocrafting.preview.AutocraftingRequest;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.Level;

public final class ClientPlatformUtil {
    private static final SystemToast.SystemToastId NO_PERMISSION_TOAST_ID = new SystemToast.SystemToastId();
    private static final MutableComponent NO_PERMISSION = IdentifierUtil.createTranslation("misc", "no_permission");

    private ClientPlatformUtil() {
    }

    @Nullable
    public static Level getClientLevel() {
        return Minecraft.getInstance().level;
    }

    public static void addNoPermissionToast(Component message) {
        SystemToast.add((ToastComponent)Minecraft.getInstance().getToasts(), (SystemToast.SystemToastId)NO_PERMISSION_TOAST_ID, (Component)NO_PERMISSION, (Component)message);
    }

    public static void autocraftingPreviewResponseReceived(UUID id, Preview preview) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof AutocraftingPreviewScreen) {
            AutocraftingPreviewScreen screen2 = (AutocraftingPreviewScreen)screen;
            ((AutocraftingPreviewContainerMenu)screen2.getMenu()).previewResponseReceived(id, preview);
        }
    }

    public static void autocraftingResponseReceived(UUID id, boolean success) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof AutocraftingPreviewScreen) {
            AutocraftingPreviewScreen screen2 = (AutocraftingPreviewScreen)screen;
            ((AutocraftingPreviewContainerMenu)screen2.getMenu()).responseReceived(id, success);
        }
    }

    public static void autocraftingPreviewMaxAmountResponseReceived(long maxAmount) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof AutocraftingPreviewScreen) {
            AutocraftingPreviewScreen screen2 = (AutocraftingPreviewScreen)screen;
            ((AutocraftingPreviewContainerMenu)screen2.getMenu()).maxAmountResponseReceived(maxAmount);
        }
    }

    public static void openCraftingPreview(List<ResourceAmount> requests, @Nullable Object parentScreen) {
        Screen castedParentScreen;
        Minecraft minecraft = Minecraft.getInstance();
        if (!(parentScreen instanceof Screen) && minecraft.screen == null || minecraft.player == null) {
            return;
        }
        Inventory inventory = minecraft.player.getInventory();
        minecraft.setScreen((Screen)new AutocraftingPreviewScreen(parentScreen instanceof Screen ? (castedParentScreen = (Screen)parentScreen) : minecraft.screen, inventory, requests.stream().map(AutocraftingRequest::of).toList()));
    }

    public static void autocraftingTaskCompleted(PlatformResourceKey resource, long amount) {
        Minecraft.getInstance().getToasts().addToast((Toast)new TaskCompletedToast(resource, amount));
    }
}

