/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.widget;

import com.refinedmods.refinedstorage.common.support.RedstoneMode;
import com.refinedmods.refinedstorage.common.support.containermenu.ClientProperty;
import com.refinedmods.refinedstorage.common.support.widget.AbstractSideButtonWidget;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class RedstoneModeSideButtonWidget
extends AbstractSideButtonWidget {
    private static final MutableComponent TITLE = IdentifierUtil.createTranslation("gui", "redstone_mode");
    private static final List<MutableComponent> SUBTEXT_IGNORE = List.of(IdentifierUtil.createTranslation("gui", "redstone_mode.ignore").withStyle(ChatFormatting.GRAY));
    private static final List<MutableComponent> SUBTEXT_HIGH = List.of(IdentifierUtil.createTranslation("gui", "redstone_mode.high").withStyle(ChatFormatting.GRAY));
    private static final List<MutableComponent> SUBTEXT_LOW = List.of(IdentifierUtil.createTranslation("gui", "redstone_mode.low").withStyle(ChatFormatting.GRAY));
    private static final Component HELP_IGNORE = IdentifierUtil.createTranslation("gui", "redstone_mode.ignore.help");
    private static final Component HELP_HIGH = IdentifierUtil.createTranslation("gui", "redstone_mode.high.help");
    private static final Component HELP_LOW = IdentifierUtil.createTranslation("gui", "redstone_mode.low.help");
    private static final ResourceLocation IGNORE = IdentifierUtil.createIdentifier("widget/side_button/redstone_mode/ignore");
    private static final ResourceLocation HIGH = IdentifierUtil.createIdentifier("widget/side_button/redstone_mode/high");
    private static final ResourceLocation LOW = IdentifierUtil.createIdentifier("widget/side_button/redstone_mode/low");
    private final ClientProperty<RedstoneMode> property;
    private final Component helpIgnore;
    private final Component helpHigh;
    private final Component helpLow;

    public RedstoneModeSideButtonWidget(ClientProperty<RedstoneMode> property) {
        this(property, null);
    }

    public RedstoneModeSideButtonWidget(ClientProperty<RedstoneMode> property, @Nullable Component extraHelpText) {
        super(RedstoneModeSideButtonWidget.createPressAction(property));
        this.property = property;
        this.helpIgnore = this.getHelpText(HELP_IGNORE, extraHelpText);
        this.helpHigh = this.getHelpText(HELP_HIGH, extraHelpText);
        this.helpLow = this.getHelpText(HELP_LOW, extraHelpText);
    }

    private static Button.OnPress createPressAction(ClientProperty<RedstoneMode> property) {
        return btn -> property.setValue(((RedstoneMode)((Object)((Object)property.getValue()))).toggle());
    }

    @Override
    protected ResourceLocation getSprite() {
        return switch (this.property.getValue()) {
            default -> throw new MatchException(null, null);
            case RedstoneMode.IGNORE -> IGNORE;
            case RedstoneMode.HIGH -> HIGH;
            case RedstoneMode.LOW -> LOW;
        };
    }

    @Override
    protected MutableComponent getTitle() {
        return TITLE;
    }

    @Override
    protected List<MutableComponent> getSubText() {
        return switch (this.property.getValue()) {
            default -> throw new MatchException(null, null);
            case RedstoneMode.IGNORE -> SUBTEXT_IGNORE;
            case RedstoneMode.HIGH -> SUBTEXT_HIGH;
            case RedstoneMode.LOW -> SUBTEXT_LOW;
        };
    }

    @Override
    protected Component getHelpText() {
        return switch (this.property.getValue()) {
            default -> throw new MatchException(null, null);
            case RedstoneMode.IGNORE -> this.helpIgnore;
            case RedstoneMode.HIGH -> this.helpHigh;
            case RedstoneMode.LOW -> this.helpLow;
        };
    }

    private Component getHelpText(Component text, @Nullable Component extraText) {
        if (extraText == null) {
            return text;
        }
        return text.copy().append(" ").append(extraText);
    }
}

