/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.widget;

import com.refinedmods.refinedstorage.common.support.containermenu.ClientProperty;
import com.refinedmods.refinedstorage.common.support.widget.AbstractSideButtonWidget;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class FuzzyModeSideButtonWidget
extends AbstractSideButtonWidget {
    private static final MutableComponent TITLE = IdentifierUtil.createTranslation("gui", "fuzzy_mode");
    private static final List<MutableComponent> SUBTEXT_ON = List.of(IdentifierUtil.createTranslation("gui", "fuzzy_mode.on").withStyle(ChatFormatting.GRAY));
    private static final List<MutableComponent> SUBTEXT_OFF = List.of(IdentifierUtil.createTranslation("gui", "fuzzy_mode.off").withStyle(ChatFormatting.GRAY));
    private static final ResourceLocation ON = IdentifierUtil.createIdentifier("widget/side_button/fuzzy_mode/on");
    private static final ResourceLocation OFF = IdentifierUtil.createIdentifier("widget/side_button/fuzzy_mode/off");
    private final ClientProperty<Boolean> property;
    private final Supplier<Type> typeSupplier;

    public FuzzyModeSideButtonWidget(ClientProperty<Boolean> property, Supplier<Type> typeSupplier) {
        super(FuzzyModeSideButtonWidget.createPressAction(property));
        this.property = property;
        this.typeSupplier = typeSupplier;
    }

    private static Button.OnPress createPressAction(ClientProperty<Boolean> property) {
        return btn -> property.setValue((Boolean)property.getValue() == false);
    }

    @Override
    protected ResourceLocation getSprite() {
        return Boolean.TRUE.equals(this.property.getValue()) ? ON : OFF;
    }

    @Override
    protected MutableComponent getTitle() {
        return TITLE;
    }

    @Override
    protected List<MutableComponent> getSubText() {
        return Boolean.TRUE.equals(this.property.getValue()) ? SUBTEXT_ON : SUBTEXT_OFF;
    }

    @Override
    protected Component getHelpText() {
        Type type = this.typeSupplier.get();
        return Boolean.TRUE.equals(this.property.getValue()) ? type.helpOnText : type.helpOffText;
    }

    public static enum Type {
        STORAGE,
        GENERIC,
        EXTRACTING_STORAGE_NETWORK,
        EXTRACTING_SOURCE;

        private final MutableComponent helpOnText = IdentifierUtil.createTranslation("gui", "fuzzy_mode.on." + this.getHelpTranslationKey());
        private final MutableComponent helpOffText = IdentifierUtil.createTranslation("gui", "fuzzy_mode.off." + this.getHelpTranslationKey());

        private String getHelpTranslationKey() {
            return this.name().toLowerCase() + "_help";
        }
    }
}

