/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.tooltip;

import com.refinedmods.refinedstorage.common.support.tooltip.SmallText;
import com.refinedmods.refinedstorage.common.support.tooltip.SmallTextClientTooltipComponent;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.joml.Matrix4f;

public class HelpClientTooltipComponent
implements ClientTooltipComponent {
    private static final ResourceLocation SPRITE = IdentifierUtil.createIdentifier("help");
    private static final ClientTooltipComponent PRESS_SHIFT_FOR_HELP = new SmallTextClientTooltipComponent((Component)IdentifierUtil.createTranslationAsHeading("misc", "press_shift_for_help"));
    private static final Style STYLE = Style.EMPTY.withColor(-15556903);
    private static final int MAX_CHARS = 200;
    private static final int HELP_ICON_SIZE = 20;
    private static final int HELP_ICON_MARGIN = 4;
    private final List<FormattedCharSequence> lines;
    private final int paddingTop;

    private HelpClientTooltipComponent(Component text, int paddingTop) {
        this.lines = Language.getInstance().getVisualOrder(Minecraft.getInstance().font.getSplitter().splitLines((FormattedText)text, 200, STYLE));
        this.paddingTop = paddingTop;
    }

    public int getHeight() {
        return Math.max(20 + this.paddingTop, 9 * this.lines.size() + this.paddingTop);
    }

    public int getWidth(Font font) {
        int width = 0;
        for (FormattedCharSequence line : this.lines) {
            float scale = SmallText.correctScale(0.7f);
            int lineWidth = 24 + (int)((float)font.width(line) * scale);
            if (lineWidth <= width) continue;
            width = lineWidth;
        }
        return width;
    }

    public void renderText(Font font, int x, int y, Matrix4f pose, MultiBufferSource.BufferSource buffer) {
        int xx = x + 20 + 4;
        int yy = y + this.paddingTop;
        for (FormattedCharSequence line : this.lines) {
            SmallText.render(font, line, xx, yy, pose, buffer, 0.7f);
            yy += 9;
        }
    }

    public void renderImage(Font font, int x, int y, GuiGraphics graphics) {
        graphics.blitSprite(SPRITE, x, y + this.paddingTop / 2, 20, 20);
    }

    public static ClientTooltipComponent create(Component text) {
        if (Screen.hasShiftDown()) {
            return new HelpClientTooltipComponent(text, SmallText.isSmall() ? 4 : 0);
        }
        return PRESS_SHIFT_FOR_HELP;
    }

    public static ClientTooltipComponent createAlwaysDisplayed(Component text) {
        return new HelpClientTooltipComponent(text, 0);
    }
}

