/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.packet.s2c;

import com.refinedmods.refinedstorage.common.support.exportingindicator.ExportingIndicator;
import com.refinedmods.refinedstorage.common.support.exportingindicator.ExportingIndicatorListener;
import com.refinedmods.refinedstorage.common.support.packet.PacketContext;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.refinedmods.refinedstorage.common.util.PlatformUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.AbstractContainerMenu;

public record ExportingIndicatorUpdatePacket(List<UpdatedIndicator> updatedIndicators) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ExportingIndicatorUpdatePacket> PACKET_TYPE = new CustomPacketPayload.Type(IdentifierUtil.createIdentifier("exporting_indicator_update"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ExportingIndicatorUpdatePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.collection(ArrayList::new, UpdatedIndicator.CODEC), ExportingIndicatorUpdatePacket::updatedIndicators, ExportingIndicatorUpdatePacket::new);

    public static void handle(ExportingIndicatorUpdatePacket packet, PacketContext ctx) {
        AbstractContainerMenu menu = ctx.getPlayer().containerMenu;
        if (menu instanceof ExportingIndicatorListener) {
            ExportingIndicatorListener listener = (ExportingIndicatorListener)menu;
            packet.updatedIndicators.forEach(updatedIndicator -> listener.indicatorChanged(updatedIndicator.idx(), updatedIndicator.indicator()));
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PACKET_TYPE;
    }

    public record UpdatedIndicator(int idx, ExportingIndicator indicator) {
        private static final StreamCodec<RegistryFriendlyByteBuf, UpdatedIndicator> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, UpdatedIndicator::idx, (StreamCodec)PlatformUtil.enumStreamCodec((Enum[])ExportingIndicator.values()), UpdatedIndicator::indicator, UpdatedIndicator::new);
    }
}

