/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.direction;

import com.refinedmods.refinedstorage.common.support.direction.BiDirection;
import com.refinedmods.refinedstorage.common.support.direction.DirectionType;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.EnumProperty;

public class BiDirectionType
implements DirectionType<BiDirection> {
    public static final DirectionType<BiDirection> INSTANCE = new BiDirectionType();
    private static final EnumProperty<BiDirection> PROPERTY = EnumProperty.create((String)"direction", BiDirection.class);

    private BiDirectionType() {
    }

    @Override
    public EnumProperty<BiDirection> getProperty() {
        return PROPERTY;
    }

    @Override
    public BiDirection getDefault() {
        return BiDirection.NORTH;
    }

    @Override
    public Direction extractDirection(BiDirection direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case BiDirection.NORTH -> Direction.NORTH;
            case BiDirection.EAST -> Direction.EAST;
            case BiDirection.SOUTH -> Direction.SOUTH;
            case BiDirection.WEST -> Direction.WEST;
            case BiDirection.UP_NORTH, BiDirection.UP_EAST, BiDirection.UP_SOUTH, BiDirection.UP_WEST -> Direction.UP;
            case BiDirection.DOWN_NORTH, BiDirection.DOWN_EAST, BiDirection.DOWN_SOUTH, BiDirection.DOWN_WEST -> Direction.DOWN;
        };
    }

    @Override
    public BiDirection getDirection(Direction clickedFace, Direction playerFacing, float playerPitch) {
        if (playerPitch > 65.0f) {
            return BiDirection.forUp(playerFacing);
        }
        if (playerPitch < -65.0f) {
            return BiDirection.forDown(playerFacing.getOpposite());
        }
        return BiDirection.forHorizontal(playerFacing.getOpposite());
    }

    @Override
    public BiDirection rotate(BiDirection direction) {
        return direction.rotate();
    }
}

