/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.direction;

import java.util.Locale;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public enum BiDirection implements StringRepresentable
{
    NORTH(new Vector3f(0.0f, 0.0f, 0.0f), Direction.NORTH),
    EAST(new Vector3f(0.0f, -90.0f, 0.0f), Direction.EAST),
    SOUTH(new Vector3f(0.0f, 180.0f, 0.0f), Direction.SOUTH),
    WEST(new Vector3f(0.0f, 90.0f, 0.0f), Direction.WEST),
    UP_NORTH(new Vector3f(90.0f, 0.0f, 180.0f), Direction.UP),
    UP_EAST(new Vector3f(90.0f, 0.0f, -90.0f), Direction.UP),
    UP_SOUTH(new Vector3f(90.0f, 0.0f, 0.0f), Direction.UP),
    UP_WEST(new Vector3f(90.0f, 0.0f, 90.0f), Direction.UP),
    DOWN_NORTH(new Vector3f(-90.0f, 0.0f, 0.0f), Direction.DOWN),
    DOWN_EAST(new Vector3f(-90.0f, 0.0f, -90.0f), Direction.DOWN),
    DOWN_SOUTH(new Vector3f(-90.0f, 0.0f, 180.0f), Direction.DOWN),
    DOWN_WEST(new Vector3f(-90.0f, 0.0f, 90.0f), Direction.DOWN);

    private final Vector3f vec;
    private final String name;
    private final Quaternionf quaternion;
    private final Direction direction;

    private BiDirection(Vector3f vec, Direction direction) {
        this.vec = vec;
        this.name = this.name().toLowerCase(Locale.ROOT);
        this.quaternion = new Quaternionf().rotateXYZ(vec.x() * ((float)Math.PI / 180), vec.y() * ((float)Math.PI / 180), vec.z() * ((float)Math.PI / 180));
        this.direction = direction;
    }

    public static BiDirection forDirection(Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> NORTH;
            case Direction.EAST -> EAST;
            case Direction.SOUTH -> SOUTH;
            case Direction.WEST -> WEST;
            case Direction.UP -> UP_NORTH;
            case Direction.DOWN -> DOWN_NORTH;
        };
    }

    public static BiDirection forHorizontal(Direction horizontalDirection) {
        return switch (horizontalDirection) {
            case Direction.NORTH -> NORTH;
            case Direction.SOUTH -> SOUTH;
            case Direction.WEST -> WEST;
            case Direction.EAST -> EAST;
            default -> throw new IllegalArgumentException(String.valueOf(horizontalDirection));
        };
    }

    public static BiDirection forUp(Direction verticalDirection) {
        return switch (verticalDirection) {
            case Direction.NORTH -> UP_NORTH;
            case Direction.SOUTH -> UP_SOUTH;
            case Direction.WEST -> UP_WEST;
            case Direction.EAST -> UP_EAST;
            default -> throw new IllegalArgumentException(String.valueOf(verticalDirection));
        };
    }

    public static BiDirection forDown(Direction verticalDirection) {
        return switch (verticalDirection) {
            case Direction.NORTH -> DOWN_NORTH;
            case Direction.SOUTH -> DOWN_SOUTH;
            case Direction.WEST -> DOWN_WEST;
            case Direction.EAST -> DOWN_EAST;
            default -> throw new IllegalArgumentException(String.valueOf(verticalDirection));
        };
    }

    public BiDirection rotate() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> EAST;
            case 1 -> SOUTH;
            case 2 -> WEST;
            case 3 -> UP_NORTH;
            case 4 -> UP_EAST;
            case 5 -> UP_SOUTH;
            case 6 -> UP_WEST;
            case 7 -> DOWN_NORTH;
            case 8 -> DOWN_EAST;
            case 9 -> DOWN_SOUTH;
            case 10 -> DOWN_WEST;
            case 11 -> NORTH;
        };
    }

    public Vector3f getVec() {
        return this.vec;
    }

    public String getSerializedName() {
        return this.name;
    }

    public Quaternionf getQuaternion() {
        return this.quaternion;
    }

    public Direction asDirection() {
        return this.direction;
    }
}

