/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.amount;

import com.refinedmods.refinedstorage.common.support.amount.AmountOperations;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;

public class IntegerAmountOperations
implements AmountOperations<Integer> {
    public static final AmountOperations<Integer> INSTANCE = new IntegerAmountOperations();

    private IntegerAmountOperations() {
    }

    @Override
    public String format(Integer value) {
        return String.valueOf(value);
    }

    @Override
    public Optional<Integer> parse(String value) {
        try {
            return Optional.of(Integer.parseInt(value, 10));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    @Override
    public Optional<Integer> validate(Integer amount, @Nullable Integer minAmount, @Nullable Integer maxAmount) {
        boolean minBoundOk = minAmount == null || amount >= minAmount;
        boolean maxBoundOk = maxAmount == null || amount <= maxAmount;
        return minBoundOk && maxBoundOk ? Optional.of(amount) : Optional.empty();
    }

    @Override
    public Integer changeAmount(@Nullable Integer current, int delta, @Nullable Integer minAmount, @Nullable Integer maxAmount) {
        if (current == null) {
            return Mth.clamp((int)delta, (int)Objects.requireNonNullElse(minAmount, Integer.MIN_VALUE), (int)Objects.requireNonNullElse(maxAmount, Integer.MAX_VALUE));
        }
        return Mth.clamp((int)(current + delta), (int)Objects.requireNonNullElse(minAmount, Integer.MIN_VALUE), (int)Objects.requireNonNullElse(maxAmount, Integer.MAX_VALUE));
    }
}

