/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage.storageblock;

import com.refinedmods.refinedstorage.common.api.storage.StorageBlockData;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceFactory;
import com.refinedmods.refinedstorage.common.storage.AbstractStorageContainerMenu;
import com.refinedmods.refinedstorage.common.storage.StorageAccessor;
import com.refinedmods.refinedstorage.common.storage.StorageConfigurationContainer;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlot;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlotType;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;

public class StorageBlockContainerMenu
extends AbstractStorageContainerMenu
implements StorageAccessor {
    private static final int FILTER_SLOT_X = 8;
    private static final int FILTER_SLOT_Y = 20;
    private long stored;
    private long capacity;

    public StorageBlockContainerMenu(MenuType<?> type, int syncId, Player player, StorageBlockData storageBlockData, ResourceFactory resourceFactory) {
        super(type, syncId);
        this.stored = storageBlockData.stored();
        this.capacity = storageBlockData.capacity();
        this.addSlots(player, ResourceContainerImpl.createForFilter(resourceFactory, storageBlockData.resources()));
    }

    public StorageBlockContainerMenu(MenuType<?> type, int syncId, Player player, ResourceContainer resourceContainer, StorageConfigurationContainer configContainer) {
        super(type, syncId, player, configContainer);
        this.addSlots(player, resourceContainer);
    }

    private void addSlots(Player player, ResourceContainer resourceContainer) {
        for (int i = 0; i < resourceContainer.size(); ++i) {
            this.addSlot(this.createFilterSlot(resourceContainer, i));
        }
        this.addPlayerInventory(player.getInventory(), 8, 141);
        this.transferManager.addFilterTransfer((Container)player.getInventory());
    }

    private Slot createFilterSlot(ResourceContainer resourceContainer, int i) {
        int x = 8 + 18 * i;
        return new ResourceSlot(resourceContainer, i, (Component)IdentifierUtil.createTranslation("gui", "storage.filter_help"), x, 20, ResourceSlotType.FILTER);
    }

    @Override
    public double getProgress() {
        if (this.capacity == 0L) {
            return 0.0;
        }
        return (double)this.getStored() / (double)this.getCapacity();
    }

    @Override
    public boolean hasCapacity() {
        return this.capacity > 0L;
    }

    @Override
    public long getCapacity() {
        return this.capacity;
    }

    @Override
    public long getStored() {
        return this.stored;
    }
}

