/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.networking;

import com.google.common.util.concurrent.RateLimiter;
import com.refinedmods.refinedstorage.common.content.Menus;
import com.refinedmods.refinedstorage.common.networking.WirelessTransmitterBlockEntity;
import com.refinedmods.refinedstorage.common.networking.WirelessTransmitterData;
import com.refinedmods.refinedstorage.common.support.AbstractBaseContainerMenu;
import com.refinedmods.refinedstorage.common.support.RedstoneMode;
import com.refinedmods.refinedstorage.common.support.containermenu.ClientProperty;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyTypes;
import com.refinedmods.refinedstorage.common.support.containermenu.ServerProperty;
import com.refinedmods.refinedstorage.common.support.packet.s2c.S2CPackets;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeDestinations;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeSlot;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;

public class WirelessTransmitterContainerMenu
extends AbstractBaseContainerMenu {
    private final RateLimiter rangeRateLimiter = RateLimiter.create((double)4.0);
    @Nullable
    private final WirelessTransmitterBlockEntity wirelessTransmitter;
    private final Player player;
    private int range;
    private boolean active;

    public WirelessTransmitterContainerMenu(int syncId, Inventory playerInventory, WirelessTransmitterData data) {
        super(Menus.INSTANCE.getWirelessTransmitter(), syncId);
        this.addSlots(playerInventory, new UpgradeContainer(UpgradeDestinations.WIRELESS_TRANSMITTER));
        this.registerProperty(new ClientProperty<RedstoneMode>(PropertyTypes.REDSTONE_MODE, RedstoneMode.IGNORE));
        this.range = data.range();
        this.active = data.active();
        this.wirelessTransmitter = null;
        this.player = playerInventory.player;
    }

    WirelessTransmitterContainerMenu(int syncId, Inventory playerInventory, WirelessTransmitterBlockEntity wirelessTransmitter, UpgradeContainer upgradeContainer) {
        super(Menus.INSTANCE.getWirelessTransmitter(), syncId);
        this.addSlots(playerInventory, upgradeContainer);
        this.registerProperty(new ServerProperty<RedstoneMode>(PropertyTypes.REDSTONE_MODE, wirelessTransmitter::getRedstoneMode, wirelessTransmitter::setRedstoneMode));
        this.range = wirelessTransmitter.getRange();
        this.active = wirelessTransmitter.isActive();
        this.wirelessTransmitter = wirelessTransmitter;
        this.player = playerInventory.player;
    }

    private void addSlots(Inventory playerInventory, UpgradeContainer upgradeContainer) {
        this.addPlayerInventory(playerInventory, 8, 55);
        for (int i = 0; i < upgradeContainer.getContainerSize(); ++i) {
            this.addSlot(new UpgradeSlot(upgradeContainer, i, 187, 6 + i * 18));
        }
        this.transferManager.addBiTransfer((Container)playerInventory, (Container)upgradeContainer);
    }

    public void broadcastChanges() {
        boolean changed;
        super.broadcastChanges();
        if (this.wirelessTransmitter == null) {
            return;
        }
        int newRange = this.wirelessTransmitter.getRange();
        boolean newActive = this.wirelessTransmitter.isActive();
        boolean bl = changed = this.range != newRange || this.active != newActive;
        if (changed && this.rangeRateLimiter.tryAcquire()) {
            this.range = newRange;
            this.active = newActive;
            S2CPackets.sendWirelessTransmitterData((ServerPlayer)this.player, this.range, this.active);
        }
    }

    int getRange() {
        return this.range;
    }

    boolean isActive() {
        return this.active;
    }

    public void setRange(int range) {
        this.range = range;
    }

    public void setActive(boolean active) {
        this.active = active;
    }
}

