/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.networking;

import com.refinedmods.refinedstorage.api.network.impl.node.relay.RelayComponentType;
import com.refinedmods.refinedstorage.api.network.impl.node.relay.RelayInputNetworkNode;
import com.refinedmods.refinedstorage.api.network.impl.node.relay.RelayOutputNetworkNode;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.filter.FilterMode;
import com.refinedmods.refinedstorage.api.storage.AccessMode;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.network.InWorldNetworkNodeContainer;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.networking.RelayContainerMenu;
import com.refinedmods.refinedstorage.common.networking.RelayInputConnectionStrategy;
import com.refinedmods.refinedstorage.common.networking.RelayOutputConnectionStrategy;
import com.refinedmods.refinedstorage.common.storage.AccessModeSettings;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.FilterModeSettings;
import com.refinedmods.refinedstorage.common.support.FilterWithFuzzyMode;
import com.refinedmods.refinedstorage.common.support.RedstoneMode;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.network.AbstractBaseNetworkNodeContainerBlockEntity;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.state.BlockState;

public class RelayBlockEntity
extends AbstractBaseNetworkNodeContainerBlockEntity<RelayInputNetworkNode>
implements NetworkNodeExtendedMenuProvider<ResourceContainerData> {
    private static final String TAG_PASS_THROUGH = "passthrough";
    private static final String TAG_PASS_ENERGY = "passenergy";
    private static final String TAG_PASS_SECURITY = "passsecurity";
    private static final String TAG_PASS_STORAGE = "passstorage";
    private static final String TAG_PASS_AUTOCRAFTING = "passautocrafting";
    private static final String TAG_FILTER_MODE = "fim";
    private static final String TAG_ACCESS_MODE = "am";
    private static final String TAG_INSERT_PRIORITY = "pri";
    private static final String TAG_EXTRACT_PRIORITY = "epri";
    private final FilterWithFuzzyMode filter;
    private final RelayOutputNetworkNode outputNode;
    private boolean passThrough = true;
    private FilterMode filterMode = FilterMode.BLOCK;
    private AccessMode accessMode = AccessMode.INSERT_EXTRACT;
    private int insertPriority = 0;
    private int extractPriority = 0;

    public RelayBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntities.INSTANCE.getRelay(), pos, state, new RelayInputNetworkNode(Platform.INSTANCE.getConfig().getRelay().getInputNetworkEnergyUsage()));
        this.outputNode = new RelayOutputNetworkNode(Platform.INSTANCE.getConfig().getRelay().getOutputNetworkEnergyUsage());
        ((RelayInputNetworkNode)this.mainNetworkNode).setOutputNode(this.outputNode);
        this.filter = FilterWithFuzzyMode.createAndListenForUniqueFilters(ResourceContainerImpl.createForFilter(), () -> ((RelayBlockEntity)this).setChanged(), this::setFilters);
        ((RelayInputNetworkNode)this.mainNetworkNode).setFilterNormalizer(this.filter.createNormalizer());
        this.containers.addContainer(RefinedStorageApi.INSTANCE.createNetworkNodeContainer(this, this.outputNode).name("output").connectionStrategy(new RelayOutputConnectionStrategy(this)).build());
        this.setRedstoneMode(RedstoneMode.LOW);
    }

    @Override
    public void doWork() {
        super.doWork();
        this.ticker.tick(this.outputNode);
    }

    boolean isFuzzyMode() {
        return this.filter.isFuzzyMode();
    }

    void setFuzzyMode(boolean fuzzyMode) {
        boolean wasActive = ((RelayInputNetworkNode)this.mainNetworkNode).isActive();
        ((RelayInputNetworkNode)this.mainNetworkNode).setActive(false);
        this.filter.setFuzzyMode(fuzzyMode);
        ((RelayInputNetworkNode)this.mainNetworkNode).setActive(wasActive);
    }

    void setFilters(Set<ResourceKey> filters) {
        ((RelayInputNetworkNode)this.mainNetworkNode).setFilters(filters);
        this.setChanged();
    }

    int getInsertPriority() {
        return this.insertPriority;
    }

    void setInsertPriority(int insertPriority) {
        this.insertPriority = insertPriority;
        ((RelayInputNetworkNode)this.mainNetworkNode).setInsertPriority(insertPriority);
        this.setChanged();
    }

    int getExtractPriority() {
        return this.extractPriority;
    }

    void setExtractPriority(int extractPriority) {
        this.extractPriority = extractPriority;
        ((RelayInputNetworkNode)this.mainNetworkNode).setExtractPriority(extractPriority);
        this.setChanged();
    }

    AccessMode getAccessMode() {
        return this.accessMode;
    }

    void setAccessMode(AccessMode accessMode) {
        this.accessMode = accessMode;
        ((RelayInputNetworkNode)this.mainNetworkNode).setAccessMode(accessMode);
        this.setChanged();
    }

    FilterMode getFilterMode() {
        return this.filterMode;
    }

    void setFilterMode(FilterMode filterMode) {
        this.filterMode = filterMode;
        ((RelayInputNetworkNode)this.mainNetworkNode).setFilterMode(filterMode);
        this.setChanged();
    }

    boolean isPassEnergy() {
        return ((RelayInputNetworkNode)this.mainNetworkNode).hasComponentType(RelayComponentType.ENERGY);
    }

    void setPassEnergy(boolean passEnergy) {
        ((RelayInputNetworkNode)this.mainNetworkNode).updateComponentType(RelayComponentType.ENERGY, passEnergy);
        this.setChanged();
    }

    boolean isPassStorage() {
        return ((RelayInputNetworkNode)this.mainNetworkNode).hasComponentType(RelayComponentType.STORAGE);
    }

    void setPassStorage(boolean passStorage) {
        ((RelayInputNetworkNode)this.mainNetworkNode).updateComponentType(RelayComponentType.STORAGE, passStorage);
        this.setChanged();
    }

    boolean isPassSecurity() {
        return ((RelayInputNetworkNode)this.mainNetworkNode).hasComponentType(RelayComponentType.SECURITY);
    }

    void setPassSecurity(boolean passSecurity) {
        ((RelayInputNetworkNode)this.mainNetworkNode).updateComponentType(RelayComponentType.SECURITY, passSecurity);
        this.setChanged();
    }

    boolean isPassAutocrafting() {
        return ((RelayInputNetworkNode)this.mainNetworkNode).hasComponentType(RelayComponentType.AUTOCRAFTING);
    }

    void setPassAutocrafting(boolean passAutocrafting) {
        ((RelayInputNetworkNode)this.mainNetworkNode).updateComponentType(RelayComponentType.AUTOCRAFTING, passAutocrafting);
        this.setChanged();
    }

    boolean isPassThrough() {
        return this.passThrough;
    }

    void setPassThrough(boolean passThrough) {
        this.passThrough = passThrough;
        ((RelayInputNetworkNode)this.mainNetworkNode).setComponentTypes(Set.of());
        this.setChanged();
        this.containers.update(this.level);
    }

    boolean isActiveInternal() {
        return ((RelayInputNetworkNode)this.mainNetworkNode).isActive();
    }

    Direction getDirectionInternal() {
        return Objects.requireNonNull(AbstractDirectionalBlock.tryExtractDirection(this.getBlockState()));
    }

    @Override
    protected void activenessChanged(boolean newActive) {
        super.activenessChanged(newActive);
        this.outputNode.setActive(newActive);
        this.containers.update(this.level);
    }

    @Override
    protected InWorldNetworkNodeContainer createMainContainer(RelayInputNetworkNode networkNode) {
        return RefinedStorageApi.INSTANCE.createNetworkNodeContainer(this, networkNode).name("input").connectionStrategy(new RelayInputConnectionStrategy(this)).build();
    }

    @Override
    public ResourceContainerData getMenuData() {
        return ResourceContainerData.of(this.filter.getFilterContainer());
    }

    @Override
    public StreamEncoder<RegistryFriendlyByteBuf, ResourceContainerData> getMenuCodec() {
        return ResourceContainerData.STREAM_CODEC;
    }

    public Component getName() {
        return this.overrideName((Component)ContentNames.RELAY);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory inventory, Player player) {
        return new RelayContainerMenu(syncId, player, this, this.filter.getFilterContainer());
    }

    @Override
    public void writeConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.writeConfiguration(tag, provider);
        this.filter.save(tag, provider);
        tag.putInt(TAG_FILTER_MODE, FilterModeSettings.getFilterMode(this.filterMode));
        tag.putBoolean(TAG_PASS_THROUGH, this.passThrough);
        tag.putBoolean(TAG_PASS_ENERGY, ((RelayInputNetworkNode)this.mainNetworkNode).hasComponentType(RelayComponentType.ENERGY));
        tag.putBoolean(TAG_PASS_STORAGE, ((RelayInputNetworkNode)this.mainNetworkNode).hasComponentType(RelayComponentType.STORAGE));
        tag.putBoolean(TAG_PASS_SECURITY, ((RelayInputNetworkNode)this.mainNetworkNode).hasComponentType(RelayComponentType.SECURITY));
        tag.putBoolean(TAG_PASS_AUTOCRAFTING, ((RelayInputNetworkNode)this.mainNetworkNode).hasComponentType(RelayComponentType.AUTOCRAFTING));
        tag.putInt(TAG_ACCESS_MODE, AccessModeSettings.getAccessMode(this.accessMode));
        tag.putInt(TAG_INSERT_PRIORITY, this.insertPriority);
        tag.putInt(TAG_EXTRACT_PRIORITY, this.extractPriority);
    }

    @Override
    public void readConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.readConfiguration(tag, provider);
        this.filter.load(tag, provider);
        if (tag.contains(TAG_FILTER_MODE)) {
            this.filterMode = FilterModeSettings.getFilterMode(tag.getInt(TAG_FILTER_MODE));
        }
        ((RelayInputNetworkNode)this.mainNetworkNode).setFilterMode(this.filterMode);
        if (tag.contains(TAG_PASS_THROUGH)) {
            this.passThrough = tag.getBoolean(TAG_PASS_THROUGH);
        }
        ((RelayInputNetworkNode)this.mainNetworkNode).setComponentTypes(this.getComponentTypes(tag));
        if (tag.contains(TAG_ACCESS_MODE)) {
            this.accessMode = AccessModeSettings.getAccessMode(tag.getInt(TAG_ACCESS_MODE));
        }
        ((RelayInputNetworkNode)this.mainNetworkNode).setAccessMode(this.accessMode);
        if (tag.contains(TAG_INSERT_PRIORITY)) {
            this.insertPriority = tag.getInt(TAG_INSERT_PRIORITY);
        }
        ((RelayInputNetworkNode)this.mainNetworkNode).setInsertPriority(this.insertPriority);
        this.extractPriority = tag.contains(TAG_EXTRACT_PRIORITY) ? tag.getInt(TAG_EXTRACT_PRIORITY) : this.insertPriority;
        ((RelayInputNetworkNode)this.mainNetworkNode).setExtractPriority(this.extractPriority);
    }

    private Set<RelayComponentType<?>> getComponentTypes(CompoundTag tag) {
        HashSet types = new HashSet();
        if (tag.getBoolean(TAG_PASS_ENERGY)) {
            types.add(RelayComponentType.ENERGY);
        }
        if (tag.getBoolean(TAG_PASS_SECURITY)) {
            types.add(RelayComponentType.SECURITY);
        }
        if (tag.getBoolean(TAG_PASS_STORAGE)) {
            types.add(RelayComponentType.STORAGE);
        }
        if (tag.getBoolean(TAG_PASS_AUTOCRAFTING)) {
            types.add(RelayComponentType.AUTOCRAFTING);
        }
        return types;
    }
}

