/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.grid.view;

import com.refinedmods.refinedstorage.api.network.node.grid.GridExtractMode;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.repository.ResourceRepository;
import com.refinedmods.refinedstorage.common.api.grid.GridScrollMode;
import com.refinedmods.refinedstorage.common.api.grid.strategy.GridExtractionStrategy;
import com.refinedmods.refinedstorage.common.api.grid.strategy.GridScrollingStrategy;
import com.refinedmods.refinedstorage.common.api.grid.view.AbstractGridResource;
import com.refinedmods.refinedstorage.common.api.grid.view.GridResource;
import com.refinedmods.refinedstorage.common.api.grid.view.GridResourceAttributeKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceType;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.common.support.resource.ResourceTypes;
import com.refinedmods.refinedstorage.common.support.tooltip.MouseClientTooltipComponent;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemGridResource
extends AbstractGridResource<ItemResource> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ItemGridResource.class);
    private final int id;
    private final ItemStack itemStack;
    private final ItemResource itemResource;

    public ItemGridResource(ItemResource resource, ItemStack itemStack, String name, Map<GridResourceAttributeKey, Set<String>> attributes) {
        super(resource, name, attributes);
        this.id = Item.getId((Item)resource.item());
        this.itemStack = itemStack;
        this.itemResource = resource;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public ItemResource getItemResource() {
        return this.itemResource;
    }

    @Override
    public int getRegistryId() {
        return this.id;
    }

    @Override
    public List<ClientTooltipComponent> getExtractionHints(ItemStack carriedStack, ResourceRepository<GridResource> repository) {
        long amount = this.getAmount(repository);
        long extractableAmount = Math.min(amount, (long)this.itemStack.getMaxStackSize());
        long halfExtractionAmount = extractableAmount == 1L ? 1L : extractableAmount / 2L;
        return List.of(MouseClientTooltipComponent.itemWithDecorations(MouseClientTooltipComponent.Type.LEFT, this.itemStack, extractableAmount == 1L ? null : IdentifierUtil.format(extractableAmount)), MouseClientTooltipComponent.itemWithDecorations(MouseClientTooltipComponent.Type.RIGHT, this.itemStack, halfExtractionAmount == 1L ? null : IdentifierUtil.format(halfExtractionAmount)));
    }

    @Override
    @Nullable
    public ResourceAmount getAutocraftingRequest() {
        return new ResourceAmount(this.itemResource, 1L);
    }

    @Override
    public boolean canExtract(ItemStack carriedStack, ResourceRepository<GridResource> repository) {
        return this.getAmount(repository) > 0L && carriedStack.isEmpty();
    }

    @Override
    public void onExtract(GridExtractMode extractMode, boolean cursor, GridExtractionStrategy extractionStrategy) {
        extractionStrategy.onExtract(this.resource, extractMode, cursor);
    }

    @Override
    public void onScroll(GridScrollMode scrollMode, GridScrollingStrategy scrollingStrategy) {
        scrollingStrategy.onScroll(this.resource, scrollMode, -1);
    }

    @Override
    public void render(GuiGraphics graphics, int x, int y) {
        Font font = Minecraft.getInstance().font;
        try {
            graphics.renderItem(this.itemStack, x, y);
            graphics.renderItemDecorations(font, this.itemStack, x, y, null);
        }
        catch (Throwable t) {
            LOGGER.warn("Failed to render item {}", (Object)this.itemStack, (Object)t);
        }
    }

    @Override
    public String getDisplayedAmount(ResourceRepository<GridResource> repository) {
        return IdentifierUtil.formatWithUnits(this.getAmount(repository));
    }

    @Override
    public String getAmountInTooltip(ResourceRepository<GridResource> repository) {
        return IdentifierUtil.format(this.getAmount(repository));
    }

    @Override
    public boolean belongsToResourceType(ResourceType resourceType) {
        return resourceType == ResourceTypes.ITEM;
    }

    @Override
    public List<Component> getTooltip() {
        Minecraft minecraft = Minecraft.getInstance();
        try {
            return Screen.getTooltipFromItem((Minecraft)minecraft, (ItemStack)this.itemStack);
        }
        catch (Throwable t) {
            LOGGER.warn("Failed to get tooltip for item {}", (Object)this.itemStack, (Object)t);
            return Collections.emptyList();
        }
    }

    @Override
    public Optional<TooltipComponent> getTooltipImage() {
        return this.itemStack.getTooltipImage();
    }
}

