/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.exporter;

import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeState;
import com.refinedmods.refinedstorage.common.content.Items;
import java.util.function.ToLongFunction;

public class ExporterTransferQuotaProvider
implements ToLongFunction<ResourceKey> {
    private final long baseTransferQuota;
    private final UpgradeState upgradeState;
    private final boolean regulating;
    private final ToLongFunction<ResourceKey> currentAmountProvider;
    private final boolean respectTransferQuotaWhenRegulating;

    public ExporterTransferQuotaProvider(long singleAmount, UpgradeState upgradeState, ToLongFunction<ResourceKey> currentAmountProvider, boolean respectTransferQuotaWhenRegulating) {
        this.baseTransferQuota = upgradeState.has(Items.INSTANCE.getStackUpgrade()) ? singleAmount * 64L : singleAmount;
        this.upgradeState = upgradeState;
        this.regulating = upgradeState.has(Items.INSTANCE.getRegulatorUpgrade());
        this.currentAmountProvider = currentAmountProvider;
        this.respectTransferQuotaWhenRegulating = respectTransferQuotaWhenRegulating;
    }

    @Override
    public long applyAsLong(ResourceKey resource) {
        if (!this.regulating) {
            return this.baseTransferQuota;
        }
        long desiredAmount = this.upgradeState.getRegulatedAmount(resource);
        if (desiredAmount <= 0L) {
            return this.baseTransferQuota;
        }
        long currentAmount = this.currentAmountProvider.applyAsLong(resource);
        long stillNeeded = desiredAmount - currentAmount;
        if (stillNeeded <= 0L) {
            return 0L;
        }
        return this.respectTransferQuotaWhenRegulating ? Math.min(stillNeeded, this.baseTransferQuota) : stillNeeded;
    }
}

