/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.exporter;

import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.content.Menus;
import com.refinedmods.refinedstorage.common.exporter.AbstractExporterBlockEntity;
import com.refinedmods.refinedstorage.common.exporter.ExporterData;
import com.refinedmods.refinedstorage.common.support.RedstoneMode;
import com.refinedmods.refinedstorage.common.support.SchedulingModeType;
import com.refinedmods.refinedstorage.common.support.containermenu.AbstractSimpleFilterContainerMenu;
import com.refinedmods.refinedstorage.common.support.containermenu.ClientProperty;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyTypes;
import com.refinedmods.refinedstorage.common.support.containermenu.ServerProperty;
import com.refinedmods.refinedstorage.common.support.exportingindicator.ExportingIndicator;
import com.refinedmods.refinedstorage.common.support.exportingindicator.ExportingIndicatorListener;
import com.refinedmods.refinedstorage.common.support.exportingindicator.ExportingIndicators;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeDestinations;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;

public class ExporterContainerMenu
extends AbstractSimpleFilterContainerMenu<AbstractExporterBlockEntity>
implements ExportingIndicatorListener {
    private static final MutableComponent FILTER_HELP = IdentifierUtil.createTranslation("gui", "exporter.filter_help");
    private final ExportingIndicators indicators;

    public ExporterContainerMenu(int syncId, Inventory playerInventory, ExporterData data) {
        super(Menus.INSTANCE.getExporter(), syncId, playerInventory.player, data.resourceContainerData(), UpgradeDestinations.EXPORTER, (Component)FILTER_HELP);
        this.indicators = new ExportingIndicators(data.exportingIndicators());
    }

    ExporterContainerMenu(int syncId, Player player, AbstractExporterBlockEntity exporter, ResourceContainer resourceContainer, UpgradeContainer upgradeContainer, ExportingIndicators indicators) {
        super(Menus.INSTANCE.getExporter(), syncId, player, resourceContainer, upgradeContainer, exporter, (Component)FILTER_HELP);
        this.indicators = indicators;
    }

    ExportingIndicator getIndicator(int idx) {
        return this.indicators.get(idx);
    }

    int getIndicators() {
        return this.indicators.size();
    }

    @Override
    public void broadcastChanges() {
        super.broadcastChanges();
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.indicators.detectChanges(serverPlayer);
        }
    }

    @Override
    protected void registerClientProperties() {
        this.registerProperty(new ClientProperty<Boolean>(PropertyTypes.FUZZY_MODE, false));
        this.registerProperty(new ClientProperty<RedstoneMode>(PropertyTypes.REDSTONE_MODE, RedstoneMode.IGNORE));
        this.registerProperty(new ClientProperty<SchedulingModeType>(PropertyTypes.SCHEDULING_MODE, SchedulingModeType.DEFAULT));
    }

    @Override
    protected void registerServerProperties(AbstractExporterBlockEntity blockEntity) {
        this.registerProperty(new ServerProperty<Boolean>(PropertyTypes.FUZZY_MODE, blockEntity::isFuzzyMode, blockEntity::setFuzzyMode));
        this.registerProperty(new ServerProperty<RedstoneMode>(PropertyTypes.REDSTONE_MODE, blockEntity::getRedstoneMode, blockEntity::setRedstoneMode));
        this.registerProperty(new ServerProperty<SchedulingModeType>(PropertyTypes.SCHEDULING_MODE, blockEntity::getSchedulingModeType, blockEntity::setSchedulingModeType));
    }

    @Override
    public void indicatorChanged(int index, ExportingIndicator indicator) {
        this.indicators.set(index, indicator);
    }
}

