/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.content;

import com.refinedmods.refinedstorage.common.api.upgrade.AbstractUpgradeItem;
import com.refinedmods.refinedstorage.common.autocrafting.PatternItem;
import com.refinedmods.refinedstorage.common.autocrafting.monitor.WirelessAutocraftingMonitorItem;
import com.refinedmods.refinedstorage.common.controller.ControllerBlockItem;
import com.refinedmods.refinedstorage.common.controller.CreativeControllerBlockItem;
import com.refinedmods.refinedstorage.common.grid.WirelessGridItem;
import com.refinedmods.refinedstorage.common.misc.ProcessorItem;
import com.refinedmods.refinedstorage.common.security.FallbackSecurityCardItem;
import com.refinedmods.refinedstorage.common.security.SecurityCardItem;
import com.refinedmods.refinedstorage.common.storage.FluidStorageVariant;
import com.refinedmods.refinedstorage.common.storage.ItemStorageVariant;
import com.refinedmods.refinedstorage.common.storage.portablegrid.PortableGridBlockItem;
import com.refinedmods.refinedstorage.common.support.BaseBlockItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.world.item.Item;

public final class Items {
    public static final Items INSTANCE = new Items();
    private final Map<ItemStorageVariant, Supplier<Item>> itemStorageParts = new EnumMap<ItemStorageVariant, Supplier<Item>>(ItemStorageVariant.class);
    private final Map<FluidStorageVariant, Supplier<Item>> fluidStorageParts = new EnumMap<FluidStorageVariant, Supplier<Item>>(FluidStorageVariant.class);
    private final Map<ItemStorageVariant, Supplier<Item>> itemStorageDisks = new EnumMap<ItemStorageVariant, Supplier<Item>>(ItemStorageVariant.class);
    private final Map<FluidStorageVariant, Supplier<Item>> fluidStorageDisks = new EnumMap<FluidStorageVariant, Supplier<Item>>(FluidStorageVariant.class);
    private final List<Supplier<ControllerBlockItem>> allControllers = new ArrayList<Supplier<ControllerBlockItem>>();
    private final List<Supplier<CreativeControllerBlockItem>> allCreativeControllers = new ArrayList<Supplier<CreativeControllerBlockItem>>();
    private final List<Supplier<BaseBlockItem>> allCables = new ArrayList<Supplier<BaseBlockItem>>();
    private final List<Supplier<BaseBlockItem>> allExporters = new ArrayList<Supplier<BaseBlockItem>>();
    private final List<Supplier<BaseBlockItem>> allImporters = new ArrayList<Supplier<BaseBlockItem>>();
    private final List<Supplier<BaseBlockItem>> allExternalStorages = new ArrayList<Supplier<BaseBlockItem>>();
    private final List<Supplier<BaseBlockItem>> allDetectors = new ArrayList<Supplier<BaseBlockItem>>();
    private final List<Supplier<BaseBlockItem>> allDestructors = new ArrayList<Supplier<BaseBlockItem>>();
    private final List<Supplier<BaseBlockItem>> allConstructors = new ArrayList<Supplier<BaseBlockItem>>();
    private final List<Supplier<BaseBlockItem>> allWirelessTransmitters = new ArrayList<Supplier<BaseBlockItem>>();
    private final List<Supplier<BaseBlockItem>> allNetworkReceivers = new ArrayList<Supplier<BaseBlockItem>>();
    private final List<Supplier<BaseBlockItem>> allNetworkTransmitters = new ArrayList<Supplier<BaseBlockItem>>();
    private final List<Supplier<BaseBlockItem>> allSecurityManagers = new ArrayList<Supplier<BaseBlockItem>>();
    private final List<Supplier<BaseBlockItem>> allRelays = new ArrayList<Supplier<BaseBlockItem>>();
    private final List<Supplier<BaseBlockItem>> allDiskInterfaces = new ArrayList<Supplier<BaseBlockItem>>();
    private final List<Supplier<BaseBlockItem>> allAutocrafters = new ArrayList<Supplier<BaseBlockItem>>();
    private final List<Supplier<BaseBlockItem>> allAutocrafterManagers = new ArrayList<Supplier<BaseBlockItem>>();
    private final List<Supplier<BaseBlockItem>> allAutocraftingMonitors = new ArrayList<Supplier<BaseBlockItem>>();
    @Nullable
    private Supplier<Item> quartzEnrichedIron;
    @Nullable
    private Supplier<Item> quartzEnrichedCopper;
    @Nullable
    private Supplier<Item> silicon;
    @Nullable
    private Supplier<Item> processorBinding;
    @Nullable
    private Supplier<Item> wrench;
    private final Map<ProcessorItem.Type, Supplier<Item>> processors = new EnumMap<ProcessorItem.Type, Supplier<Item>>(ProcessorItem.Type.class);
    @Nullable
    private Supplier<Item> constructionCore;
    @Nullable
    private Supplier<Item> destructionCore;
    @Nullable
    private Supplier<Item> storageHousing;
    @Nullable
    private Supplier<Item> upgrade;
    @Nullable
    private Supplier<AbstractUpgradeItem> speedUpgrade;
    @Nullable
    private Supplier<AbstractUpgradeItem> stackUpgrade;
    @Nullable
    private Supplier<AbstractUpgradeItem> fortune1Upgrade;
    @Nullable
    private Supplier<AbstractUpgradeItem> fortune2Upgrade;
    @Nullable
    private Supplier<AbstractUpgradeItem> fortune3Upgrade;
    @Nullable
    private Supplier<AbstractUpgradeItem> silkTouchUpgrade;
    @Nullable
    private Supplier<AbstractUpgradeItem> regulatorUpgrade;
    @Nullable
    private Supplier<AbstractUpgradeItem> rangeUpgrade;
    @Nullable
    private Supplier<AbstractUpgradeItem> creativeRangeUpgrade;
    @Nullable
    private Supplier<AbstractUpgradeItem> autocraftingUpgrade;
    @Nullable
    private Supplier<WirelessGridItem> wirelessGrid;
    @Nullable
    private Supplier<WirelessGridItem> creativeWirelessGrid;
    @Nullable
    private Supplier<Item> configurationCard;
    @Nullable
    private Supplier<Item> networkCard;
    @Nullable
    private Supplier<PortableGridBlockItem> portableGrid;
    @Nullable
    private Supplier<PortableGridBlockItem> creativePortableGrid;
    @Nullable
    private Supplier<SecurityCardItem> securityCard;
    @Nullable
    private Supplier<FallbackSecurityCardItem> fallbackSecurityCard;
    @Nullable
    private Supplier<PatternItem> pattern;
    @Nullable
    private Supplier<WirelessAutocraftingMonitorItem> wirelessAutocraftingMonitor;
    @Nullable
    private Supplier<WirelessAutocraftingMonitorItem> creativeWirelessAutocraftingMonitor;

    private Items() {
    }

    public Item getItemStoragePart(ItemStorageVariant variant) {
        return this.itemStorageParts.get(variant).get();
    }

    public void setItemStoragePart(ItemStorageVariant variant, Supplier<Item> supplier) {
        this.itemStorageParts.put(variant, supplier);
    }

    public Item getItemStorageDisk(ItemStorageVariant variant) {
        return this.itemStorageDisks.get(variant).get();
    }

    public void setItemStorageDisk(ItemStorageVariant variant, Supplier<Item> supplier) {
        this.itemStorageDisks.put(variant, supplier);
    }

    public Item getFluidStoragePart(FluidStorageVariant type) {
        return this.fluidStorageParts.get(type).get();
    }

    public void setFluidStoragePart(FluidStorageVariant variant, Supplier<Item> supplier) {
        this.fluidStorageParts.put(variant, supplier);
    }

    public Item getFluidStorageDisk(FluidStorageVariant variant) {
        return this.fluidStorageDisks.get(variant).get();
    }

    public void setFluidStorageDisk(FluidStorageVariant variant, Supplier<Item> supplier) {
        this.fluidStorageDisks.put(variant, supplier);
    }

    public void setQuartzEnrichedIron(Supplier<Item> supplier) {
        this.quartzEnrichedIron = supplier;
    }

    public Item getQuartzEnrichedIron() {
        return Objects.requireNonNull(this.quartzEnrichedIron).get();
    }

    public void setQuartzEnrichedCopper(Supplier<Item> supplier) {
        this.quartzEnrichedCopper = supplier;
    }

    public Item getQuartzEnrichedCopper() {
        return Objects.requireNonNull(this.quartzEnrichedCopper).get();
    }

    public void setSilicon(Supplier<Item> supplier) {
        this.silicon = supplier;
    }

    public Item getSilicon() {
        return Objects.requireNonNull(this.silicon).get();
    }

    public void setProcessorBinding(Supplier<Item> supplier) {
        this.processorBinding = supplier;
    }

    public Item getProcessorBinding() {
        return Objects.requireNonNull(this.processorBinding).get();
    }

    public void setWrench(Supplier<Item> supplier) {
        this.wrench = supplier;
    }

    public Item getWrench() {
        return Objects.requireNonNull(this.wrench).get();
    }

    public void setProcessor(ProcessorItem.Type type, Supplier<Item> supplier) {
        this.processors.put(type, supplier);
    }

    public Item getProcessor(ProcessorItem.Type type) {
        return Objects.requireNonNull(this.processors.get((Object)type)).get();
    }

    public void setConstructionCore(Supplier<Item> supplier) {
        this.constructionCore = supplier;
    }

    public Item getConstructionCore() {
        return Objects.requireNonNull(this.constructionCore).get();
    }

    public void setDestructionCore(Supplier<Item> supplier) {
        this.destructionCore = supplier;
    }

    public Item getDestructionCore() {
        return Objects.requireNonNull(this.destructionCore).get();
    }

    public void addCreativeController(Supplier<CreativeControllerBlockItem> supplier) {
        this.allCreativeControllers.add(supplier);
    }

    public List<Supplier<CreativeControllerBlockItem>> getCreativeControllers() {
        return Collections.unmodifiableList(this.allCreativeControllers);
    }

    public void addController(Supplier<ControllerBlockItem> supplier) {
        this.allControllers.add(supplier);
    }

    public List<Supplier<ControllerBlockItem>> getControllers() {
        return Collections.unmodifiableList(this.allControllers);
    }

    public void addCable(Supplier<BaseBlockItem> supplier) {
        this.allCables.add(supplier);
    }

    public List<Supplier<BaseBlockItem>> getCables() {
        return Collections.unmodifiableList(this.allCables);
    }

    public void addExporter(Supplier<BaseBlockItem> supplier) {
        this.allExporters.add(supplier);
    }

    public List<Supplier<BaseBlockItem>> getExporters() {
        return Collections.unmodifiableList(this.allExporters);
    }

    public void addImporter(Supplier<BaseBlockItem> supplier) {
        this.allImporters.add(supplier);
    }

    public List<Supplier<BaseBlockItem>> getImporters() {
        return Collections.unmodifiableList(this.allImporters);
    }

    public void addExternalStorage(Supplier<BaseBlockItem> supplier) {
        this.allExternalStorages.add(supplier);
    }

    public List<Supplier<BaseBlockItem>> getExternalStorages() {
        return Collections.unmodifiableList(this.allExternalStorages);
    }

    public void addDetector(Supplier<BaseBlockItem> supplier) {
        this.allDetectors.add(supplier);
    }

    public List<Supplier<BaseBlockItem>> getDetectors() {
        return Collections.unmodifiableList(this.allDetectors);
    }

    public void addDestructor(Supplier<BaseBlockItem> supplier) {
        this.allDestructors.add(supplier);
    }

    public List<Supplier<BaseBlockItem>> getDestructors() {
        return Collections.unmodifiableList(this.allDestructors);
    }

    public void addConstructor(Supplier<BaseBlockItem> supplier) {
        this.allConstructors.add(supplier);
    }

    public List<Supplier<BaseBlockItem>> getConstructors() {
        return Collections.unmodifiableList(this.allConstructors);
    }

    public void addWirelessTransmitter(Supplier<BaseBlockItem> supplier) {
        this.allWirelessTransmitters.add(supplier);
    }

    public List<Supplier<BaseBlockItem>> getWirelessTransmitters() {
        return Collections.unmodifiableList(this.allWirelessTransmitters);
    }

    public Item getStorageHousing() {
        return Objects.requireNonNull(this.storageHousing).get();
    }

    public void setStorageHousing(Supplier<Item> supplier) {
        this.storageHousing = supplier;
    }

    public void setUpgrade(Supplier<Item> supplier) {
        this.upgrade = supplier;
    }

    public Item getUpgrade() {
        return Objects.requireNonNull(this.upgrade).get();
    }

    public AbstractUpgradeItem getSpeedUpgrade() {
        return Objects.requireNonNull(this.speedUpgrade).get();
    }

    public void setSpeedUpgrade(Supplier<AbstractUpgradeItem> supplier) {
        this.speedUpgrade = supplier;
    }

    public AbstractUpgradeItem getStackUpgrade() {
        return Objects.requireNonNull(this.stackUpgrade).get();
    }

    public void setStackUpgrade(Supplier<AbstractUpgradeItem> supplier) {
        this.stackUpgrade = supplier;
    }

    public AbstractUpgradeItem getFortune1Upgrade() {
        return Objects.requireNonNull(this.fortune1Upgrade).get();
    }

    public void setFortune1Upgrade(Supplier<AbstractUpgradeItem> fortune1Upgrade) {
        this.fortune1Upgrade = fortune1Upgrade;
    }

    public AbstractUpgradeItem getFortune2Upgrade() {
        return Objects.requireNonNull(this.fortune2Upgrade).get();
    }

    public void setFortune2Upgrade(Supplier<AbstractUpgradeItem> fortune2Upgrade) {
        this.fortune2Upgrade = fortune2Upgrade;
    }

    public AbstractUpgradeItem getFortune3Upgrade() {
        return Objects.requireNonNull(this.fortune3Upgrade).get();
    }

    public void setFortune3Upgrade(Supplier<AbstractUpgradeItem> fortune3Upgrade) {
        this.fortune3Upgrade = fortune3Upgrade;
    }

    public AbstractUpgradeItem getSilkTouchUpgrade() {
        return Objects.requireNonNull(this.silkTouchUpgrade).get();
    }

    public void setSilkTouchUpgrade(Supplier<AbstractUpgradeItem> silkTouchUpgrade) {
        this.silkTouchUpgrade = silkTouchUpgrade;
    }

    public AbstractUpgradeItem getRegulatorUpgrade() {
        return Objects.requireNonNull(this.regulatorUpgrade).get();
    }

    public void setRegulatorUpgrade(Supplier<AbstractUpgradeItem> regulatorUpgrade) {
        this.regulatorUpgrade = regulatorUpgrade;
    }

    public AbstractUpgradeItem getRangeUpgrade() {
        return Objects.requireNonNull(this.rangeUpgrade).get();
    }

    public void setRangeUpgrade(Supplier<AbstractUpgradeItem> rangeUpgrade) {
        this.rangeUpgrade = rangeUpgrade;
    }

    public AbstractUpgradeItem getCreativeRangeUpgrade() {
        return Objects.requireNonNull(this.creativeRangeUpgrade).get();
    }

    public void setCreativeRangeUpgrade(Supplier<AbstractUpgradeItem> creativeRangeUpgrade) {
        this.creativeRangeUpgrade = creativeRangeUpgrade;
    }

    public AbstractUpgradeItem getAutocraftingUpgrade() {
        return Objects.requireNonNull(this.autocraftingUpgrade).get();
    }

    public void setAutocraftingUpgrade(Supplier<AbstractUpgradeItem> autocraftingUpgrade) {
        this.autocraftingUpgrade = autocraftingUpgrade;
    }

    public WirelessGridItem getWirelessGrid() {
        return Objects.requireNonNull(this.wirelessGrid).get();
    }

    public void setWirelessGrid(Supplier<WirelessGridItem> supplier) {
        this.wirelessGrid = supplier;
    }

    public WirelessGridItem getCreativeWirelessGrid() {
        return Objects.requireNonNull(this.creativeWirelessGrid).get();
    }

    public void setCreativeWirelessGrid(Supplier<WirelessGridItem> supplier) {
        this.creativeWirelessGrid = supplier;
    }

    public Item getConfigurationCard() {
        return Objects.requireNonNull(this.configurationCard).get();
    }

    public void setConfigurationCard(Supplier<Item> supplier) {
        this.configurationCard = supplier;
    }

    public void addNetworkReceiver(Supplier<BaseBlockItem> supplier) {
        this.allNetworkReceivers.add(supplier);
    }

    public List<Supplier<BaseBlockItem>> getNetworkReceivers() {
        return Collections.unmodifiableList(this.allNetworkReceivers);
    }

    public void addNetworkTransmitter(Supplier<BaseBlockItem> supplier) {
        this.allNetworkTransmitters.add(supplier);
    }

    public List<Supplier<BaseBlockItem>> getNetworkTransmitters() {
        return Collections.unmodifiableList(this.allNetworkTransmitters);
    }

    public void addSecurityManager(Supplier<BaseBlockItem> supplier) {
        this.allSecurityManagers.add(supplier);
    }

    public List<Supplier<BaseBlockItem>> getSecurityManagers() {
        return Collections.unmodifiableList(this.allSecurityManagers);
    }

    public void addRelay(Supplier<BaseBlockItem> supplier) {
        this.allRelays.add(supplier);
    }

    public List<Supplier<BaseBlockItem>> getRelays() {
        return Collections.unmodifiableList(this.allRelays);
    }

    public void addDiskInterface(Supplier<BaseBlockItem> supplier) {
        this.allDiskInterfaces.add(supplier);
    }

    public List<Supplier<BaseBlockItem>> getDiskInterfaces() {
        return Collections.unmodifiableList(this.allDiskInterfaces);
    }

    public void addAutocrafter(Supplier<BaseBlockItem> supplier) {
        this.allAutocrafters.add(supplier);
    }

    public List<Supplier<BaseBlockItem>> getAutocrafters() {
        return Collections.unmodifiableList(this.allAutocrafters);
    }

    public void addAutocrafterManager(Supplier<BaseBlockItem> supplier) {
        this.allAutocrafterManagers.add(supplier);
    }

    public List<Supplier<BaseBlockItem>> getAutocrafterManagers() {
        return Collections.unmodifiableList(this.allAutocrafterManagers);
    }

    public void addAutocraftingMonitor(Supplier<BaseBlockItem> supplier) {
        this.allAutocraftingMonitors.add(supplier);
    }

    public List<Supplier<BaseBlockItem>> getAutocraftingMonitors() {
        return Collections.unmodifiableList(this.allAutocraftingMonitors);
    }

    public Item getNetworkCard() {
        return Objects.requireNonNull(this.networkCard).get();
    }

    public void setNetworkCard(Supplier<Item> supplier) {
        this.networkCard = supplier;
    }

    public PortableGridBlockItem getPortableGrid() {
        return Objects.requireNonNull(this.portableGrid).get();
    }

    public void setPortableGrid(Supplier<PortableGridBlockItem> supplier) {
        this.portableGrid = supplier;
    }

    public PortableGridBlockItem getCreativePortableGrid() {
        return Objects.requireNonNull(this.creativePortableGrid).get();
    }

    public void setCreativePortableGrid(Supplier<PortableGridBlockItem> supplier) {
        this.creativePortableGrid = supplier;
    }

    public SecurityCardItem getSecurityCard() {
        return Objects.requireNonNull(this.securityCard).get();
    }

    public void setSecurityCard(Supplier<SecurityCardItem> securityCard) {
        this.securityCard = securityCard;
    }

    public FallbackSecurityCardItem getFallbackSecurityCard() {
        return Objects.requireNonNull(this.fallbackSecurityCard).get();
    }

    public void setFallbackSecurityCard(Supplier<FallbackSecurityCardItem> fallbackSecurityCard) {
        this.fallbackSecurityCard = fallbackSecurityCard;
    }

    public PatternItem getPattern() {
        return Objects.requireNonNull(this.pattern).get();
    }

    public void setPattern(Supplier<PatternItem> supplier) {
        this.pattern = supplier;
    }

    public WirelessAutocraftingMonitorItem getWirelessAutocraftingMonitor() {
        return Objects.requireNonNull(this.wirelessAutocraftingMonitor).get();
    }

    public void setWirelessAutocraftingMonitor(Supplier<WirelessAutocraftingMonitorItem> supplier) {
        this.wirelessAutocraftingMonitor = supplier;
    }

    public WirelessAutocraftingMonitorItem getCreativeWirelessAutocraftingMonitor() {
        return Objects.requireNonNull(this.creativeWirelessAutocraftingMonitor).get();
    }

    public void setCreativeWirelessAutocraftingMonitor(Supplier<WirelessAutocraftingMonitorItem> supplier) {
        this.creativeWirelessAutocraftingMonitor = supplier;
    }
}

