/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.preview;

import com.google.common.util.concurrent.RateLimiter;
import com.refinedmods.refinedstorage.api.autocrafting.preview.Preview;
import com.refinedmods.refinedstorage.api.autocrafting.preview.PreviewItem;
import com.refinedmods.refinedstorage.api.autocrafting.preview.PreviewType;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceRendering;
import com.refinedmods.refinedstorage.common.autocrafting.preview.AutocraftingPreviewContainerMenu;
import com.refinedmods.refinedstorage.common.autocrafting.preview.AutocraftingPreviewListener;
import com.refinedmods.refinedstorage.common.autocrafting.preview.AutocraftingRequest;
import com.refinedmods.refinedstorage.common.autocrafting.preview.AutocraftingRequestButton;
import com.refinedmods.refinedstorage.common.support.amount.AbstractAmountScreen;
import com.refinedmods.refinedstorage.common.support.amount.AmountScreenConfiguration;
import com.refinedmods.refinedstorage.common.support.amount.DoubleAmountOperations;
import com.refinedmods.refinedstorage.common.support.amount.IconButton;
import com.refinedmods.refinedstorage.common.support.tooltip.HelpClientTooltipComponent;
import com.refinedmods.refinedstorage.common.support.tooltip.SmallText;
import com.refinedmods.refinedstorage.common.support.widget.CheckboxWidget;
import com.refinedmods.refinedstorage.common.support.widget.ScrollbarWidget;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import org.joml.Vector3f;

public class AutocraftingPreviewScreen
extends AbstractAmountScreen<AutocraftingPreviewContainerMenu, Double>
implements AutocraftingPreviewListener {
    static final int REQUEST_BUTTON_HEIGHT = 24;
    static final int REQUEST_BUTTON_WIDTH = 64;
    private static final ResourceLocation TEXTURE = IdentifierUtil.createIdentifier("textures/gui/autocrafting_preview.png");
    private static final MutableComponent TITLE = IdentifierUtil.createTranslation("gui", "autocrafting_preview.title");
    private static final MutableComponent START = IdentifierUtil.createTranslation("gui", "autocrafting_preview.start");
    private static final MutableComponent PENDING = IdentifierUtil.createTranslation("gui", "autocrafting_preview.pending");
    private static final MutableComponent MAX = IdentifierUtil.createTranslation("gui", "autocrafting_preview.max");
    private static final MutableComponent MAX_HELP = IdentifierUtil.createTranslation("gui", "autocrafting_preview.max.help");
    private static final MutableComponent NOTIFY = IdentifierUtil.createTranslation("gui", "autocrafting_preview.notify");
    private static final MutableComponent NOTIFY_HELP = IdentifierUtil.createTranslation("gui", "autocrafting_preview.notify.help");
    private static final MutableComponent MISSING_RESOURCES = IdentifierUtil.createTranslation("gui", "autocrafting_preview.start.missing_resources");
    private static final MutableComponent CYCLE_DETECTED = IdentifierUtil.createTranslation("gui", "autocrafting_preview.cycle_detected").withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)));
    private static final MutableComponent CYCLE_OUTPUTS = IdentifierUtil.createTranslation("gui", "autocrafting_preview.cycle_detected.outputs");
    private static final MutableComponent BREAK_THE_CYCLE_AND_TRY_AGAIN = IdentifierUtil.createTranslation("gui", "autocrafting_preview.cycle_detected.break_the_cycle_and_try_again");
    private static final MutableComponent REQUEST_TOO_LARGE_TO_HANDLE = IdentifierUtil.createTranslation("gui", "autocrafting_preview.request_too_large_to_handle").withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)));
    private static final MutableComponent TRY_SMALLER_AMOUNT = IdentifierUtil.createTranslation("gui", "autocrafting_preview.request_too_large_to_handle.try_smaller_amount");
    private static final ResourceLocation ROW = IdentifierUtil.createIdentifier("autocrafting_preview/row");
    private static final ResourceLocation CRAFTING_REQUESTS = IdentifierUtil.createIdentifier("autocrafting_preview/requests");
    private static final int ROWS_VISIBLE = 4;
    private static final int COLUMNS = 3;
    private static final int PREVIEW_AREA_HEIGHT = 119;
    private static final int ROW_HEIGHT = 30;
    private static final int ROW_WIDTH = 221;
    private static final int REQUESTS_WIDTH = 91;
    private static final int REQUESTS_HEIGHT = 111;
    private static final int REQUESTS_INNER_WIDTH = 64;
    private static final int REQUESTS_INNER_HEIGHT = 96;
    private static final int REQUESTS_VISIBLE = 4;
    @Nullable
    private ScrollbarWidget previewItemsScrollbar;
    @Nullable
    private ScrollbarWidget requestButtonsScrollbar;
    @Nullable
    private Button maxButton;
    @Nullable
    private CheckboxWidget notifyCheckbox;
    private final List<AutocraftingRequestButton> requestButtons = new ArrayList<AutocraftingRequestButton>();
    private final boolean requestsButtonsVisible;
    private final RateLimiter requestRateLimiter = RateLimiter.create((double)1.0);
    private final RateLimiter maxAmountRequestRateLimiter = RateLimiter.create((double)0.2);
    @Nullable
    private Double changedAmount;
    private boolean mayEnableMaxAmountRequestButtonAgain;

    public AutocraftingPreviewScreen(Screen parent, Inventory playerInventory, List<AutocraftingRequest> requests) {
        this(new AutocraftingPreviewContainerMenu(requests), parent, playerInventory);
    }

    public AutocraftingPreviewScreen(AutocraftingPreviewContainerMenu menu, Inventory playerInventory) {
        this(menu, null, playerInventory);
    }

    public AutocraftingPreviewScreen(AutocraftingPreviewContainerMenu menu, @Nullable Screen parent, Inventory playerInventory) {
        super(menu, parent, playerInventory, (Component)TITLE, AmountScreenConfiguration.AmountScreenConfigurationBuilder.create().withInitialAmount(1.0).withIncrementsTop(1, 10, 64).withIncrementsTopStartPosition(new Vector3f(80.0f, 20.0f, 0.0f)).withIncrementsBottom(-1, -10, -64).withIncrementsBottomStartPosition(new Vector3f(80.0f, 71.0f, 0.0f)).withAmountFieldPosition(new Vector3f(77.0f, 51.0f, 0.0f)).withActionButtonsStartPosition(new Vector3f(7.0f, 222.0f, 0.0f)).withHorizontalActionButtons(true).withMinAmount(menu::getMinAmount).withResetAmount(1.0).withConfirmButtonText((Component)START).build(), DoubleAmountOperations.INSTANCE);
        this.imageWidth = 254;
        this.imageHeight = 249;
        this.requestsButtonsVisible = ((AutocraftingPreviewContainerMenu)this.getMenu()).getRequests().size() > 1;
        ((AutocraftingPreviewContainerMenu)this.getMenu()).setListener(this);
    }

    @Override
    protected void init() {
        boolean wasAlreadyInitialized = this.amountField != null;
        super.init();
        this.previewItemsScrollbar = new ScrollbarWidget(this.leftPos + 235, this.topPos + 98, ScrollbarWidget.Type.NORMAL, 119);
        this.previewItemsScrollbar.setEnabled(false);
        if (this.requestsButtonsVisible) {
            this.initRequestButtons();
        }
        if (this.confirmButton != null) {
            this.setStartDisabled();
        }
        if (!wasAlreadyInitialized) {
            ((AutocraftingPreviewContainerMenu)this.getMenu()).loadCurrentRequest();
        }
        boolean wasActive = this.maxButton == null || this.maxButton.active;
        this.maxButton = Button.builder((Component)MAX, this::requestMaxAmount).size(22, 15).pos(this.leftPos + 185 - 1, this.topPos + 49 - 1).build();
        this.maxButton.active = wasActive;
        this.addRenderableWidget((GuiEventListener)this.maxButton);
        boolean selected = this.notifyCheckbox == null ? ((AutocraftingPreviewContainerMenu)this.menu).isNotify() : this.notifyCheckbox.isSelected();
        this.notifyCheckbox = new CheckboxWidget(this.leftPos + this.imageWidth - this.font.width((FormattedText)NOTIFY) - 4 - 9 - 6, this.topPos + 222 + 6, (Component)NOTIFY, Minecraft.getInstance().font, selected, CheckboxWidget.Size.SMALL);
        this.notifyCheckbox.setHelpTooltip((Component)NOTIFY_HELP);
        this.notifyCheckbox.setOnPressed((checkbox, notify) -> ((AutocraftingPreviewContainerMenu)this.menu).setNotify(notify));
        this.addRenderableWidget((GuiEventListener)this.notifyCheckbox);
        this.getExclusionZones().add(new Rect2i(this.leftPos - 91 + 4, this.topPos, 91, 111));
    }

    @Override
    @Nullable
    protected IconButton.Icon getConfirmButtonIcon() {
        return null;
    }

    private void requestMaxAmount(Button button) {
        button.active = false;
        ((AutocraftingPreviewContainerMenu)this.getMenu()).requestMaxAmount();
    }

    private void initRequestButtons() {
        this.requestButtons.clear();
        this.requestButtonsScrollbar = new ScrollbarWidget(this.leftPos - 17 + 4, this.getRequestButtonsInnerY(), ScrollbarWidget.Type.NORMAL, 96);
        this.requestButtonsScrollbar.setListener(value -> {
            int scrollOffset = this.requestButtonsScrollbar.isSmoothScrolling() ? (int)this.requestButtonsScrollbar.getOffset() : (int)this.requestButtonsScrollbar.getOffset() * 24;
            for (int i = 0; i < this.requestButtons.size(); ++i) {
                AutocraftingRequestButton requestButton = this.requestButtons.get(i);
                int y = this.getCraftingRequestButtonY(i) - scrollOffset;
                requestButton.setY(y);
                requestButton.visible = this.isCraftingRequestButtonVisible(y);
            }
        });
        this.updateRequestsScrollbar();
        for (int i = 0; i < ((AutocraftingPreviewContainerMenu)this.getMenu()).getRequests().size(); ++i) {
            AutocraftingRequest request = ((AutocraftingPreviewContainerMenu)this.getMenu()).getRequests().get(i);
            int buttonY = this.getCraftingRequestButtonY(i);
            AutocraftingRequestButton button = new AutocraftingRequestButton(this.getRequestButtonsInnerX(), buttonY, request, this::changeCurrentRequest);
            button.visible = this.isCraftingRequestButtonVisible(buttonY);
            this.requestButtons.add((AutocraftingRequestButton)this.addWidget((GuiEventListener)button));
        }
    }

    private boolean isCraftingRequestButtonVisible(int y) {
        int innerY = this.getRequestButtonsInnerY();
        return y >= innerY - 24 && y <= innerY + 96;
    }

    private int getCraftingRequestButtonY(int i) {
        return this.getRequestButtonsInnerY() + i * 24;
    }

    private void changeCurrentRequest(AutocraftingRequest request) {
        ((AutocraftingPreviewContainerMenu)this.getMenu()).setCurrentRequest(request);
    }

    private void setRequest(AutocraftingRequest request) {
        for (AutocraftingRequestButton requestButton : this.requestButtons) {
            requestButton.active = requestButton.getRequest() != request;
        }
        this.updateAmount(request.getAmount());
        this.setPreview(request.getPreview());
    }

    private void setPreview(@Nullable Preview preview) {
        if (this.previewItemsScrollbar == null || this.confirmButton == null) {
            return;
        }
        if (preview == null) {
            this.previewItemsScrollbar.setEnabled(false);
            this.previewItemsScrollbar.setMaxOffset(0.0);
            this.setStartDisabled();
            return;
        }
        int items = preview.items().size();
        int rows = Math.ceilDiv(items, 3) - 4;
        this.previewItemsScrollbar.setMaxOffset(this.previewItemsScrollbar.isSmoothScrolling() ? (double)(rows * 30) : (double)rows);
        this.previewItemsScrollbar.setEnabled(rows > 0);
        this.confirmButton.setMessage((Component)START);
        this.confirmButton.active = preview.type() == PreviewType.SUCCESS;
        this.confirmButton.setIcon(preview.type() == PreviewType.SUCCESS ? IconButton.Icon.START : IconButton.Icon.ERROR);
        this.confirmButton.setTooltip(preview.type() == PreviewType.MISSING_RESOURCES ? Tooltip.create((Component)MISSING_RESOURCES) : null);
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        if (this.previewItemsScrollbar != null) {
            this.previewItemsScrollbar.render(graphics, mouseX, mouseY, partialTicks);
        }
        if (this.requestButtonsScrollbar != null) {
            this.requestButtonsScrollbar.render(graphics, mouseX, mouseY, partialTicks);
        }
        if (this.requestsButtonsVisible) {
            int requestsInnerX = this.getRequestButtonsInnerX();
            int requestsInnerY = this.getRequestButtonsInnerY();
            graphics.enableScissor(requestsInnerX, requestsInnerY, requestsInnerX + 64, requestsInnerY + 96);
            for (AutocraftingRequestButton requestButton : this.requestButtons) {
                requestButton.render(graphics, mouseX, mouseY, partialTicks);
            }
            graphics.disableScissor();
        }
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float delta, int mouseX, int mouseY) {
        AutocraftingRequest request;
        Preview preview;
        super.renderBg(graphics, delta, mouseX, mouseY);
        if (this.requestsButtonsVisible) {
            graphics.blitSprite(CRAFTING_REQUESTS, this.leftPos - 91 + 4, this.topPos, 91, 111);
        }
        if ((preview = (request = ((AutocraftingPreviewContainerMenu)this.getMenu()).getCurrentRequest()).getPreview()) == null || this.previewItemsScrollbar == null) {
            return;
        }
        int x = this.leftPos + 8;
        int y = this.topPos + 98;
        graphics.enableScissor(x, y, x + 221, y + 119);
        if (preview.type() == PreviewType.CYCLE_DETECTED) {
            this.renderCycleDetected(graphics, y, x, preview);
        } else if (preview.type() == PreviewType.OVERFLOW) {
            this.renderRequestTooLargeToHandle(graphics, x, y);
        } else {
            this.renderPreviewRows(graphics, mouseX, mouseY, preview, y, x);
        }
        graphics.disableScissor();
    }

    private void renderCycleDetected(GuiGraphics graphics, int y, int x, Preview preview) {
        int yy = y + 4;
        SmallText.render(graphics, this.font, CYCLE_DETECTED.getVisualOrderText(), x + 4, yy, 0xFF5555, false, 0.5f);
        SmallText.render(graphics, this.font, CYCLE_OUTPUTS.getVisualOrderText(), x + 4, yy += 10, 0x404040, false, 0.5f);
        yy += 10;
        for (ResourceAmount output : preview.outputsOfPatternWithCycle()) {
            ResourceRendering rendering = RefinedStorageClientApi.INSTANCE.getResourceRendering(output.resource().getClass());
            rendering.render(output.resource(), graphics, x + 4, yy);
            SmallText.render(graphics, this.font, Component.literal((String)(output.amount() + "x ")).append(rendering.getDisplayName(output.resource())).getVisualOrderText(), x + 4 + 16 + 3, yy + 5, 0x404040, false, 0.5f);
            yy += 18;
        }
        SmallText.render(graphics, this.font, BREAK_THE_CYCLE_AND_TRY_AGAIN.getVisualOrderText(), x + 4, yy += 2, 0x404040, false, 0.5f);
    }

    private void renderRequestTooLargeToHandle(GuiGraphics graphics, int x, int y) {
        SmallText.render(graphics, this.font, REQUEST_TOO_LARGE_TO_HANDLE.getVisualOrderText(), x + 4, y + 4, 0xFF5555, false, 0.5f);
        SmallText.render(graphics, this.font, TRY_SMALLER_AMOUNT.getVisualOrderText(), x + 4, y + 4 + 10, 0x404040, false, 0.5f);
    }

    private void renderPreviewRows(GuiGraphics graphics, int mouseX, int mouseY, Preview preview, int y, int x) {
        List<PreviewItem> items = preview.items();
        int rows = Math.ceilDiv(items.size(), 3);
        for (int i = 0; i < rows; ++i) {
            int scrollOffset = this.getScrollOffset();
            int yy = y + i * 30 - scrollOffset;
            this.renderRow(graphics, x, yy, i, items, mouseX, mouseY);
        }
    }

    private int getScrollOffset() {
        if (this.previewItemsScrollbar == null) {
            return 0;
        }
        return this.previewItemsScrollbar.isSmoothScrolling() ? (int)this.previewItemsScrollbar.getOffset() : (int)this.previewItemsScrollbar.getOffset() * 30;
    }

    private void renderRow(GuiGraphics graphics, int x, int y, int i, List<PreviewItem> items, double mouseX, double mouseY) {
        if (y <= this.topPos + 98 - 30 || y > this.topPos + 98 + 119) {
            return;
        }
        graphics.blitSprite(ROW, x, y, 221, 30);
        for (int column = i * 3; column < Math.min(i * 3 + 3, items.size()); ++column) {
            PreviewItem item = items.get(column);
            int xx = x + column % 3 * 74;
            this.renderCell(graphics, xx, y, item, mouseX, mouseY);
        }
    }

    private void renderCell(GuiGraphics graphics, int x, int y, PreviewItem item, double mouseX, double mouseY) {
        if (item.missing() > 0L) {
            graphics.fill(x, y, x + 73, y + 29, -860450);
        }
        int xx = x + 2;
        ResourceRendering rendering = RefinedStorageClientApi.INSTANCE.getResourceRendering(item.resource().getClass());
        int yy = y + 7;
        rendering.render(item.resource(), graphics, xx, yy);
        if (this.isHovering(xx - this.leftPos, yy - this.topPos, 16, 16, mouseX, mouseY) && this.isHoveringOverPreviewArea(mouseX, mouseY)) {
            this.setTooltipForNextRenderPass(rendering.getTooltip(item.resource()).stream().map(Component::getVisualOrderText).toList());
        }
        if (!SmallText.isSmall()) {
            yy -= 2;
        }
        xx += 19;
        if (item.missing() > 0L) {
            this.renderCellText(graphics, "missing", rendering, xx, yy, item.missing());
            yy += 7;
        }
        if (item.available() > 0L) {
            this.renderCellText(graphics, "available", rendering, xx, yy, item.available());
            yy += 7;
        }
        if (item.toCraft() > 0L) {
            this.renderCellText(graphics, "to_craft", rendering, xx, yy, item.toCraft());
        }
    }

    private void renderCellText(GuiGraphics graphics, String type, ResourceRendering rendering, int x, int y, long amount) {
        SmallText.render(graphics, this.font, IdentifierUtil.createTranslation("gui", "autocrafting_preview." + type, rendering.formatAmount(amount, true)).getVisualOrderText(), x, y, 0x404040, false, 0.5f);
    }

    @Override
    protected void renderTooltip(GuiGraphics graphics, int x, int y) {
        super.renderTooltip(graphics, x, y);
        if (this.maxButton != null && this.maxButton.isHovered()) {
            Platform.INSTANCE.renderTooltip(graphics, List.of(HelpClientTooltipComponent.createAlwaysDisplayed((Component)MAX_HELP)), x, y);
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int clickedButton) {
        if (this.previewItemsScrollbar != null && this.previewItemsScrollbar.mouseClicked(mouseX, mouseY, clickedButton)) {
            return true;
        }
        if (this.requestButtonsScrollbar != null && this.requestButtonsScrollbar.mouseClicked(mouseX, mouseY, clickedButton)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, clickedButton);
    }

    public void mouseMoved(double mx, double my) {
        if (this.previewItemsScrollbar != null) {
            this.previewItemsScrollbar.mouseMoved(mx, my);
        }
        if (this.requestButtonsScrollbar != null) {
            this.requestButtonsScrollbar.mouseMoved(mx, my);
        }
        super.mouseMoved(mx, my);
    }

    public boolean mouseReleased(double mx, double my, int button) {
        if (this.previewItemsScrollbar != null && this.previewItemsScrollbar.mouseReleased(mx, my, button)) {
            return true;
        }
        if (this.requestButtonsScrollbar != null && this.requestButtonsScrollbar.mouseReleased(mx, my, button)) {
            return true;
        }
        return super.mouseReleased(mx, my, button);
    }

    @Override
    public boolean mouseScrolled(double x, double y, double z, double delta) {
        boolean didPreviewItemsScrollbar = this.previewItemsScrollbar != null && this.isHoveringOverPreviewArea(x, y) && this.previewItemsScrollbar.mouseScrolled(x, y, z, delta);
        boolean didRequestButtonsScrollbar = !didPreviewItemsScrollbar && this.requestButtonsScrollbar != null && this.isHoveringOverRequestButtons(x, y) && this.requestButtonsScrollbar.mouseScrolled(x, y, z, delta);
        return didPreviewItemsScrollbar || didRequestButtonsScrollbar || super.mouseScrolled(x, y, z, delta);
    }

    private boolean isHoveringOverPreviewArea(double x, double y) {
        return this.isHovering(7, 97, 241, 121, x, y);
    }

    private boolean isHoveringOverRequestButtons(double x, double y) {
        int requestsInnerX = this.getRequestButtonsInnerX() - 1;
        int requestsInnerY = this.getRequestButtonsInnerY() - 1;
        return this.isHovering(requestsInnerX - this.leftPos, requestsInnerY - this.topPos, 80, 98, x, y);
    }

    private int getRequestButtonsInnerY() {
        return this.topPos + 8;
    }

    private int getRequestButtonsInnerX() {
        return this.leftPos - 83 + 4;
    }

    @Override
    protected ResourceLocation getTexture() {
        return TEXTURE;
    }

    @Override
    protected void onAmountFieldChanged() {
        if (this.amountField == null || this.confirmButton == null) {
            return;
        }
        this.getAndValidateAmount().ifPresentOrElse(amount -> {
            this.setPending();
            this.changedAmount = amount;
            this.amountField.setTextColor(0xFFFFFF);
        }, () -> {
            this.setStartDisabled();
            this.amountField.setTextColor(0xFF5555);
        });
    }

    private void setPending() {
        if (this.confirmButton == null) {
            return;
        }
        this.confirmButton.active = false;
        this.confirmButton.setIcon(null);
        this.confirmButton.setTooltip(null);
        this.confirmButton.setMessage((Component)PENDING);
    }

    private void setStartDisabled() {
        if (this.confirmButton == null) {
            return;
        }
        this.confirmButton.active = false;
        this.confirmButton.setIcon(null);
        this.confirmButton.setTooltip(null);
        this.confirmButton.setMessage((Component)START);
    }

    protected void containerTick() {
        super.containerTick();
        if (this.changedAmount != null && this.requestRateLimiter.tryAcquire()) {
            ((AutocraftingPreviewContainerMenu)this.getMenu()).amountChanged(this.changedAmount);
            this.changedAmount = null;
        }
        if (this.mayEnableMaxAmountRequestButtonAgain && this.maxButton != null && this.maxAmountRequestRateLimiter.tryAcquire()) {
            this.maxButton.active = true;
            this.mayEnableMaxAmountRequestButtonAgain = false;
        }
    }

    @Override
    protected void reset() {
        this.updateAmount(((AutocraftingPreviewContainerMenu)this.getMenu()).getCurrentRequest().getAmount());
    }

    @Override
    protected boolean confirm(Double amount) {
        this.setPending();
        ((AutocraftingPreviewContainerMenu)this.getMenu()).sendRequest(amount, this.notifyCheckbox == null ? ((AutocraftingPreviewContainerMenu)this.menu).isNotify() : this.notifyCheckbox.isSelected());
        return false;
    }

    @Override
    public void requestChanged(AutocraftingRequest request) {
        this.setRequest(request);
    }

    @Override
    public void previewChanged(@Nullable Preview preview) {
        this.setPreview(preview);
    }

    @Override
    public void requestRemoved(AutocraftingRequest request, boolean last) {
        if (last) {
            this.close();
            return;
        }
        this.requestButtons.stream().filter(btn -> btn.getRequest() == request).findFirst().ifPresent(btn -> {
            this.removeWidget((GuiEventListener)btn);
            this.requestButtons.remove(btn);
        });
        this.updateRequestsScrollbar();
        for (int i = 0; i < this.requestButtons.size(); ++i) {
            AutocraftingRequestButton requestButton = this.requestButtons.get(i);
            int buttonY = this.getCraftingRequestButtonY(i);
            requestButton.setY(buttonY);
            requestButton.visible = this.isCraftingRequestButtonVisible(buttonY);
        }
    }

    @Override
    public void maxAmountReceived(double maxAmount) {
        this.updateAmount(maxAmount);
        this.maxAmountRequestRateLimiter.tryAcquire();
        this.mayEnableMaxAmountRequestButtonAgain = true;
    }

    private void updateRequestsScrollbar() {
        if (this.requestButtonsScrollbar == null) {
            return;
        }
        int totalRequestButtons = ((AutocraftingPreviewContainerMenu)this.getMenu()).getRequests().size() - 4;
        int maxOffset = this.requestButtonsScrollbar.isSmoothScrolling() ? totalRequestButtons * 24 : totalRequestButtons;
        this.requestButtonsScrollbar.setEnabled(maxOffset > 0);
        this.requestButtonsScrollbar.setMaxOffset(maxOffset);
    }
}

