/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.preview;

import com.refinedmods.refinedstorage.api.autocrafting.preview.Preview;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.autocrafting.preview.AutocraftingPreviewListener;
import com.refinedmods.refinedstorage.common.autocrafting.preview.AutocraftingRequest;
import com.refinedmods.refinedstorage.common.support.containermenu.AbstractResourceContainerMenu;
import com.refinedmods.refinedstorage.common.support.containermenu.DisabledResourceSlot;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlotType;
import com.refinedmods.refinedstorage.common.support.packet.c2s.C2SPackets;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.MenuType;

public class AutocraftingPreviewContainerMenu
extends AbstractResourceContainerMenu {
    private final List<AutocraftingRequest> requests;
    private AutocraftingRequest currentRequest;
    @Nullable
    private AutocraftingPreviewListener listener;

    AutocraftingPreviewContainerMenu(List<AutocraftingRequest> requests) {
        this(null, 0, requests);
    }

    public AutocraftingPreviewContainerMenu(@Nullable MenuType<?> type, int syncId, List<AutocraftingRequest> requests) {
        super(type, syncId);
        this.requests = new ArrayList<AutocraftingRequest>(requests);
        this.currentRequest = requests.getFirst();
        ResourceContainer resourceContainer = ResourceContainerImpl.createForFilter(1);
        resourceContainer.set(0, new ResourceAmount(requests.getFirst().getResource(), 1L));
        this.addSlot(new DisabledResourceSlot(resourceContainer, 0, (Component)Component.empty(), 157, 48, ResourceSlotType.FILTER));
    }

    void setListener(AutocraftingPreviewListener listener) {
        this.listener = listener;
    }

    List<AutocraftingRequest> getRequests() {
        return this.requests;
    }

    AutocraftingRequest getCurrentRequest() {
        return this.currentRequest;
    }

    void setCurrentRequest(AutocraftingRequest request) {
        this.currentRequest = request;
        if (this.listener != null) {
            this.listener.requestChanged(request);
        }
    }

    void amountChanged(double amount) {
        if (this.currentRequest.sendPreviewRequest(amount) && this.listener != null) {
            this.listener.previewChanged(null);
        }
    }

    public void previewResponseReceived(UUID id, Preview preview) {
        if (!this.currentRequest.getId().equals(id)) {
            return;
        }
        this.currentRequest.previewResponseReceived(preview);
        if (this.listener != null) {
            this.listener.previewChanged(preview);
        }
    }

    void loadCurrentRequest() {
        this.currentRequest.clearPreview();
        if (this.listener != null) {
            this.listener.requestChanged(this.currentRequest);
        }
    }

    void sendRequest(double amount, boolean notify) {
        this.currentRequest.sendRequest(amount, notify);
    }

    public void responseReceived(UUID id, boolean success) {
        if (!this.currentRequest.getId().equals(id) || !success) {
            return;
        }
        this.requests.remove(this.currentRequest);
        boolean last = this.requests.isEmpty();
        if (this.listener != null) {
            this.listener.requestRemoved(this.currentRequest, last);
        }
        if (!last) {
            this.setCurrentRequest(this.requests.getFirst());
        }
    }

    public void maxAmountResponseReceived(long maxAmount) {
        if (this.listener == null) {
            return;
        }
        ResourceKey resourceKey = this.currentRequest.getResource();
        if (resourceKey instanceof PlatformResourceKey) {
            PlatformResourceKey resource = (PlatformResourceKey)resourceKey;
            this.listener.maxAmountReceived(resource.getResourceType().getDisplayAmount(maxAmount));
        }
    }

    void requestMaxAmount() {
        ResourceKey resourceKey = this.currentRequest.getResource();
        if (resourceKey instanceof PlatformResourceKey) {
            PlatformResourceKey resource = (PlatformResourceKey)resourceKey;
            C2SPackets.sendAutocraftingPreviewMaxAmountRequest(resource);
        }
    }

    boolean isNotify() {
        return Platform.INSTANCE.getConfig().isAutocraftingNotification();
    }

    void setNotify(boolean notify) {
        Platform.INSTANCE.getConfig().setAutocraftingNotification(notify);
    }

    double getMinAmount() {
        ResourceKey resourceKey = this.currentRequest.getResource();
        if (resourceKey instanceof PlatformResourceKey) {
            PlatformResourceKey platformResource = (PlatformResourceKey)resourceKey;
            return platformResource.getResourceType().getDisplayAmount(1L);
        }
        return 1.0;
    }
}

