/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.autocraftermanager;

import com.refinedmods.refinedstorage.api.autocrafting.Ingredient;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.autocrafting.PatternInventory;
import com.refinedmods.refinedstorage.common.autocrafting.autocraftermanager.AutocrafterManagerBlockEntity;
import com.refinedmods.refinedstorage.common.autocrafting.autocraftermanager.AutocrafterManagerData;
import com.refinedmods.refinedstorage.common.autocrafting.autocraftermanager.AutocrafterManagerListener;
import com.refinedmods.refinedstorage.common.autocrafting.autocraftermanager.AutocrafterManagerSearchMode;
import com.refinedmods.refinedstorage.common.autocrafting.autocraftermanager.AutocrafterManagerSlot;
import com.refinedmods.refinedstorage.common.autocrafting.autocraftermanager.AutocrafterManagerViewType;
import com.refinedmods.refinedstorage.common.autocrafting.autocraftermanager.AutocrafterManagerWatcher;
import com.refinedmods.refinedstorage.common.content.Menus;
import com.refinedmods.refinedstorage.common.support.AbstractBaseContainerMenu;
import com.refinedmods.refinedstorage.common.support.RedstoneMode;
import com.refinedmods.refinedstorage.common.support.containermenu.ClientProperty;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyTypes;
import com.refinedmods.refinedstorage.common.support.containermenu.ServerProperty;
import com.refinedmods.refinedstorage.common.support.packet.s2c.S2CPackets;
import com.refinedmods.refinedstorage.common.support.stretching.ScreenSizeListener;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class AutocrafterManagerContainerMenu
extends AbstractBaseContainerMenu
implements ScreenSizeListener,
AutocrafterManagerWatcher {
    private final Inventory playerInventory;
    private final List<ViewGroup> groups;
    private final List<AutocrafterManagerSlot> autocrafterSlots = new ArrayList<AutocrafterManagerSlot>();
    @Nullable
    private AutocrafterManagerListener listener;
    @Nullable
    private AutocrafterManagerBlockEntity autocrafterManager;
    private String query = "";
    private boolean active;

    public AutocrafterManagerContainerMenu(int syncId, Inventory playerInventory, AutocrafterManagerData data) {
        super(Menus.INSTANCE.getAutocrafterManager(), syncId);
        this.playerInventory = playerInventory;
        this.registerProperty(new ClientProperty<RedstoneMode>(PropertyTypes.REDSTONE_MODE, RedstoneMode.IGNORE));
        this.groups = data.groups().stream().map(g -> ViewGroup.from(playerInventory.player.level(), g)).toList();
        this.active = data.active();
        this.resized(0, 0, 0);
    }

    AutocrafterManagerContainerMenu(int syncId, Inventory playerInventory, AutocrafterManagerBlockEntity autocrafterManager, List<AutocrafterManagerBlockEntity.Group> groups) {
        super(Menus.INSTANCE.getAutocrafterManager(), syncId);
        this.playerInventory = playerInventory;
        this.autocrafterManager = autocrafterManager;
        this.autocrafterManager.addWatcher(this);
        this.registerProperty(new ServerProperty<RedstoneMode>(PropertyTypes.REDSTONE_MODE, autocrafterManager::getRedstoneMode, autocrafterManager::setRedstoneMode));
        this.groups = Collections.emptyList();
        this.addServerSideSlots(groups);
    }

    public void removed(Player playerEntity) {
        super.removed(playerEntity);
        if (this.autocrafterManager != null) {
            this.autocrafterManager.removeWatcher(this);
        }
    }

    void setListener(AutocrafterManagerListener listener) {
        this.listener = listener;
    }

    void setQuery(String query) {
        this.query = query;
        this.notifyListener();
    }

    private void notifyListener() {
        if (this.listener != null) {
            this.listener.slotsChanged();
        }
    }

    private void addServerSideSlots(List<AutocrafterManagerBlockEntity.Group> serverGroups) {
        for (AutocrafterManagerBlockEntity.Group group : serverGroups) {
            this.addServerSideSlots(group);
        }
        this.addPlayerInventory(this.playerInventory, 0, 0);
    }

    private void addServerSideSlots(AutocrafterManagerBlockEntity.Group group) {
        for (AutocrafterManagerBlockEntity.SubGroup subGroup : group.subGroups()) {
            Container container = subGroup.container();
            for (int i = 0; i < container.getContainerSize(); ++i) {
                this.addSlot(new Slot(container, i, 0, 0));
            }
        }
    }

    public boolean containsPattern(ItemStack stack) {
        for (Slot slot : this.autocrafterSlots) {
            if (slot.getItem() != stack) continue;
            return true;
        }
        return false;
    }

    @Override
    public void resized(int playerInventoryY, int topYStart, int topYEnd) {
        this.initializeGroups(playerInventoryY, topYStart, topYEnd);
    }

    private void initializeGroups(int playerInventoryY, int topYStart, int topYEnd) {
        this.resetSlots();
        this.autocrafterSlots.clear();
        int rowX = 8;
        int startY = topYStart - 18;
        int rowY = topYStart;
        for (ViewGroup group : this.groups) {
            rowY += this.initializeGroup(group, 8, rowY, startY, topYEnd);
        }
        this.addPlayerInventory(this.playerInventory, 8, playerInventoryY);
    }

    private int initializeGroup(ViewGroup group, int rowX, int rowY, int startY, int topYEnd) {
        int slotsWithinGroup = 0;
        for (SubViewGroup subGroup : group.subViewGroups) {
            int slotsWithinSubGroup = 0;
            boolean visible = this.active && this.isVisible(subGroup);
            for (int i = 0; i < subGroup.backingInventory.getContainerSize(); ++i) {
                int slotX = rowX + slotsWithinGroup % 9 * 18;
                int slotY = rowY + 18 + slotsWithinGroup / 9 * 18;
                boolean slotVisible = visible && this.isSlotVisible(this.playerInventory.player.level(), group, i);
                AutocrafterManagerSlot slot = new AutocrafterManagerSlot(subGroup.backingInventory, this.playerInventory.player.level(), i, slotX, slotY, IntIntPair.of((int)startY, (int)topYEnd), slotVisible);
                this.addSlot(slot);
                if (!slotVisible) continue;
                this.autocrafterSlots.add(slot);
                ++slotsWithinGroup;
                ++slotsWithinSubGroup;
            }
            subGroup.visibleSlots = slotsWithinSubGroup;
        }
        group.visibleSlots = slotsWithinGroup;
        if (slotsWithinGroup == 0) {
            return 0;
        }
        return (group.getVisibleRows() + 1) * 18;
    }

    private boolean isVisible(SubViewGroup subGroup) {
        return switch (this.getViewType()) {
            default -> throw new MatchException(null, null);
            case AutocrafterManagerViewType.VISIBLE -> subGroup.visibleToTheAutocrafterManager;
            case AutocrafterManagerViewType.NOT_FULL -> {
                if (!subGroup.full) {
                    yield true;
                }
                yield false;
            }
            case AutocrafterManagerViewType.ALL -> true;
        };
    }

    private boolean isSlotVisible(Level level, ViewGroup group, int index) {
        String normalizedQuery = this.query.trim().toLowerCase(Locale.ROOT);
        if (normalizedQuery.isEmpty()) {
            return true;
        }
        return this.getSearchMode().isSlotVisible(group, level, normalizedQuery, index);
    }

    List<ViewGroup> getGroups() {
        return this.groups;
    }

    List<AutocrafterManagerSlot> getAutocrafterSlots() {
        return this.autocrafterSlots;
    }

    AutocrafterManagerSearchMode getSearchMode() {
        return Platform.INSTANCE.getConfig().getAutocrafterManager().getSearchMode();
    }

    void setSearchMode(AutocrafterManagerSearchMode searchMode) {
        Platform.INSTANCE.getConfig().getAutocrafterManager().setSearchMode(searchMode);
        this.notifyListener();
    }

    AutocrafterManagerViewType getViewType() {
        return Platform.INSTANCE.getConfig().getAutocrafterManager().getViewType();
    }

    void setViewType(AutocrafterManagerViewType toggle) {
        Platform.INSTANCE.getConfig().getAutocrafterManager().setViewType(toggle);
        this.notifyListener();
    }

    public void setActive(boolean active) {
        this.active = active;
        this.notifyListener();
    }

    boolean isActive() {
        return this.active;
    }

    @Override
    public void activeChanged(boolean newActive) {
        Player player = this.playerInventory.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)player;
            S2CPackets.sendAutocrafterManagerActive(serverPlayerEntity, newActive);
        }
    }

    static class ViewGroup {
        private final String name;
        private final List<SubViewGroup> subViewGroups;
        private final List<SubViewGroup> subViewGroupsView;
        private int visibleSlots;

        private ViewGroup(String name, List<SubViewGroup> subViewGroups) {
            this.name = name;
            this.subViewGroups = subViewGroups;
            this.subViewGroupsView = Collections.unmodifiableList(subViewGroups);
        }

        private static ViewGroup from(Level level, AutocrafterManagerData.Group group) {
            return new ViewGroup(group.name(), group.subGroups().stream().map(subGroup -> SubViewGroup.from(subGroup, level)).toList());
        }

        String getName() {
            return this.name;
        }

        List<SubViewGroup> getSubViewGroups() {
            return this.subViewGroupsView;
        }

        boolean isVisible() {
            return this.visibleSlots > 0;
        }

        int getVisibleRows() {
            return Math.ceilDiv(this.visibleSlots, 9);
        }

        boolean nameContains(String normalizedQuery) {
            return this.name.toLowerCase(Locale.ROOT).trim().contains(normalizedQuery);
        }

        boolean hasPatternInput(Level level, String normalizedQuery, int index) {
            return this.subViewGroups.stream().anyMatch(subGroup -> subGroup.hasPatternInput(level, normalizedQuery, index));
        }

        boolean hasPatternOutput(Level level, String normalizedQuery, int index) {
            return this.subViewGroups.stream().anyMatch(subGroup -> subGroup.hasPatternOutput(level, normalizedQuery, index));
        }
    }

    static class SubViewGroup {
        private final boolean visibleToTheAutocrafterManager;
        private final Container backingInventory;
        private final boolean full;
        private int visibleSlots;

        private SubViewGroup(boolean visibleToTheAutocrafterManager, Container backingInventory, boolean full) {
            this.visibleToTheAutocrafterManager = visibleToTheAutocrafterManager;
            this.backingInventory = backingInventory;
            this.full = full;
        }

        private static SubViewGroup from(AutocrafterManagerData.SubGroup subGroup, Level level) {
            PatternInventory backingInventory = new PatternInventory(subGroup.slotCount(), () -> level);
            return new SubViewGroup(subGroup.visibleToTheAutocrafterManager(), (Container)backingInventory, subGroup.full());
        }

        int getVisibleSlots() {
            return this.visibleSlots;
        }

        boolean hasPatternInput(Level level, String normalizedQuery, int index) {
            ItemStack patternStack = this.backingInventory.getItem(index);
            return RefinedStorageApi.INSTANCE.getPattern(patternStack, level).map(pattern -> SubViewGroup.hasIngredient(pattern.layout().ingredients(), normalizedQuery)).orElse(false);
        }

        boolean hasPatternOutput(Level level, String normalizedQuery, int index) {
            ItemStack patternStack = this.backingInventory.getItem(index);
            return RefinedStorageApi.INSTANCE.getPattern(patternStack, level).map(pattern -> SubViewGroup.hasResource(pattern.layout().outputs(), normalizedQuery)).orElse(false);
        }

        private static boolean hasIngredient(List<Ingredient> ingredients, String normalizedQuery) {
            return ingredients.stream().flatMap(i -> i.inputs().stream()).anyMatch(key -> SubViewGroup.hasResource(normalizedQuery, key));
        }

        private static boolean hasResource(List<ResourceAmount> resources, String normalizedQuery) {
            return resources.stream().map(ResourceAmount::resource).anyMatch(key -> SubViewGroup.hasResource(normalizedQuery, key));
        }

        private static boolean hasResource(String normalizedQuery, ResourceKey key) {
            return RefinedStorageClientApi.INSTANCE.getResourceRendering(key.getClass()).getDisplayName(key).getString().toLowerCase(Locale.ROOT).trim().contains(normalizedQuery);
        }
    }
}

