/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.refinedmods.refinedstorage.api.autocrafting.Ingredient;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.list.MutableResourceListImpl;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.support.resource.ResourceCodecs;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public record ProcessingPatternState(List<Optional<ProcessingIngredient>> ingredients, List<Optional<ResourceAmount>> outputs) {
    public static final Codec<ProcessingPatternState> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list(ProcessingIngredient.OPTIONAL_CODEC).fieldOf("ingredients").forGetter(ProcessingPatternState::ingredients), (App)Codec.list(ResourceCodecs.AMOUNT_OPTIONAL_CODEC).fieldOf("outputs").forGetter(ProcessingPatternState::outputs)).apply((Applicative)instance, ProcessingPatternState::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProcessingPatternState> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.collection(ArrayList::new, ProcessingIngredient.OPTIONAL_STREAM_CODEC), ProcessingPatternState::ingredients, (StreamCodec)ByteBufCodecs.collection(ArrayList::new, ResourceCodecs.AMOUNT_STREAM_OPTIONAL_CODEC), ProcessingPatternState::outputs, ProcessingPatternState::new);

    List<Ingredient> getIngredients() {
        return this.ingredients.stream().flatMap(ingredient -> ingredient.map(ProcessingIngredient::toIngredient).stream()).toList();
    }

    List<ResourceAmount> getFlatInputs() {
        MutableResourceListImpl list = MutableResourceListImpl.orderPreserving();
        this.ingredients.forEach(ingredient -> ingredient.map(ProcessingIngredient::input).ifPresent(list::add));
        return new ArrayList<ResourceAmount>(list.copyState());
    }

    List<ResourceAmount> getFlatOutputs() {
        MutableResourceListImpl list = MutableResourceListImpl.orderPreserving();
        this.outputs.forEach(output -> output.ifPresent(list::add));
        return new ArrayList<ResourceAmount>(list.copyState());
    }

    public record ProcessingIngredient(ResourceAmount input, List<ResourceLocation> allowedAlternativeIds) {
        public static final Codec<ProcessingIngredient> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceCodecs.AMOUNT_CODEC.fieldOf("input").forGetter(ProcessingIngredient::input), (App)Codec.list((Codec)ResourceLocation.CODEC).fieldOf("allowedAlternativeIds").forGetter(ProcessingIngredient::allowedAlternativeIds)).apply((Applicative)instance, ProcessingIngredient::new));
        public static final Codec<Optional<ProcessingIngredient>> OPTIONAL_CODEC = CODEC.optionalFieldOf("input").codec();
        public static final StreamCodec<RegistryFriendlyByteBuf, ProcessingIngredient> STREAM_CODEC = StreamCodec.composite(ResourceCodecs.AMOUNT_STREAM_CODEC, ProcessingIngredient::input, (StreamCodec)ByteBufCodecs.collection(ArrayList::new, (StreamCodec)ResourceLocation.STREAM_CODEC), ProcessingIngredient::allowedAlternativeIds, ProcessingIngredient::new);
        public static final StreamCodec<RegistryFriendlyByteBuf, Optional<ProcessingIngredient>> OPTIONAL_STREAM_CODEC = ByteBufCodecs.optional(STREAM_CODEC);

        public Ingredient toIngredient() {
            return new Ingredient(this.input.amount(), this.calculateInputsIncludingAlternatives());
        }

        public List<ResourceKey> calculateInputsIncludingAlternatives() {
            return Stream.concat(Stream.of(this.input.resource()), this.allowedAlternativeIds.stream().filter(id -> this.input.resource() instanceof PlatformResourceKey).map(id -> (PlatformResourceKey)this.input.resource()).flatMap(resource -> resource.getTags().stream().filter(tag -> this.allowedAlternativeIds.contains(tag.key().location())).flatMap(tag -> tag.resources().stream()))).toList();
        }
    }
}

