/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.api.support.network;

import com.refinedmods.refinedstorage.api.network.node.NetworkNode;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.network.InWorldNetworkNodeContainer;
import com.refinedmods.refinedstorage.common.api.support.network.NetworkNodeContainerProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="2.0.0-milestone.1.2")
public abstract class AbstractNetworkNodeContainerBlockEntity<T extends NetworkNode>
extends BlockEntity {
    protected final T mainNetworkNode;
    protected final NetworkNodeContainerProvider containers = this.createContainerProvider();

    protected AbstractNetworkNodeContainerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, T mainNetworkNode) {
        super(type, pos, state);
        this.containers.addContainer(this.createMainContainer(mainNetworkNode));
        this.mainNetworkNode = mainNetworkNode;
    }

    protected NetworkNodeContainerProvider createContainerProvider() {
        return RefinedStorageApi.INSTANCE.createNetworkNodeContainerProvider();
    }

    protected InWorldNetworkNodeContainer createMainContainer(T networkNode) {
        return RefinedStorageApi.INSTANCE.createNetworkNodeContainer(this, (NetworkNode)networkNode).build();
    }

    public void clearRemoved() {
        super.clearRemoved();
        this.containers.initialize(this.level, this::containerInitialized);
    }

    protected void containerInitialized() {
    }

    public void setRemoved() {
        super.setRemoved();
        this.containers.remove(this.level);
    }

    public final NetworkNodeContainerProvider getContainerProvider() {
        return this.containers;
    }
}

