/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.energy.EnergyStorage;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.common.Config;
import com.refinedmods.refinedstorage.common.PlatformProxy;
import com.refinedmods.refinedstorage.common.api.grid.strategy.GridInsertionStrategyFactory;
import com.refinedmods.refinedstorage.common.api.support.network.NetworkNodeContainerProvider;
import com.refinedmods.refinedstorage.common.api.support.resource.FluidOperationResult;
import com.refinedmods.refinedstorage.common.support.containermenu.MenuOpener;
import com.refinedmods.refinedstorage.common.support.containermenu.TransferManager;
import com.refinedmods.refinedstorage.common.support.render.FluidRenderer;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.BlockHitResult;

public interface Platform {
    public static final Platform INSTANCE = new PlatformProxy();

    public MenuOpener getMenuOpener();

    public long getBucketAmount();

    public Config getConfig();

    public boolean canEditBoxLoseFocus(EditBox var1);

    public boolean isKeyDown(KeyMapping var1);

    public GridInsertionStrategyFactory getDefaultGridInsertionStrategyFactory();

    public FluidRenderer getFluidRenderer();

    public Optional<FluidOperationResult> drainContainer(ItemStack var1);

    public Optional<FluidOperationResult> fillContainer(ItemStack var1, ResourceAmount var2);

    public TransferManager createTransferManager(AbstractContainerMenu var1);

    public long insertIntoContainer(Container var1, ItemResource var2, long var3, Action var5);

    public ItemStack getCloneItemStack(BlockState var1, Level var2, BlockHitResult var3, Player var4);

    public NonNullList<ItemStack> getRemainingCraftingItems(Player var1, CraftingRecipe var2, CraftingInput var3);

    public void onItemCrafted(Player var1, ItemStack var2, CraftingContainer var3);

    public Player getFakePlayer(ServerLevel var1, @Nullable UUID var2);

    public boolean canBreakBlock(Level var1, BlockPos var2, BlockState var3, Player var4);

    public boolean placeBlock(Level var1, BlockPos var2, Direction var3, Player var4, ItemStack var5);

    public boolean placeFluid(Level var1, BlockPos var2, Direction var3, Player var4, FluidResource var5);

    public ItemStack getBlockAsItemStack(Block var1, BlockState var2, Direction var3, LevelReader var4, BlockPos var5, Player var6);

    public Optional<SoundEvent> getBucketPickupSound(LiquidBlock var1, BlockState var2);

    public List<ClientTooltipComponent> processTooltipComponents(ItemStack var1, GuiGraphics var2, int var3, Optional<TooltipComponent> var4, List<Component> var5);

    public void renderTooltip(GuiGraphics var1, List<ClientTooltipComponent> var2, int var3, int var4);

    public Optional<EnergyStorage> getEnergyStorage(ItemStack var1);

    public <T extends CustomPacketPayload> void sendPacketToServer(T var1);

    public <T extends CustomPacketPayload> void sendPacketToClient(ServerPlayer var1, T var2);

    public void saveSavedData(SavedData var1, File var2, HolderLookup.Provider var3, BiConsumer<File, HolderLookup.Provider> var4);

    @Nullable
    public NetworkNodeContainerProvider getContainerProvider(Level var1, BlockPos var2, @Nullable Direction var3);

    @Nullable
    public NetworkNodeContainerProvider getContainerProviderSafely(Level var1, BlockPos var2, @Nullable Direction var3);

    public int getItemColor(ItemStack var1, int var2);

    public void setSlotY(Slot var1, int var2);

    public void requestModelDataUpdateOnClient(LevelAccessor var1, BlockPos var2, boolean var3);
}

