/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.storage.composite;

import com.refinedmods.refinedstorage.api.storage.Storage;
import com.refinedmods.refinedstorage.api.storage.composite.PriorityProvider;
import java.util.Comparator;

class PrioritizedStorageComparator
implements Comparator<Storage> {
    static final Comparator<Storage> INSERT = new PrioritizedStorageComparator(PriorityProvider::getInsertPriority);
    static final Comparator<Storage> EXTRACT = new PrioritizedStorageComparator(PriorityProvider::getExtractPriority);
    private final PriorityExtractor priorityExtractor;

    private PrioritizedStorageComparator(PriorityExtractor priorityExtractor) {
        this.priorityExtractor = priorityExtractor;
    }

    private int extractPriority(Storage storage) {
        if (storage instanceof PriorityProvider) {
            PriorityProvider priorityProvider = (PriorityProvider)((Object)storage);
            return this.priorityExtractor.getPriority(priorityProvider);
        }
        return 0;
    }

    @Override
    public int compare(Storage a, Storage b) {
        return Integer.compare(this.extractPriority(b), this.extractPriority(a));
    }

    @FunctionalInterface
    private static interface PriorityExtractor {
        public int getPriority(PriorityProvider var1);
    }
}

